/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.connection.PaperConfigurationTask;
import io.papermc.paper.connection.PaperPlayerConfigurationConnection;
import io.papermc.paper.connection.PlayerCommonConnection;
import io.papermc.paper.connection.PlayerConfigurationConnection;
import io.papermc.paper.connection.PlayerConnection;
import io.papermc.paper.event.connection.configuration.PlayerConnectionInitialConfigureEvent;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.translation.Translator;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundServerLinksPacket;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.configuration.ClientboundUpdateEnabledFeaturesPacket;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.network.protocol.configuration.ServerboundAcceptCodeOfConductPacket;
import net.minecraft.network.protocol.configuration.ServerboundFinishConfigurationPacket;
import net.minecraft.network.protocol.configuration.ServerboundSelectKnownPacks;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.config.JoinWorldTask;
import net.minecraft.server.network.config.PrepareSpawnTask;
import net.minecraft.server.network.config.ServerCodeOfConductConfigurationTask;
import net.minecraft.server.network.config.ServerResourcePackConfigurationTask;
import net.minecraft.server.network.config.SynchronizeRegistriesTask;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.flag.FeatureFlags;
import org.bukkit.craftbukkit.v1_21_R7.CraftServerLinks;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.player.PlayerLinksSendEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ServerConfigurationPacketListenerImpl
extends ServerCommonPacketListenerImpl
implements ServerConfigurationPacketListener,
TickablePacketListener {
    private static final Logger f = LogUtils.getLogger();
    private static final IChatBaseComponent g = IChatBaseComponent.c("multiplayer.disconnect.invalid_player_data");
    private static final IChatBaseComponent h = IChatBaseComponent.c("multiplayer.disconnect.configuration_error");
    private final GameProfile i;
    private final Queue<ConfigurationTask> j = new ConcurrentLinkedQueue<ConfigurationTask>();
    public @Nullable ConfigurationTask k;
    public ClientInformation l;
    private @Nullable SynchronizeRegistriesTask m;
    private @Nullable PrepareSpawnTask n;
    public PaperPlayerConfigurationConnection paperConnection;

    public ServerConfigurationPacketListenerImpl(MinecraftServer server, NetworkManager connection, CommonListenerCookie cookie) {
        super(server, connection, cookie);
        this.i = cookie.a();
        this.l = cookie.c();
        this.paperConnection = new PaperPlayerConfigurationConnection(this);
    }

    @Override
    public PlayerCommonConnection getApiConnection() {
        return this.paperConnection;
    }

    @Override
    public Audience getAudience() {
        return this.paperConnection.getAudience();
    }

    @Override
    protected GameProfile i() {
        return this.i;
    }

    @Override
    public void a(DisconnectionDetails details) {
        if (this.d.isDebugging()) {
            f.info("{} ({}) lost connection: {}, while in configuration phase {}", new Object[]{this.i.name(), this.i.id(), details.a().getString(), this.k != null ? this.k.b().a() : "null"});
        } else {
            f.info("{} ({}) lost connection: {}", new Object[]{this.i.name(), this.i.id(), details.a().getString()});
        }
        if (this.n != null) {
            this.n.d();
            this.n = null;
        }
        super.a(details);
    }

    @Override
    public boolean c() {
        return this.e.i();
    }

    public void l() {
        new PlayerConnectionInitialConfigureEvent((PlayerConfigurationConnection)this.paperConnection).callEvent();
        this.b(new ClientboundCustomPayloadPacket(new BrandPayload(this.d.getServerModName())));
        ServerLinks serverLinks = this.d.bt();
        if (!serverLinks.a()) {
            CraftServerLinks links = new CraftServerLinks(serverLinks);
            new PlayerLinksSendEvent((PlayerConfigurationConnection)this.paperConnection, (org.bukkit.ServerLinks)links).callEvent();
            this.b(new ClientboundServerLinksPacket(links.getServerLinks().b()));
        }
        LayeredRegistryAccess<RegistryLayer> layeredRegistryAccess = this.d.bd();
        List<KnownPack> list = this.d.bg().b().flatMap(packResources -> packResources.a().d().stream()).toList();
        this.b(new ClientboundUpdateEnabledFeaturesPacket(FeatureFlags.e.b(this.d.bb().J())));
        this.m = new SynchronizeRegistriesTask(list, layeredRegistryAccess);
        this.j.add(this.m);
        this.n();
        this.j.add(new PaperConfigurationTask(this));
        this.m();
    }

    public void m() {
        this.n = new PrepareSpawnTask(this.d, this.i, this);
        this.j.add(this.n);
        this.j.add(new JoinWorldTask());
        this.o();
    }

    private void n() {
        Map<String, String> codeOfConducts = this.d.ab();
        if (!codeOfConducts.isEmpty()) {
            this.j.add(new ServerCodeOfConductConfigurationTask(() -> {
                String string = (String)codeOfConducts.get(this.l.b().toLowerCase(Locale.ROOT));
                if (string == null) {
                    string = (String)codeOfConducts.get("en_us");
                }
                if (string == null) {
                    string = (String)codeOfConducts.values().iterator().next();
                }
                return string;
            }));
        }
        this.d.ac().ifPresent(serverResourcePackInfo -> this.j.add(new ServerResourcePackConfigurationTask((MinecraftServer.ServerResourcePackInfo)serverResourcePackInfo)));
    }

    @Override
    public void a(ServerboundClientInformationPacket packet) {
        this.l = packet.b();
        this.e.k.attr(PaperAdventure.LOCALE_ATTRIBUTE).set((Object)Translator.parseLocale((String)packet.b().b()));
    }

    @Override
    public void a(ServerboundResourcePackPacket packet) {
        super.a(packet);
        this.e.resourcePackStatus = PlayerResourcePackStatusEvent.Status.values()[packet.e().ordinal()];
        if (packet.e().a() && packet.b().equals(this.d.ac().map(MinecraftServer.ServerResourcePackInfo::a).orElse(null))) {
            this.a(ServerResourcePackConfigurationTask.a);
        }
    }

    @Override
    public void a(ServerboundSelectKnownPacks packet) {
        PlayerConnectionUtils.a(packet, this, this.d.bv());
        if (this.m == null) {
            throw new IllegalStateException("Unexpected response from client: received pack selection, but no negotiation ongoing");
        }
        this.m.a(packet.b(), this::b);
        this.a(SynchronizeRegistriesTask.a);
    }

    @Override
    public void a(ServerboundAcceptCodeOfConductPacket packet) {
        this.a(ServerCodeOfConductConfigurationTask.a);
    }

    @Override
    public void a(ServerboundFinishConfigurationPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.d.bv());
        this.a(JoinWorldTask.a);
        this.e.a(GameProtocols.c.a(RegistryFriendlyByteBuf.a(this.d.bc())));
        try {
            PlayerList playerList = this.d.aj();
            if (playerList.b(this.i.id()) != null) {
                this.a(PlayerList.f);
                return;
            }
            IChatBaseComponent component = CraftEventFactory.handleLoginResult(playerList.canPlayerLogin(this.e.d(), new NameAndId(this.i)), (PlayerConnection)this.paperConnection, this.e, this.i, this.d, false);
            if (component != null) {
                this.a(component);
                return;
            }
            Objects.requireNonNull(this.n).a(this.e, this.a(this.l));
        }
        catch (Exception var4) {
            f.error("Couldn't place player in world", (Throwable)var4);
            this.a(g);
        }
    }

    @Override
    public void d() {
        this.e();
        ConfigurationTask configurationTask = this.k;
        if (configurationTask != null) {
            try {
                if (configurationTask.a()) {
                    this.a(configurationTask.b());
                }
            }
            catch (Exception var3) {
                f.error("Failed to tick configuration task {}", (Object)configurationTask.b(), (Object)var3);
                this.a(h);
            }
        }
        if (this.n != null) {
            this.n.c();
        }
    }

    private void o() {
        ConfigurationTask configurationTask;
        if (this.k != null) {
            throw new IllegalStateException("Task " + this.k.b().a() + " has not finished yet");
        }
        if (this.c() && (configurationTask = this.j.poll()) != null) {
            this.k = configurationTask;
            try {
                configurationTask.a(this::b);
            }
            catch (Exception var3) {
                f.error("Failed to start configuration task {}", (Object)configurationTask.b(), (Object)var3);
                this.a(h);
            }
        }
    }

    public void a(ConfigurationTask.a taskType) {
        ConfigurationTask.a type;
        ConfigurationTask.a a2 = type = this.k != null ? this.k.b() : null;
        if (!taskType.equals(type)) {
            throw new IllegalStateException("Unexpected request for task finish, current task: " + String.valueOf(type) + ", requested: " + String.valueOf(taskType));
        }
        this.k = null;
        this.o();
    }

    @Override
    public void disconnectAsync(DisconnectionDetails disconnectionInfo) {
        if (this.cserver.isPrimaryThread()) {
            this.b(disconnectionInfo);
            return;
        }
        this.e.m();
        this.d.scheduleOnMain(() -> this.b(disconnectionInfo));
    }

    @Override
    public void a(ServerboundCustomPayloadPacket packet) {
        super.a(packet);
    }

    public PaperPlayerConfigurationConnection paperConnection() {
        return this.paperConnection;
    }
}

