/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.velocitypowered.natives.util.Natives;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.local.LocalAddress;
import io.netty.handler.codec.haproxy.HAProxyCommand;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.network.ChannelInitializeListenerHolder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.NetworkManagerServer;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.EventLoopGroupHolder;
import net.minecraft.server.network.HandshakeListener;
import net.minecraft.server.network.LegacyPingHandler;
import net.minecraft.server.network.MemoryServerHandshakePacketListenerImpl;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerConnection {
    private static final Logger b = LogUtils.getLogger();
    final MinecraftServer c;
    public volatile boolean a;
    private final List<ChannelFuture> d = Collections.synchronizedList(Lists.newArrayList());
    final List<NetworkManager> e = Collections.synchronizedList(Lists.newArrayList());
    private final Queue<NetworkManager> pending = new ConcurrentLinkedQueue<NetworkManager>();
    private static final boolean disableFlushConsolidation = Boolean.getBoolean("Paper.disableFlushConsolidate");

    public ServerConnection(MinecraftServer server) {
        this.c = server;
        this.a = true;
    }

    private final void addPending() {
        NetworkManager connection;
        while ((connection = this.pending.poll()) != null) {
            this.e.add(connection);
            connection.isPending = false;
        }
    }

    public void a(@Nullable InetAddress address, int port) throws IOException {
        this.startTcpServerListener(new InetSocketAddress(address, port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTcpServerListener(SocketAddress address) throws IOException {
        List<ChannelFuture> list = this.d;
        synchronized (list) {
            EventLoopGroupHolder eventLoopGroupHolder = EventLoopGroupHolder.remote(address, this.c.p());
            if (GlobalConfiguration.get().proxies.proxyProtocol) {
                b.warn("Using HAProxy, please ensure the server port is adequately firewalled.");
            }
            b.info("Paper: Using " + Natives.compress.getLoadedVariant() + " compression from Velocity.");
            b.info("Paper: Using " + Natives.cipher.getLoadedVariant() + " cipher from Velocity.");
            this.d.add(((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(eventLoopGroupHolder.e())).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(final Channel channel) {
                    NetworkManager connection;
                    try {
                        channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                    }
                    catch (ChannelException channelException) {
                        // empty catch block
                    }
                    if (!disableFlushConsolidation) {
                        channel.pipeline().addFirst(new ChannelHandler[]{new FlushConsolidationHandler()});
                    }
                    ChannelPipeline channelPipeline = channel.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30));
                    if (ServerConnection.this.c.an()) {
                        channelPipeline.addLast("legacy_query", (ChannelHandler)new LegacyPingHandler(ServerConnection.this.d()));
                    }
                    NetworkManager.a(channelPipeline, EnumProtocolDirection.a, false, null);
                    int rateLimitPacketsPerSecond = ServerConnection.this.c.o();
                    NetworkManager networkManager = connection = rateLimitPacketsPerSecond > 0 ? new NetworkManagerServer(rateLimitPacketsPerSecond) : new NetworkManager(EnumProtocolDirection.a);
                    if (GlobalConfiguration.get().proxies.proxyProtocol) {
                        channel.pipeline().addAfter("timeout", "haproxy-decoder", (ChannelHandler)new HAProxyMessageDecoder());
                        channel.pipeline().addAfter("haproxy-decoder", "haproxy-handler", (ChannelHandler)new ChannelInboundHandlerAdapter(this){

                            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                                if (msg instanceof HAProxyMessage) {
                                    HAProxyMessage message = (HAProxyMessage)msg;
                                    if (message.command() == HAProxyCommand.PROXY) {
                                        String realaddress = message.sourceAddress();
                                        int realport = message.sourcePort();
                                        InetSocketAddress socketaddr = new InetSocketAddress(realaddress, realport);
                                        NetworkManager connection = (NetworkManager)channel.pipeline().get("packet_handler");
                                        connection.l = socketaddr;
                                        String proxyAddress = message.destinationAddress();
                                        int proxyPort = message.destinationPort();
                                        connection.haProxyAddress = new InetSocketAddress(proxyAddress, proxyPort);
                                    }
                                } else {
                                    super.channelRead(ctx, msg);
                                }
                            }
                        });
                    }
                    ServerConnection.this.pending.add(connection);
                    connection.a(channelPipeline);
                    connection.a(new HandshakeListener(ServerConnection.this.c, connection));
                    ChannelInitializeListenerHolder.callListeners(channel);
                }
            }).group(eventLoopGroupHolder.c()).localAddress(address)).option(ChannelOption.AUTO_READ, (Object)false)).bind().syncUninterruptibly());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptConnections() {
        List<ChannelFuture> list = this.d;
        synchronized (list) {
            for (ChannelFuture future : this.d) {
                future.channel().config().setAutoRead(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress a() {
        ChannelFuture channelFuture;
        List<ChannelFuture> list = this.d;
        synchronized (list) {
            channelFuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(EventLoopGroupHolder.a().e())).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) {
                    NetworkManager connection = new NetworkManager(EnumProtocolDirection.a);
                    connection.a(new MemoryServerHandshakePacketListenerImpl(ServerConnection.this.c, connection));
                    ServerConnection.this.e.add(connection);
                    ChannelPipeline channelPipeline = channel.pipeline();
                    NetworkManager.a(channelPipeline, EnumProtocolDirection.a);
                    if (SharedConstants.aJ > 0) {
                        channelPipeline.addLast("latency", (ChannelHandler)new LatencySimulator(SharedConstants.aJ, SharedConstants.aK));
                    }
                    connection.a(channelPipeline);
                }
            }).group(EventLoopGroupHolder.a().c()).localAddress((SocketAddress)LocalAddress.ANY)).bind().syncUninterruptibly();
            this.d.add(channelFuture);
        }
        return channelFuture.channel().localAddress();
    }

    public void b() {
        this.a = false;
        for (ChannelFuture channelFuture : this.d) {
            try {
                channelFuture.channel().close().sync();
            }
            catch (InterruptedException var4) {
                b.error("Interrupted whilst closing channel");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void c() {
        List<NetworkManager> list = this.e;
        synchronized (list) {
            this.addPending();
            if (SpigotConfig.playerShuffle > 0 && MinecraftServer.currentTick % SpigotConfig.playerShuffle == 0) {
                Collections.shuffle(this.e);
            }
            Iterator<NetworkManager> iterator = this.e.iterator();
            while (iterator.hasNext()) {
                NetworkManager connection = iterator.next();
                if (connection.j()) continue;
                if (connection.i()) {
                    try {
                        connection.b();
                    }
                    catch (Exception var7) {
                        if (connection.e()) {
                            throw new ReportedException(CrashReport.a(var7, "Ticking memory connection"));
                        }
                        b.warn("Failed to handle packet for {}", (Object)connection.a(this.c.bn()), (Object)var7);
                        IChatMutableComponent component = IChatBaseComponent.b("Internal server error");
                        connection.a(new ClientboundDisconnectPacket(component), PacketSendListener.a(() -> connection.a(component)));
                        connection.m();
                    }
                    continue;
                }
                if (connection.preparing) continue;
                iterator.remove();
                connection.n();
            }
        }
    }

    public MinecraftServer d() {
        return this.c;
    }

    public List<NetworkManager> e() {
        return this.e;
    }

    static class LatencySimulator
    extends ChannelInboundHandlerAdapter {
        private static final Timer a = new HashedWheelTimer();
        private final int b;
        private final int c;
        private final List<DelayedMessage> d = Lists.newArrayList();

        public LatencySimulator(int delay, int jitter) {
            this.b = delay;
            this.c = jitter;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            this.a(ctx, msg);
        }

        private void a(ChannelHandlerContext ctx, Object msg) {
            int i2 = this.b + (int)(Math.random() * (double)this.c);
            this.d.add(new DelayedMessage(ctx, msg));
            a.newTimeout(this::a, (long)i2, TimeUnit.MILLISECONDS);
        }

        private void a(Timeout timeout) {
            DelayedMessage delayedMessage = this.d.remove(0);
            delayedMessage.a.fireChannelRead(delayedMessage.b);
        }

        static class DelayedMessage {
            public final ChannelHandlerContext a;
            public final Object b;

            public DelayedMessage(ChannelHandlerContext ctx, Object msg) {
                this.a = ctx;
                this.b = msg;
            }
        }
    }
}

