/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jspecify.annotations.Nullable;

public class CompositePackResources
implements IResourcePack {
    private final IResourcePack c;
    private final List<IResourcePack> d;

    public CompositePackResources(IResourcePack primaryPackResources, List<IResourcePack> packResourcesStack) {
        this.c = primaryPackResources;
        ArrayList<IResourcePack> list = new ArrayList<IResourcePack>(packResourcesStack.size() + 1);
        list.addAll(Lists.reverse(packResourcesStack));
        list.add(primaryPackResources);
        this.d = List.copyOf(list);
    }

    @Override
    public @Nullable IoSupplier<InputStream> a(String ... elements) {
        return this.c.a(elements);
    }

    @Override
    public @Nullable IoSupplier<InputStream> a(EnumResourcePackType packType, MinecraftKey location) {
        for (IResourcePack packResources : this.d) {
            IoSupplier<InputStream> resource = packResources.a(packType, location);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public void a(EnumResourcePackType packType, String namespace, String path, IResourcePack.a resourceOutput) {
        HashMap<MinecraftKey, IoSupplier<InputStream>> map = new HashMap<MinecraftKey, IoSupplier<InputStream>>();
        for (IResourcePack packResources : this.d) {
            packResources.a(packType, namespace, path, map::putIfAbsent);
        }
        map.forEach(resourceOutput);
    }

    @Override
    public Set<String> a(EnumResourcePackType type) {
        HashSet<String> set = new HashSet<String>();
        for (IResourcePack packResources : this.d) {
            set.addAll(packResources.a(type));
        }
        return set;
    }

    @Override
    public <T> @Nullable T a(MetadataSectionType<T> type) throws IOException {
        return this.c.a(type);
    }

    @Override
    public PackLocationInfo a() {
        return this.c.a();
    }

    @Override
    public void close() {
        this.d.forEach(IResourcePack::close);
    }
}

