/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.packs.DownloadCacheCleaner;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.FileUtils;
import net.minecraft.util.HttpUtilities;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.eventlog.JsonEventLog;
import net.minecraft.util.thread.ConsecutiveExecutor;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class DownloadQueue
implements AutoCloseable {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 20;
    private final Path c;
    private final JsonEventLog<e> d;
    private final ConsecutiveExecutor e = new ConsecutiveExecutor(SystemUtils.j(), "download-queue");

    public DownloadQueue(Path cacheDir) throws IOException {
        this.c = cacheDir;
        FileUtils.c(cacheDir);
        this.d = JsonEventLog.a(net.minecraft.server.packs.DownloadQueue$e.a, cacheDir.resolve("log.json"));
        DownloadCacheCleaner.a(cacheDir, 20);
    }

    private b b(a batchConfig, Map<UUID, c> downloads) {
        b batchResult = new b();
        downloads.forEach((uuid, request) -> {
            Path path = this.c.resolve(uuid.toString());
            Path path1 = null;
            try {
                path1 = HttpUtilities.a(path, request.a, batchConfig.c, batchConfig.a, request.b, batchConfig.b, batchConfig.d, batchConfig.e);
                batchResult.a.put((UUID)uuid, path1);
            }
            catch (Exception var9) {
                a.error("Failed to download {}", (Object)request.a, (Object)var9);
                batchResult.b.add((UUID)uuid);
            }
            try {
                this.d.a(new e((UUID)uuid, request.a.toString(), Instant.now(), Optional.ofNullable(request.b).map(HashCode::toString), path1 != null ? this.a(path1) : Either.left("download_failed")));
            }
            catch (Exception var8) {
                a.error("Failed to log download of {}", (Object)request.a, (Object)var8);
            }
        });
        return batchResult;
    }

    private Either<String, d> a(Path path) {
        try {
            long size = Files.size(path);
            Path path1 = this.c.relativize(path);
            return Either.right(new d(path1.toString(), size));
        }
        catch (IOException var5) {
            a.error("Failed to get file size of {}", (Object)path, (Object)var5);
            return Either.left("no_access");
        }
    }

    public CompletableFuture<b> a(a batchConfig, Map<UUID, c> downloads) {
        return CompletableFuture.supplyAsync(() -> this.b(batchConfig, downloads), this.e::a_);
    }

    @Override
    public void close() throws IOException {
        this.e.close();
        this.d.close();
    }

    static final class e
    extends Record {
        private final UUID b;
        private final String c;
        private final Instant d;
        private final Optional<String> e;
        private final Either<String, d> f;
        public static final Codec<e> a = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.d.fieldOf("id").forGetter(e::a), (App)Codec.STRING.fieldOf("url").forGetter(e::b), (App)ExtraCodecs.x.fieldOf("time").forGetter(e::c), (App)Codec.STRING.optionalFieldOf("hash").forGetter(e::d), (App)Codec.mapEither((MapCodec)Codec.STRING.fieldOf("error"), (MapCodec)net.minecraft.server.packs.DownloadQueue$d.a.fieldOf("file")).forGetter(e::e)).apply((Applicative)instance, e::new));

        e(UUID id, String url, Instant time, Optional<String> hash, Either<String, d> errorOrFileInfo) {
            this.b = id;
            this.c = url;
            this.d = time;
            this.e = hash;
            this.f = errorOrFileInfo;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "id;url;time;hash;errorOrFileInfo", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "id;url;time;hash;errorOrFileInfo", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "id;url;time;hash;errorOrFileInfo", "b", "c", "d", "e", "f"}, this, o2);
        }

        public UUID a() {
            return this.b;
        }

        public String b() {
            return this.c;
        }

        public Instant c() {
            return this.d;
        }

        public Optional<String> d() {
            return this.e;
        }

        public Either<String, d> e() {
            return this.f;
        }
    }

    public record b(Map<UUID, Path> a, Set<UUID> b) {
        public b() {
            this(new HashMap<UUID, Path>(), new HashSet<UUID>());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "downloaded;failed", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "downloaded;failed", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "downloaded;failed", "a", "b"}, this, o2);
        }
    }

    public record a(HashFunction a, int b, Map<String, String> c, Proxy d, HttpUtilities.a e) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "hashFunction;maxSize;headers;proxy;listener", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "hashFunction;maxSize;headers;proxy;listener", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "hashFunction;maxSize;headers;proxy;listener", "a", "b", "c", "d", "e"}, this, o2);
        }
    }

    static final class d
    extends Record {
        private final String b;
        private final long c;
        public static final Codec<d> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(d::a), (App)Codec.LONG.fieldOf("size").forGetter(d::b)).apply((Applicative)instance, d::new));

        d(String name, long size) {
            this.b = name;
            this.c = size;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "name;size", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "name;size", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "name;size", "b", "c"}, this, o2);
        }

        public String a() {
            return this.b;
        }

        public long b() {
            return this.c;
        }
    }

    public record c(URL a, @Nullable HashCode b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "url;hash", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "url;hash", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "url;hash", "a", "b"}, this, o2);
        }
    }
}

