/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.metadata.pack.PackFormat;
import net.minecraft.util.InclusiveRange;

public final class OverlayMetadataSection
extends Record {
    private final List<a> c;
    private static final Pattern d = Pattern.compile("[-_a-zA-Z0-9.]+");
    public static final MetadataSectionType<OverlayMetadataSection> a = new MetadataSectionType<OverlayMetadataSection>("overlays", OverlayMetadataSection.a(EnumResourcePackType.a));
    public static final MetadataSectionType<OverlayMetadataSection> b = new MetadataSectionType<OverlayMetadataSection>("overlays", OverlayMetadataSection.a(EnumResourcePackType.b));

    public OverlayMetadataSection(List<a> overlays) {
        this.c = overlays;
    }

    private static DataResult<String> a(String directoryName) {
        return !d.matcher(directoryName).matches() ? DataResult.error(() -> directoryName + " is not accepted directory name") : DataResult.success((Object)directoryName);
    }

    @VisibleForTesting
    public static Codec<OverlayMetadataSection> a(EnumResourcePackType packType) {
        return RecordCodecBuilder.create(instance -> instance.group((App)net.minecraft.server.packs.OverlayMetadataSection$a.a(packType).fieldOf("entries").forGetter(OverlayMetadataSection::a)).apply((Applicative)instance, OverlayMetadataSection::new));
    }

    public static MetadataSectionType<OverlayMetadataSection> b(EnumResourcePackType packType) {
        return switch (packType) {
            default -> throw new MatchException(null, null);
            case EnumResourcePackType.a -> a;
            case EnumResourcePackType.b -> b;
        };
    }

    public List<String> a(PackFormat packFormat) {
        return this.c.stream().filter(overlay -> overlay.a(packFormat)).map(a::b).toList();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{OverlayMetadataSection.class, "overlays", "c"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OverlayMetadataSection.class, "overlays", "c"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OverlayMetadataSection.class, "overlays", "c"}, this, o2);
    }

    public List<a> a() {
        return this.c;
    }

    public record net.minecraft.server.packs.OverlayMetadataSection$a(InclusiveRange<PackFormat> a, String b) {
        static Codec<List<net.minecraft.server.packs.OverlayMetadataSection$a>> a(EnumResourcePackType packType) {
            int i2 = PackFormat.a(packType);
            return a.c.listOf().flatXmap(list -> PackFormat.a(list, i2, (intermediateEntry, inclusiveRange) -> new net.minecraft.server.packs.OverlayMetadataSection$a((InclusiveRange<PackFormat>)inclusiveRange, intermediateEntry.b())), list -> DataResult.success(list.stream().map(overlayEntry -> new a(PackFormat.a.a(overlayEntry.a(), i2), overlayEntry.b())).toList()));
        }

        public boolean a(PackFormat packFormat) {
            return this.a.a(packFormat);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{net.minecraft.server.packs.OverlayMetadataSection$a.class, "format;overlay", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{net.minecraft.server.packs.OverlayMetadataSection$a.class, "format;overlay", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{net.minecraft.server.packs.OverlayMetadataSection$a.class, "format;overlay", "a", "b"}, this, o2);
        }

        record a(PackFormat.a a, String b) implements PackFormat.b
        {
            static final Codec<a> c = RecordCodecBuilder.create(instance -> instance.group((App)PackFormat.a.a.forGetter(a::a), (App)Codec.STRING.validate(OverlayMetadataSection::a).fieldOf("directory").forGetter(a::b)).apply((Applicative)instance, a::new));

            @Override
            public String toString() {
                return this.b;
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "format;overlay", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "format;overlay", "a", "b"}, this, o2);
            }
        }
    }
}

