/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.CompositePackResources;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.ResourcePackAbstract;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.commons.io.IOUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ResourcePackFile
extends ResourcePackAbstract {
    static final Logger c = LogUtils.getLogger();
    private final b d;
    private final String e;

    ResourcePackFile(PackLocationInfo location, b zipFileAccess, String prefix) {
        super(location);
        this.d = zipFileAccess;
        this.e = prefix;
    }

    private static String b(EnumResourcePackType packType, MinecraftKey location) {
        return String.format(Locale.ROOT, "%s/%s/%s", packType.a(), location.b(), location.a());
    }

    @Override
    public @Nullable IoSupplier<InputStream> a(String ... elements) {
        return this.b(String.join((CharSequence)"/", elements));
    }

    @Override
    public IoSupplier<InputStream> a(EnumResourcePackType packType, MinecraftKey location) {
        return this.b(ResourcePackFile.b(packType, location));
    }

    private String a(String resourcePath) {
        return this.e.isEmpty() ? resourcePath : this.e + "/" + resourcePath;
    }

    private @Nullable IoSupplier<InputStream> b(String resourcePath) {
        ZipFile zipFile = this.d.a();
        if (zipFile == null) {
            return null;
        }
        ZipEntry entry = zipFile.getEntry(this.a(resourcePath));
        return entry == null ? null : IoSupplier.create(zipFile, entry);
    }

    @Override
    public Set<String> a(EnumResourcePackType type) {
        ZipFile zipFile = this.d.a();
        if (zipFile == null) {
            return Set.of();
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        HashSet set = Sets.newHashSet();
        String string = this.a(type.a() + "/");
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String name = zipEntry.getName();
            String string1 = ResourcePackFile.a(string, name);
            if (string1.isEmpty()) continue;
            if (MinecraftKey.j(string1)) {
                set.add(string1);
                continue;
            }
            c.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)string1, (Object)this.d.a);
        }
        return set;
    }

    @VisibleForTesting
    public static String a(String directory, String name) {
        if (!name.startsWith(directory)) {
            return "";
        }
        int len = directory.length();
        int index = name.indexOf(47, len);
        return index == -1 ? name.substring(len) : name.substring(len, index);
    }

    @Override
    public void close() {
        this.d.close();
    }

    @Override
    public void a(EnumResourcePackType packType, String namespace, String path, IResourcePack.a resourceOutput) {
        ZipFile zipFile = this.d.a();
        if (zipFile != null) {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            String string = this.a(packType.a() + "/" + namespace + "/");
            String string1 = string + path + "/";
            while (enumeration.hasMoreElements()) {
                String name;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory() || !(name = zipEntry.getName()).startsWith(string1)) continue;
                String sub = name.substring(string.length());
                MinecraftKey identifier = MinecraftKey.b(namespace, sub);
                if (identifier != null) {
                    resourceOutput.accept(identifier, IoSupplier.create(zipFile, zipEntry));
                    continue;
                }
                c.warn("Invalid path in datapack: {}:{}, ignoring", (Object)namespace, (Object)sub);
            }
        }
    }

    static class b
    implements AutoCloseable {
        final File a;
        private @Nullable ZipFile b;
        private boolean c;

        b(File file) {
            this.a = file;
        }

        @Nullable ZipFile a() {
            if (this.c) {
                return null;
            }
            if (this.b == null) {
                try {
                    this.b = new ZipFile(this.a);
                }
                catch (IOException var2) {
                    c.error("Failed to open pack {}", (Object)this.a, (Object)var2);
                    this.c = true;
                    return null;
                }
            }
            return this.b;
        }

        @Override
        public void close() {
            if (this.b != null) {
                IOUtils.closeQuietly((Closeable)this.b);
                this.b = null;
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    public static class a
    implements ResourcePackLoader.c {
        private final File a;

        public a(Path content) {
            this(content.toFile());
        }

        public a(File content) {
            this.a = content;
        }

        @Override
        public IResourcePack a(PackLocationInfo location) {
            b sharedZipFileAccess = new b(this.a);
            return new ResourcePackFile(location, sharedZipFileAccess, "");
        }

        @Override
        public IResourcePack a(PackLocationInfo location, ResourcePackLoader.a metadata) {
            b sharedZipFileAccess = new b(this.a);
            ResourcePackFile packResources = new ResourcePackFile(location, sharedZipFileAccess, "");
            List<String> list = metadata.d();
            if (list.isEmpty()) {
                return packResources;
            }
            ArrayList<IResourcePack> list1 = new ArrayList<IResourcePack>(list.size());
            for (String string : list) {
                list1.add(new ResourcePackFile(location, sharedZipFileAccess, string));
            }
            return new CompositePackResources(packResources, list1);
        }
    }
}

