/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.ResourcePackAbstract;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.FileUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ResourcePackVanilla
implements IResourcePack {
    private static final Logger c = LogUtils.getLogger();
    private final PackLocationInfo d;
    private final BuiltInMetadata e;
    private final Set<String> f;
    private final List<Path> g;
    private final Map<EnumResourcePackType, List<Path>> h;

    ResourcePackVanilla(PackLocationInfo location, BuiltInMetadata metadata, Set<String> namespaces, List<Path> rootPaths, Map<EnumResourcePackType, List<Path>> pathsForType) {
        this.d = location;
        this.e = metadata;
        this.f = namespaces;
        this.g = rootPaths;
        this.h = pathsForType;
    }

    @Override
    public @Nullable IoSupplier<InputStream> a(String ... elements) {
        FileUtils.a(elements);
        List<String> list = List.of(elements);
        for (Path path : this.g) {
            Path path1 = FileUtils.a(path, list);
            if (!Files.exists(path1, new LinkOption[0]) || !PathPackResources.a(path1)) continue;
            return IoSupplier.create(path1);
        }
        return null;
    }

    public void a(EnumResourcePackType packType, MinecraftKey packLocation, Consumer<Path> output) {
        FileUtils.e(packLocation.a()).ifSuccess(elements -> {
            String namespace = packLocation.b();
            for (Path path : this.h.get((Object)packType)) {
                Path path1 = path.resolve(namespace);
                output.accept(FileUtils.a(path1, elements));
            }
        }).ifError(error -> c.error("Invalid path {}: {}", (Object)packLocation, (Object)error.message()));
    }

    @Override
    public void a(EnumResourcePackType packType, String namespace, String path, IResourcePack.a resourceOutput) {
        FileUtils.e(path).ifSuccess(paths -> {
            List<Path> list = this.h.get((Object)packType);
            int size = list.size();
            if (size == 1) {
                ResourcePackVanilla.a(resourceOutput, namespace, list.get(0), paths);
            } else if (size > 1) {
                HashMap<MinecraftKey, IoSupplier<InputStream>> map = new HashMap<MinecraftKey, IoSupplier<InputStream>>();
                for (int i2 = 0; i2 < size - 1; ++i2) {
                    ResourcePackVanilla.a(map::putIfAbsent, namespace, list.get(i2), paths);
                }
                Path path1 = list.get(size - 1);
                if (map.isEmpty()) {
                    ResourcePackVanilla.a(resourceOutput, namespace, path1, paths);
                } else {
                    ResourcePackVanilla.a(map::putIfAbsent, namespace, path1, paths);
                    map.forEach(resourceOutput);
                }
            }
        }).ifError(error -> c.error("Invalid path {}: {}", (Object)path, (Object)error.message()));
    }

    private static void a(IResourcePack.a resourceOutput, String namespace, Path root, List<String> paths) {
        Path path = root.resolve(namespace);
        PathPackResources.a(namespace, path, paths, resourceOutput);
    }

    @Override
    public @Nullable IoSupplier<InputStream> a(EnumResourcePackType packType, MinecraftKey location) {
        return (IoSupplier)FileUtils.e(location.a()).mapOrElse(paths -> {
            String namespace = location.b();
            for (Path path : this.h.get((Object)packType)) {
                Path path1 = FileUtils.a(path.resolve(namespace), paths);
                if (!Files.exists(path1, new LinkOption[0]) || !PathPackResources.a(path1)) continue;
                return IoSupplier.create(path1);
            }
            return null;
        }, error -> {
            c.error("Invalid path {}: {}", (Object)location, (Object)error.message());
            return null;
        });
    }

    @Override
    public Set<String> a(EnumResourcePackType type) {
        return this.f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> @Nullable T a(MetadataSectionType<T> type) {
        IoSupplier<InputStream> rootResource = this.a("pack.mcmeta");
        if (rootResource == null) return this.e.a(type);
        try (InputStream inputStream = rootResource.get();){
            T metadataFromStream = ResourcePackAbstract.a(type, inputStream, this.d);
            if (metadataFromStream != null) {
                T t2 = metadataFromStream;
                return t2;
            }
            T t3 = this.e.a(type);
            return t3;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.e.a(type);
    }

    @Override
    public PackLocationInfo a() {
        return this.d;
    }

    @Override
    public void close() {
    }

    public ResourceProvider d() {
        return location -> Optional.ofNullable(this.a(EnumResourcePackType.a, location)).map(ioSupplier -> new IResource(this, (IoSupplier<InputStream>)ioSupplier));
    }
}

