/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.ResourcePackVanilla;
import net.minecraft.util.FileSystemUtil;
import net.minecraft.util.SystemUtils;
import org.slf4j.Logger;

public class VanillaPackResourcesBuilder {
    private static final Logger b = LogUtils.getLogger();
    public static Consumer<VanillaPackResourcesBuilder> a = builder -> {};
    private static final Map<EnumResourcePackType, Path> c = (Map)SystemUtils.a(() -> {
        Class<ResourcePackVanilla> clazz = ResourcePackVanilla.class;
        synchronized (ResourcePackVanilla.class) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (EnumResourcePackType packType : EnumResourcePackType.values()) {
                String string = "/" + packType.a() + "/.mcassetsroot";
                URL resource = ResourcePackVanilla.class.getResource(string);
                if (resource == null) {
                    b.error("File {} does not exist in classpath", (Object)string);
                    continue;
                }
                try {
                    URI uri = resource.toURI();
                    String scheme = uri.getScheme();
                    if (!"jar".equals(scheme) && !"file".equals(scheme)) {
                        b.warn("Assets URL '{}' uses unexpected schema", (Object)uri);
                    }
                    Path path = FileSystemUtil.a(uri);
                    builder.put((Object)packType, (Object)path.getParent());
                }
                catch (Exception var12) {
                    b.error("Couldn't resolve path to vanilla assets", (Throwable)var12);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return builder.build();
        }
    });
    private final Set<Path> d = new LinkedHashSet<Path>();
    private final Map<EnumResourcePackType, Set<Path>> e = new EnumMap<EnumResourcePackType, Set<Path>>(EnumResourcePackType.class);
    private BuiltInMetadata f = BuiltInMetadata.a();
    private final Set<String> g = new HashSet<String>();

    private boolean b(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Path " + String.valueOf(path.toAbsolutePath()) + " is not directory");
        }
        return true;
    }

    private void c(Path rootPath) {
        if (this.b(rootPath)) {
            this.d.add(rootPath);
        }
    }

    private void b(EnumResourcePackType packType, Path path) {
        if (this.b(path)) {
            this.e.computeIfAbsent(packType, type -> new LinkedHashSet()).add(path);
        }
    }

    public VanillaPackResourcesBuilder a() {
        c.forEach((packType, path) -> {
            this.c(path.getParent());
            this.b((EnumResourcePackType)((Object)packType), (Path)path);
        });
        return this;
    }

    public VanillaPackResourcesBuilder a(EnumResourcePackType packType, Class<?> clazz) {
        Enumeration<URL> enumeration = null;
        try {
            enumeration = clazz.getClassLoader().getResources(packType.a() + "/");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (enumeration != null && enumeration.hasMoreElements()) {
            URL url = enumeration.nextElement();
            try {
                URI uri = url.toURI();
                if (!"file".equals(uri.getScheme())) continue;
                Path path = Paths.get(uri);
                this.c(path.getParent());
                this.b(packType, path);
            }
            catch (Exception var7) {
                b.error("Failed to extract path from {}", (Object)url, (Object)var7);
            }
        }
        return this;
    }

    public VanillaPackResourcesBuilder b() {
        a.accept(this);
        return this;
    }

    public VanillaPackResourcesBuilder a(Path path) {
        this.c(path);
        for (EnumResourcePackType packType : EnumResourcePackType.values()) {
            this.b(packType, path.resolve(packType.a()));
        }
        return this;
    }

    public VanillaPackResourcesBuilder a(EnumResourcePackType packType, Path path) {
        this.c(path);
        this.b(packType, path);
        return this;
    }

    public VanillaPackResourcesBuilder a(BuiltInMetadata metadata) {
        this.f = metadata;
        return this;
    }

    public VanillaPackResourcesBuilder a(String ... namespaces) {
        this.g.addAll(Arrays.asList(namespaces));
        return this;
    }

    public ResourcePackVanilla a(PackLocationInfo location) {
        return new ResourcePackVanilla(location, this.f, Set.copyOf(this.g), VanillaPackResourcesBuilder.a(this.d), SystemUtils.a(EnumResourcePackType.class, packType -> VanillaPackResourcesBuilder.a(this.e.getOrDefault(packType, Set.of()))));
    }

    private static List<Path> a(Collection<Path> paths) {
        ArrayList<Path> list = new ArrayList<Path>(paths);
        Collections.reverse(list);
        return List.copyOf(list);
    }
}

