/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.metadata.pack;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.InclusiveRange;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public final class PackFormat
extends Record
implements Comparable<PackFormat> {
    private final int c;
    private final int d;
    private static final Logger e = LogUtils.getLogger();
    public static final Codec<PackFormat> a = PackFormat.b(0);
    public static final Codec<PackFormat> b = PackFormat.b(Integer.MAX_VALUE);

    public PackFormat(int major, int minor) {
        this.c = major;
        this.d = minor;
    }

    private static Codec<PackFormat> b(int defaultMinorVersion) {
        return ExtraCodecs.c(ExtraCodecs.q, ExtraCodecs.q.listOf(1, 256)).xmap(list -> list.size() > 1 ? PackFormat.a((int)((Integer)list.getFirst()), (Integer)list.get(1)) : PackFormat.a((int)((Integer)list.getFirst()), defaultMinorVersion), packFormat -> packFormat.d != defaultMinorVersion ? List.of(Integer.valueOf(packFormat.b()), Integer.valueOf(packFormat.c())) : List.of(Integer.valueOf(packFormat.b())));
    }

    public static <ResultType, HolderType extends b> DataResult<List<ResultType>> a(List<HolderType> holderList, int versionThreshold, BiFunction<HolderType, InclusiveRange<PackFormat>, ResultType> mapper) {
        int i2 = holderList.stream().map(b::a).mapToInt(a::a).min().orElse(Integer.MAX_VALUE);
        ArrayList<ResultType> list = new ArrayList<ResultType>(holderList.size());
        for (b intermediaryFormatHolder : holderList) {
            a intermediaryFormat = intermediaryFormatHolder.a();
            if (intermediaryFormat.b().isEmpty() && intermediaryFormat.c().isEmpty() && intermediaryFormat.e().isEmpty()) {
                e.warn("Unknown or broken overlay entry {}", (Object)intermediaryFormatHolder);
                continue;
            }
            DataResult<InclusiveRange<PackFormat>> dataResult = intermediaryFormat.a(versionThreshold, false, i2 <= versionThreshold, "Overlay \"" + String.valueOf(intermediaryFormatHolder) + "\"", "formats");
            if (!dataResult.isSuccess()) {
                return DataResult.error(() -> ((DataResult.Error)((DataResult.Error)dataResult.error().get())).message());
            }
            list.add(mapper.apply(intermediaryFormatHolder, (InclusiveRange)dataResult.getOrThrow()));
        }
        return DataResult.success(List.copyOf(list));
    }

    @VisibleForTesting
    public static int a(EnumResourcePackType packType) {
        return switch (packType) {
            default -> throw new MatchException(null, null);
            case EnumResourcePackType.a -> 64;
            case EnumResourcePackType.b -> 81;
        };
    }

    public static MapCodec<InclusiveRange<PackFormat>> b(EnumResourcePackType packType) {
        int i2 = PackFormat.a(packType);
        return net.minecraft.server.packs.metadata.pack.PackFormat$a.f.flatXmap(intermediaryFormat -> intermediaryFormat.a(i2, true, false, "Pack", "supported_formats"), inclusiveRange -> DataResult.success((Object)net.minecraft.server.packs.metadata.pack.PackFormat$a.a(inclusiveRange, i2)));
    }

    public static PackFormat a(int major, int minor) {
        return new PackFormat(major, minor);
    }

    public static PackFormat a(int major) {
        return new PackFormat(major, 0);
    }

    public InclusiveRange<PackFormat> a() {
        return new InclusiveRange<PackFormat>(this, PackFormat.a(this.c, Integer.MAX_VALUE));
    }

    public int a(PackFormat packFormat) {
        int i2 = Integer.compare(this.b(), packFormat.b());
        return i2 != 0 ? i2 : Integer.compare(this.c(), packFormat.c());
    }

    @Override
    public String toString() {
        return this.d == Integer.MAX_VALUE ? String.format(Locale.ROOT, "%d.*", this.b()) : String.format(Locale.ROOT, "%d.%d", this.b(), this.c());
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PackFormat.class, "major;minor", "c", "d"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PackFormat.class, "major;minor", "c", "d"}, this, o2);
    }

    public int b() {
        return this.c;
    }

    public int c() {
        return this.d;
    }

    public static interface b {
        public a a();
    }

    public record a(Optional<PackFormat> b, Optional<PackFormat> c, Optional<Integer> d, Optional<InclusiveRange<Integer>> e) {
        static final MapCodec<a> f = RecordCodecBuilder.mapCodec(instance -> instance.group((App)a.optionalFieldOf("min_format").forGetter(a::b), (App)b.optionalFieldOf("max_format").forGetter(a::c), (App)Codec.INT.optionalFieldOf("pack_format").forGetter(a::d), (App)InclusiveRange.a(Codec.INT).optionalFieldOf("supported_formats").forGetter(a::e)).apply((Applicative)instance, a::new));
        public static final MapCodec<a> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)a.optionalFieldOf("min_format").forGetter(a::b), (App)b.optionalFieldOf("max_format").forGetter(a::c), (App)InclusiveRange.a(Codec.INT).optionalFieldOf("formats").forGetter(a::e)).apply((Applicative)instance, (optional, optional1, optional2) -> new a((Optional<PackFormat>)optional, (Optional<PackFormat>)optional1, optional.map(PackFormat::b), (Optional<InclusiveRange<Integer>>)optional2)));

        public static a a(InclusiveRange<PackFormat> range, int versionThreshold) {
            InclusiveRange<Integer> inclusiveRange = range.a(PackFormat::b);
            return new a(Optional.of(range.a()), Optional.of(range.b()), inclusiveRange.a(versionThreshold) ? Optional.of(inclusiveRange.a()) : Optional.empty(), inclusiveRange.a(versionThreshold) ? Optional.of(new InclusiveRange<Integer>(inclusiveRange.a(), inclusiveRange.b())) : Optional.empty());
        }

        public int a() {
            if (this.b.isPresent()) {
                return this.e.isPresent() ? Math.min(this.b.get().b(), this.e.get().a()) : this.b.get().b();
            }
            return this.e.isPresent() ? this.e.get().a() : Integer.MAX_VALUE;
        }

        public DataResult<InclusiveRange<PackFormat>> a(int versionThreshold, boolean requireOldFormat, boolean requireNewFormat, String contextLabel, String oldFormatsKey) {
            if (this.b.isPresent() != this.c.isPresent()) {
                return DataResult.error(() -> contextLabel + " missing field, must declare both min_format and max_format");
            }
            if (requireNewFormat && this.e.isEmpty()) {
                return DataResult.error(() -> contextLabel + " missing required field " + oldFormatsKey + ", must be present in all overlays for any overlays to work across game versions");
            }
            if (this.b.isPresent()) {
                return this.b(versionThreshold, requireOldFormat, requireNewFormat, contextLabel, oldFormatsKey);
            }
            if (this.e.isPresent()) {
                return this.a(versionThreshold, requireOldFormat, contextLabel, oldFormatsKey);
            }
            if (requireOldFormat && this.d.isPresent()) {
                int i2 = this.d.get();
                return i2 > versionThreshold ? DataResult.error(() -> contextLabel + " declares support for version newer than " + versionThreshold + ", but is missing mandatory fields min_format and max_format") : DataResult.success(new InclusiveRange<PackFormat>(PackFormat.a(i2)));
            }
            return DataResult.error(() -> contextLabel + " could not be parsed, missing format version information");
        }

        private DataResult<InclusiveRange<PackFormat>> b(int versionThreshold, boolean requireOldFormat, boolean requireNewFormat, String contextLabel, String oldFormatsKey) {
            int major = this.b.get().b();
            int major1 = this.c.get().b();
            if (this.b.get().a(this.c.get()) > 0) {
                return DataResult.error(() -> contextLabel + " min_format (" + String.valueOf(this.b.get()) + ") is greater than max_format (" + String.valueOf(this.c.get()) + ")");
            }
            if (major > versionThreshold && !requireNewFormat) {
                String string;
                if (this.e.isPresent()) {
                    return DataResult.error(() -> contextLabel + " key " + oldFormatsKey + " is deprecated starting from pack format " + (versionThreshold + 1) + ". Remove " + oldFormatsKey + " from your pack.mcmeta.");
                }
                if (requireOldFormat && this.d.isPresent() && (string = this.a(major, major1)) != null) {
                    return DataResult.error(() -> string);
                }
            } else {
                if (!this.e.isPresent()) {
                    return DataResult.error(() -> contextLabel + " declares support for format " + major + ", but game versions supporting formats 17 to " + versionThreshold + " require a " + oldFormatsKey + " field. Add \"" + oldFormatsKey + "\": [" + major + ", " + versionThreshold + "] or require a version greater or equal to " + (versionThreshold + 1) + ".0.");
                }
                InclusiveRange<Integer> inclusiveRange = this.e.get();
                if (inclusiveRange.a() != major) {
                    return DataResult.error(() -> contextLabel + " version declaration mismatch between " + oldFormatsKey + " (from " + String.valueOf(inclusiveRange.a()) + ") and min_format (" + String.valueOf(this.b.get()) + ")");
                }
                if (inclusiveRange.b() != major1 && inclusiveRange.b() != versionThreshold) {
                    return DataResult.error(() -> contextLabel + " version declaration mismatch between " + oldFormatsKey + " (up to " + String.valueOf(inclusiveRange.b()) + ") and max_format (" + String.valueOf(this.c.get()) + ")");
                }
                if (requireOldFormat) {
                    if (!this.d.isPresent()) {
                        return DataResult.error(() -> contextLabel + " declares support for formats up to " + versionThreshold + ", but game versions supporting formats 17 to " + versionThreshold + " require a pack_format field. Add \"pack_format\": " + major + " or require a version greater or equal to " + (versionThreshold + 1) + ".0.");
                    }
                    String string = this.a(major, major1);
                    if (string != null) {
                        return DataResult.error(() -> string);
                    }
                }
            }
            return DataResult.success(new InclusiveRange<PackFormat>(this.b.get(), this.c.get()));
        }

        private DataResult<InclusiveRange<PackFormat>> a(int versionThreshold, boolean requireOldFormat, String contextLabel, String oldFormatsKey) {
            InclusiveRange<Integer> inclusiveRange = this.e.get();
            int i2 = inclusiveRange.a();
            int i1 = inclusiveRange.b();
            if (i1 > versionThreshold) {
                return DataResult.error(() -> contextLabel + " declares support for version newer than " + versionThreshold + ", but is missing mandatory fields min_format and max_format");
            }
            if (requireOldFormat) {
                if (!this.d.isPresent()) {
                    return DataResult.error(() -> contextLabel + " declares support for formats up to " + versionThreshold + ", but game versions supporting formats 17 to " + versionThreshold + " require a pack_format field. Add \"pack_format\": " + i2 + " or require a version greater or equal to " + (versionThreshold + 1) + ".0.");
                }
                String string = this.a(i2, i1);
                if (string != null) {
                    return DataResult.error(() -> string);
                }
            }
            return DataResult.success(new InclusiveRange<Integer>(i2, i1).a(PackFormat::a));
        }

        private @Nullable String a(int min, int max) {
            int i2 = this.d.get();
            if (i2 < min || i2 > max) {
                return "Pack declared support for versions " + min + " to " + max + " but declared main format is " + i2;
            }
            return i2 < 15 ? "Multi-version packs cannot support minimum version of less than 15, since this will leave versions in range unable to load pack." : null;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "min;max;format;supported", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "min;max;format;supported", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "min;max;format;supported", "b", "c", "d", "e"}, this, o2);
        }
    }
}

