/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.papermc.paper.datapack.PaperDatapackRegistrar;
import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventRunner;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.validation.DirectoryValidator;
import org.jspecify.annotations.Nullable;

public class ResourcePackRepository {
    private final Set<ResourcePackSource> a;
    private Map<String, ResourcePackLoader> b = ImmutableMap.of();
    private List<ResourcePackLoader> c = ImmutableList.of();
    private final DirectoryValidator validator;

    public ResourcePackRepository(DirectoryValidator validator, ResourcePackSource ... providers) {
        this.validator = validator;
        this.a = ImmutableSet.copyOf((Object[])providers);
    }

    public static String a(Collection<ResourcePackLoader> packs) {
        return packs.stream().map(pack -> pack.g() + (pack.d().a() ? "" : " (incompatible)")).collect(Collectors.joining(", "));
    }

    public void a() {
        this.reload(false);
    }

    public void reload(boolean pendingReload) {
        List list = (List)this.c.stream().map(ResourcePackLoader::g).collect(ImmutableList.toImmutableList());
        this.b = this.i();
        this.c = this.rebuildSelected(list, pendingReload);
    }

    private Map<String, ResourcePackLoader> i() {
        TreeMap map = Maps.newTreeMap();
        for (ResourcePackSource repositorySource : this.a) {
            repositorySource.loadPacks(pack -> map.put(pack.g(), pack));
        }
        PaperDatapackRegistrar registrar = new PaperDatapackRegistrar(this.validator, map);
        LifecycleEventRunner.INSTANCE.callStaticRegistrarEvent(LifecycleEvents.DATAPACK_DISCOVERY, registrar, BootstrapContext.class);
        return ImmutableMap.copyOf(registrar.discoveredPacks);
    }

    public boolean b() {
        List<ResourcePackLoader> list = this.rebuildSelected(List.of(), false);
        return !this.c.equals(list);
    }

    public void setSelected(Collection<String> ids, boolean pendingReload) {
        this.c = this.rebuildSelected(ids, pendingReload);
    }

    public boolean a(String id) {
        ResourcePackLoader pack = this.b.get(id);
        if (pack != null && !this.c.contains(pack)) {
            ArrayList list = Lists.newArrayList(this.c);
            list.add(pack);
            this.c = list;
            return true;
        }
        return false;
    }

    public boolean b(String id) {
        ResourcePackLoader pack = this.b.get(id);
        if (pack != null && this.c.contains(pack)) {
            ArrayList list = Lists.newArrayList(this.c);
            list.remove(pack);
            this.c = list;
            return true;
        }
        return false;
    }

    private List<ResourcePackLoader> rebuildSelected(Collection<String> ids, boolean pendingReload) {
        List list = this.d(ids).collect(SystemUtils.b());
        for (ResourcePackLoader pack : this.b.values()) {
            if (!pack.i() || list.contains(pack) || !pendingReload) continue;
            pack.k().a(list, pack, ResourcePackLoader::h, false);
        }
        return ImmutableList.copyOf(list);
    }

    private Stream<ResourcePackLoader> d(Collection<String> ids) {
        return ids.stream().map(this.b::get).filter(Objects::nonNull);
    }

    public Collection<String> c() {
        return this.b.keySet();
    }

    public Collection<ResourcePackLoader> d() {
        return this.b.values();
    }

    public Collection<String> e() {
        return (Collection)this.c.stream().map(ResourcePackLoader::g).collect(ImmutableSet.toImmutableSet());
    }

    public FeatureFlagSet f() {
        return this.g().stream().map(ResourcePackLoader::e).reduce(FeatureFlagSet::c).orElse(FeatureFlagSet.a());
    }

    public Collection<ResourcePackLoader> g() {
        return this.c;
    }

    public @Nullable ResourcePackLoader c(String id) {
        return this.b.get(id);
    }

    public boolean d(String id) {
        return this.b.containsKey(id);
    }

    public List<IResourcePack> h() {
        return (List)this.c.stream().map(ResourcePackLoader::f).collect(ImmutableList.toImmutableList());
    }
}

