/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IReloadable;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;
import org.slf4j.Logger;

public class ReloadableResourceManager
implements IResourceManager,
AutoCloseable {
    private static final Logger a = LogUtils.getLogger();
    private IReloadableResourceManager c;
    private final List<IReloadListener> d = Lists.newArrayList();
    private final EnumResourcePackType e;

    public ReloadableResourceManager(EnumResourcePackType type) {
        this.e = type;
        this.c = new ResourceManager(type, List.of());
    }

    @Override
    public void close() {
        this.c.close();
    }

    public void a(IReloadListener listener) {
        this.d.add(listener);
    }

    public IReloadable a(Executor backgroundExecutor, Executor gameExecutor, CompletableFuture<Unit> waitingFor, List<IResourcePack> resourcePacks) {
        a.info("Reloading ResourceManager: {}", LogUtils.defer(() -> resourcePacks.stream().map(IResourcePack::b).collect(Collectors.joining(", "))));
        this.c.close();
        this.c = new ResourceManager(this.e, resourcePacks);
        return Reloadable.a(this.c, this.d, backgroundExecutor, gameExecutor, waitingFor, a.isDebugEnabled());
    }

    @Override
    public Optional<IResource> getResource(MinecraftKey location) {
        return this.c.getResource(location);
    }

    @Override
    public Set<String> a() {
        return this.c.a();
    }

    @Override
    public List<IResource> a(MinecraftKey location) {
        return this.c.a(location);
    }

    @Override
    public Map<MinecraftKey, IResource> b(String path, Predicate<MinecraftKey> filter) {
        return this.c.b(path, filter);
    }

    @Override
    public Map<MinecraftKey, List<IResource>> c(String path, Predicate<MinecraftKey> filter) {
        return this.c.c(path, filter);
    }

    @Override
    public Stream<IResourcePack> b() {
        return this.c.b();
    }
}

