/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceFilterSection;
import net.minecraft.server.packs.resources.ResourceManagerFallback;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ResourceManager
implements IReloadableResourceManager {
    private static final Logger a = LogUtils.getLogger();
    private final Map<String, ResourceManagerFallback> c;
    private final List<IResourcePack> d;

    public ResourceManager(EnumResourcePackType type, List<IResourcePack> packs) {
        this.d = List.copyOf(packs);
        HashMap<String, ResourceManagerFallback> map = new HashMap<String, ResourceManagerFallback>();
        List list = packs.stream().flatMap(resources -> resources.a(type).stream()).distinct().toList();
        for (IResourcePack packResources : packs) {
            ResourceFilterSection packFilterSection = this.a(packResources);
            Set<String> namespaces = packResources.a(type);
            Predicate<MinecraftKey> predicate = packFilterSection != null ? location -> packFilterSection.b(location.a()) : null;
            for (String string : list) {
                boolean flag1;
                boolean flag = namespaces.contains(string);
                boolean bl = flag1 = packFilterSection != null && packFilterSection.a(string);
                if (!flag && !flag1) continue;
                ResourceManagerFallback fallbackResourceManager = (ResourceManagerFallback)map.get(string);
                if (fallbackResourceManager == null) {
                    fallbackResourceManager = new ResourceManagerFallback(type, string);
                    map.put(string, fallbackResourceManager);
                }
                if (flag && flag1) {
                    fallbackResourceManager.a(packResources, predicate);
                    continue;
                }
                if (flag) {
                    fallbackResourceManager.a(packResources);
                    continue;
                }
                fallbackResourceManager.a(packResources.b(), predicate);
            }
        }
        this.c = map;
    }

    private @Nullable ResourceFilterSection a(IResourcePack packResources) {
        try {
            return packResources.a(ResourceFilterSection.a);
        }
        catch (IOException var3) {
            a.error("Failed to get filter section from pack {}", (Object)packResources.b());
            return null;
        }
    }

    @Override
    public Set<String> a() {
        return this.c.keySet();
    }

    @Override
    public Optional<IResource> getResource(MinecraftKey location) {
        IResourceManager resourceManager = this.c.get(location.b());
        return resourceManager != null ? resourceManager.getResource(location) : Optional.empty();
    }

    @Override
    public List<IResource> a(MinecraftKey location) {
        IResourceManager resourceManager = this.c.get(location.b());
        return resourceManager != null ? resourceManager.a(location) : List.of();
    }

    @Override
    public Map<MinecraftKey, IResource> b(String path, Predicate<MinecraftKey> filter) {
        ResourceManager.a(path);
        TreeMap<MinecraftKey, IResource> map = new TreeMap<MinecraftKey, IResource>();
        for (ResourceManagerFallback fallbackResourceManager : this.c.values()) {
            map.putAll(fallbackResourceManager.b(path, filter));
        }
        return map;
    }

    @Override
    public Map<MinecraftKey, List<IResource>> c(String path, Predicate<MinecraftKey> filter) {
        ResourceManager.a(path);
        TreeMap<MinecraftKey, List<IResource>> map = new TreeMap<MinecraftKey, List<IResource>>();
        for (ResourceManagerFallback fallbackResourceManager : this.c.values()) {
            map.putAll(fallbackResourceManager.c(path, filter));
        }
        return map;
    }

    private static void a(String path) {
        if (path.endsWith("/")) {
            throw new IllegalArgumentException("Trailing slash in path " + path);
        }
    }

    @Override
    public Stream<IResourcePack> b() {
        return this.d.stream();
    }

    @Override
    public void close() {
        this.d.forEach(IResourcePack::close);
    }
}

