/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ResourceManagerFallback
implements IResourceManager {
    static final Logger c = LogUtils.getLogger();
    protected final List<d> a = Lists.newArrayList();
    private final EnumResourcePackType d;
    private final String e;

    public ResourceManagerFallback(EnumResourcePackType type, String namespace) {
        this.d = type;
        this.e = namespace;
    }

    public void a(IResourcePack resources) {
        this.a(resources.b(), resources, null);
    }

    public void a(IResourcePack resources, Predicate<MinecraftKey> filter) {
        this.a(resources.b(), resources, filter);
    }

    public void a(String name, Predicate<MinecraftKey> filter) {
        this.a(name, null, filter);
    }

    private void a(String name, @Nullable IResourcePack resources, @Nullable Predicate<MinecraftKey> filter) {
        this.a.add(new d(name, resources, filter));
    }

    @Override
    public Set<String> a() {
        return ImmutableSet.of((Object)this.e);
    }

    @Override
    public Optional<IResource> getResource(MinecraftKey location) {
        for (int i2 = this.a.size() - 1; i2 >= 0; --i2) {
            IoSupplier<InputStream> resource;
            d packEntry = this.a.get(i2);
            IResourcePack packResources = packEntry.b;
            if (packResources != null && (resource = packResources.a(this.d, location)) != null) {
                IoSupplier<ResourceMetadata> ioSupplier = this.a(location, i2);
                return Optional.of(ResourceManagerFallback.a(packResources, location, resource, ioSupplier));
            }
            if (!packEntry.a(location)) continue;
            c.warn("Resource {} not found, but was filtered by pack {}", (Object)location, (Object)packEntry.a);
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static IResource a(IResourcePack source, MinecraftKey location, IoSupplier<InputStream> streamSupplier, IoSupplier<ResourceMetadata> metadataSupplier) {
        return new IResource(source, ResourceManagerFallback.a(location, source, streamSupplier), metadataSupplier);
    }

    private static IoSupplier<InputStream> a(MinecraftKey location, IResourcePack packResources, IoSupplier<InputStream> stream) {
        return c.isDebugEnabled() ? () -> new c((InputStream)stream.get(), location, packResources.b()) : stream;
    }

    @Override
    public List<IResource> a(MinecraftKey location) {
        MinecraftKey metadataLocation = ResourceManagerFallback.d(location);
        ArrayList<IResource> list = new ArrayList<IResource>();
        boolean flag = false;
        String string = null;
        for (int i2 = this.a.size() - 1; i2 >= 0; --i2) {
            IoSupplier<InputStream> resource;
            d packEntry = this.a.get(i2);
            IResourcePack packResources = packEntry.b;
            if (packResources != null && (resource = packResources.a(this.d, location)) != null) {
                IoSupplier<ResourceMetadata> ioSupplier = flag ? ResourceMetadata.b : () -> {
                    IoSupplier<InputStream> resource1 = packResources.a(this.d, metadataLocation);
                    return resource1 != null ? ResourceManagerFallback.b(resource1) : ResourceMetadata.a;
                };
                list.add(new IResource(packResources, resource, ioSupplier));
            }
            if (packEntry.a(location)) {
                string = packEntry.a;
                break;
            }
            if (!packEntry.a(metadataLocation)) continue;
            flag = true;
        }
        if (list.isEmpty() && string != null) {
            c.warn("Resource {} not found, but was filtered by pack {}", (Object)location, string);
        }
        return Lists.reverse(list);
    }

    private static boolean b(MinecraftKey location) {
        return location.a().endsWith(".mcmeta");
    }

    private static MinecraftKey c(MinecraftKey metadataIdentifier) {
        String sub = metadataIdentifier.a().substring(0, metadataIdentifier.a().length() - ".mcmeta".length());
        return metadataIdentifier.e(sub);
    }

    static MinecraftKey d(MinecraftKey location) {
        return location.e(location.a() + ".mcmeta");
    }

    @Override
    public Map<MinecraftKey, IResource> b(String path, Predicate<MinecraftKey> filter) {
        record A(IResourcePack a, IoSupplier<InputStream> b, int c) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{A.class, "packResources;resource;packIndex", "a", "b", "c"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{A.class, "packResources;resource;packIndex", "a", "b", "c"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{A.class, "packResources;resource;packIndex", "a", "b", "c"}, this, o2);
            }
        }
        HashMap<MinecraftKey, A> map = new HashMap<MinecraftKey, A>();
        HashMap map1 = new HashMap();
        int size = this.a.size();
        for (int i2 = 0; i2 < size; ++i2) {
            d packEntry = this.a.get(i2);
            packEntry.a(map.keySet());
            packEntry.a(map1.keySet());
            IResourcePack packResources = packEntry.b;
            if (packResources == null) continue;
            int i1 = i2;
            packResources.a(this.d, this.e, path, (location, inputStream) -> {
                if (ResourceManagerFallback.b(location)) {
                    if (filter.test(ResourceManagerFallback.c(location))) {
                        map1.put(location, new A(packResources, (IoSupplier<InputStream>)inputStream, i1));
                    }
                } else if (filter.test((MinecraftKey)location)) {
                    map.put((MinecraftKey)location, new A(packResources, (IoSupplier<InputStream>)inputStream, i1));
                }
            });
        }
        TreeMap map2 = Maps.newTreeMap();
        map.forEach((location, resource) -> {
            MinecraftKey metadataLocation = ResourceManagerFallback.d(location);
            A resourceWithSourceAndIndex = (A)map1.get(metadataLocation);
            IoSupplier<ResourceMetadata> ioSupplier = resourceWithSourceAndIndex != null && resourceWithSourceAndIndex.c >= resource.c ? ResourceManagerFallback.a(resourceWithSourceAndIndex.b) : ResourceMetadata.b;
            map2.put(location, ResourceManagerFallback.a(resource.a, location, resource.b, ioSupplier));
        });
        return map2;
    }

    private IoSupplier<ResourceMetadata> a(MinecraftKey location, int fallbackIndex) {
        return () -> {
            MinecraftKey metadataLocation = ResourceManagerFallback.d(location);
            for (int i2 = this.a.size() - 1; i2 >= fallbackIndex; --i2) {
                IoSupplier<InputStream> resource;
                d packEntry = this.a.get(i2);
                IResourcePack packResources = packEntry.b;
                if (packResources != null && (resource = packResources.a(this.d, metadataLocation)) != null) {
                    return ResourceManagerFallback.b(resource);
                }
                if (packEntry.a(metadataLocation)) break;
            }
            return ResourceMetadata.a;
        };
    }

    private static IoSupplier<ResourceMetadata> a(IoSupplier<InputStream> streamSupplier) {
        return () -> ResourceManagerFallback.b(streamSupplier);
    }

    private static ResourceMetadata b(IoSupplier<InputStream> streamSupplier) throws IOException {
        ResourceMetadata var2;
        try (InputStream inputStream = streamSupplier.get();){
            var2 = ResourceMetadata.a(inputStream);
        }
        return var2;
    }

    private static void a(d packEntry, Map<MinecraftKey, b> resources) {
        for (b entryStack : resources.values()) {
            if (packEntry.a(entryStack.a)) {
                entryStack.c.clear();
                continue;
            }
            if (!packEntry.a(entryStack.b())) continue;
            entryStack.d.clear();
        }
    }

    private void a(d entry, String path, Predicate<MinecraftKey> filter, Map<MinecraftKey, b> output) {
        IResourcePack packResources = entry.b;
        if (packResources != null) {
            packResources.a(this.d, this.e, path, (id, inputStream) -> {
                if (ResourceManagerFallback.b(id)) {
                    MinecraftKey identifierFromMetadata = ResourceManagerFallback.c(id);
                    if (!filter.test(identifierFromMetadata)) {
                        return;
                    }
                    output.computeIfAbsent(identifierFromMetadata, (Function<MinecraftKey, b>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.MinecraftKey ), (Lnet/minecraft/resources/MinecraftKey;)Lnet/minecraft/server/packs/resources/ResourceManagerFallback$b;)()).d.put(packResources, (IoSupplier<InputStream>)inputStream);
                } else {
                    if (!filter.test((MinecraftKey)id)) {
                        return;
                    }
                    output.computeIfAbsent(id, (Function<MinecraftKey, b>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.MinecraftKey ), (Lnet/minecraft/resources/MinecraftKey;)Lnet/minecraft/server/packs/resources/ResourceManagerFallback$b;)()).c.add(new e(packResources, (IoSupplier<InputStream>)inputStream));
                }
            });
        }
    }

    @Override
    public Map<MinecraftKey, List<IResource>> c(String path, Predicate<MinecraftKey> filter) {
        HashMap map = Maps.newHashMap();
        for (d packEntry : this.a) {
            ResourceManagerFallback.a(packEntry, map);
            this.a(packEntry, path, filter, map);
        }
        TreeMap map1 = Maps.newTreeMap();
        for (b entryStack : map.values()) {
            if (entryStack.c.isEmpty()) continue;
            ArrayList<IResource> list = new ArrayList<IResource>();
            for (e resourceWithSource : entryStack.c) {
                IResourcePack packResources = resourceWithSource.a;
                IoSupplier<InputStream> ioSupplier = entryStack.d.get(packResources);
                IoSupplier<ResourceMetadata> ioSupplier1 = ioSupplier != null ? ResourceManagerFallback.a(ioSupplier) : ResourceMetadata.b;
                list.add(ResourceManagerFallback.a(packResources, entryStack.a, resourceWithSource.b, ioSupplier1));
            }
            map1.put(entryStack.a, list);
        }
        return map1;
    }

    @Override
    public Stream<IResourcePack> b() {
        return this.a.stream().map(fallback -> fallback.b).filter(Objects::nonNull);
    }

    record d(String a, @Nullable IResourcePack b, @Nullable Predicate<MinecraftKey> c) {
        public void a(Collection<MinecraftKey> locations) {
            if (this.c != null) {
                locations.removeIf(this.c);
            }
        }

        public boolean a(MinecraftKey location) {
            return this.c != null && this.c.test(location);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "name;resources;filter", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "name;resources;filter", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "name;resources;filter", "a", "b", "c"}, this, o2);
        }
    }

    record b(MinecraftKey a, MinecraftKey b, List<e> c, Map<IResourcePack, IoSupplier<InputStream>> d) {
        b(MinecraftKey fileLocation) {
            this(fileLocation, ResourceManagerFallback.d(fileLocation), new ArrayList<e>(), (Map<IResourcePack, IoSupplier<InputStream>>)new Object2ObjectArrayMap());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "fileLocation;metadataLocation;fileSources;metaSources", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "fileLocation;metadataLocation;fileSources;metaSources", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "fileLocation;metadataLocation;fileSources;metaSources", "a", "b", "c", "d"}, this, o2);
        }
    }

    record e(IResourcePack a, IoSupplier<InputStream> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "source;resource", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "source;resource", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "source;resource", "a", "b"}, this, o2);
        }
    }

    static class c
    extends FilterInputStream {
        private final Supplier<String> a;
        private boolean b;

        public c(InputStream inputStream, MinecraftKey resourceLocation, String packName) {
            super(inputStream);
            Exception exception = new Exception("Stacktrace");
            this.a = () -> {
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                return "Leaked resource: '" + String.valueOf(resourceLocation) + "' loaded from pack: '" + packName + "'\n" + String.valueOf(stringWriter);
            };
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.b = true;
        }

        protected void finalize() throws Throwable {
            if (!this.b) {
                c.warn("{}", (Object)this.a.get());
            }
            super.finalize();
        }
    }
}

