/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.datafixers.util.Either;
import io.papermc.paper.profile.PaperFilledProfileCache;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.players.UserNameToIdResolver;
import net.minecraft.util.UtilColor;

public interface ProfileResolver {
    public Optional<GameProfile> a(String var1);

    public Optional<GameProfile> a(UUID var1);

    default public Optional<GameProfile> a(Either<String, UUID> nameOrId) {
        return nameOrId.map(this::a, this::a);
    }

    public static class a
    implements ProfileResolver {
        private final LoadingCache<String, Optional<GameProfile>> a;
        final LoadingCache<UUID, Optional<GameProfile>> b;

        public a(final MinecraftSessionService sessionService, final UserNameToIdResolver resolver, final PaperFilledProfileCache paperCache) {
            this.b = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<UUID, Optional<GameProfile>>(this){

                public Optional<GameProfile> a(UUID id) {
                    ProfileResult profileResult = sessionService.fetchProfile(id, true);
                    return Optional.ofNullable(profileResult).map(ProfileResult::profile).map(profile -> {
                        paperCache.add((GameProfile)profile);
                        return profile;
                    });
                }
            });
            this.a = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<String, Optional<GameProfile>>(){

                public Optional<GameProfile> a(String name) {
                    return resolver.a(name).flatMap(nameAndId -> (Optional)b.getUnchecked((Object)nameAndId.a()));
                }
            });
        }

        @Override
        public Optional<GameProfile> a(String name) {
            return UtilColor.f(name) ? (Optional)this.a.getUnchecked((Object)name) : Optional.empty();
        }

        @Override
        public Optional<GameProfile> a(UUID id) {
            return (Optional)this.b.getUnchecked((Object)id);
        }
    }
}

