/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.stats.Counter;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.jspecify.annotations.Nullable;

public class Statistic<T>
extends IScoreboardCriteria {
    public static final StreamCodec<RegistryFriendlyByteBuf, Statistic<?>> a = ByteBufCodecs.a(Registries.ay).b(Statistic::a, StatisticWrapper::a);
    private final Counter p;
    private final T q;
    private final StatisticWrapper<T> r;

    protected Statistic(StatisticWrapper<T> type, T value, Counter formatter) {
        super(Statistic.a(type, value));
        this.r = type;
        this.p = formatter;
        this.q = value;
    }

    public static <T> String a(StatisticWrapper<T> type, T value) {
        return Statistic.a(BuiltInRegistries.w.b(type)) + ":" + Statistic.a(type.b().b(value));
    }

    private static String a(@Nullable MinecraftKey location) {
        return location.toString().replace(':', '.');
    }

    public StatisticWrapper<T> a() {
        return this.r;
    }

    public T b() {
        return this.q;
    }

    public String a(int value) {
        return this.p.format(value);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Statistic && Objects.equals(this.d(), ((Statistic)other).d());
    }

    public int hashCode() {
        return this.d().hashCode();
    }

    public String toString() {
        return "Stat{name=" + this.d() + ", formatter=" + String.valueOf(this.p) + "}";
    }
}

