/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.phys.Vec3D;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ARGB {
    private static final int a = 1024;
    private static final short[] b = SystemUtils.a(new short[256], shorts -> {
        for (int i2 = 0; i2 < ((short[])shorts).length; ++i2) {
            float f2 = (float)i2 / 255.0f;
            shorts[i2] = (short)Math.round(ARGB.e(f2) * 1023.0f);
        }
    });
    private static final byte[] c = SystemUtils.a(new byte[1024], bytes -> {
        for (int i2 = 0; i2 < ((byte[])bytes).length; ++i2) {
            float f2 = (float)i2 / 1023.0f;
            bytes[i2] = (byte)Math.round(ARGB.f(f2) * 255.0f);
        }
    });

    private static float e(float value) {
        return value >= 0.04045f ? (float)Math.pow(((double)value + 0.055) / 1.055, 2.4) : value / 12.92f;
    }

    private static float f(float value) {
        return value >= 0.0031308f ? (float)(1.055 * Math.pow(value, 0.4166666666666667) - 0.055) : 12.92f * value;
    }

    public static float a(int srgb) {
        return (float)b[srgb] / 1023.0f;
    }

    public static int a(float linear) {
        return c[MathHelper.b(linear * 1023.0f)] & 0xFF;
    }

    public static int a(int srgb1, int srgb2, int srgb3, int srgb4) {
        return ARGB.b((ARGB.b(srgb1) + ARGB.b(srgb2) + ARGB.b(srgb3) + ARGB.b(srgb4)) / 4, ARGB.c(ARGB.c(srgb1), ARGB.c(srgb2), ARGB.c(srgb3), ARGB.c(srgb4)), ARGB.c(ARGB.d(srgb1), ARGB.d(srgb2), ARGB.d(srgb3), ARGB.d(srgb4)), ARGB.c(ARGB.e(srgb1), ARGB.e(srgb2), ARGB.e(srgb3), ARGB.e(srgb4)));
    }

    private static int c(int c1, int c2, int c3, int c4) {
        int i2 = (b[c1] + b[c2] + b[c3] + b[c4]) / 4;
        return c[i2] & 0xFF;
    }

    public static int b(int color) {
        return color >>> 24;
    }

    public static int c(int color) {
        return color >> 16 & 0xFF;
    }

    public static int d(int color) {
        return color >> 8 & 0xFF;
    }

    public static int e(int color) {
        return color & 0xFF;
    }

    public static int b(int alpha, int red, int green, int blue) {
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public static int a(int red, int green, int blue) {
        return ARGB.b(255, red, green, blue);
    }

    public static int a(Vec3D color) {
        return ARGB.a(ARGB.d((float)color.a()), ARGB.d((float)color.b()), ARGB.d((float)color.c()));
    }

    public static int a(int color1, int color2) {
        if (color1 == -1) {
            return color2;
        }
        return color2 == -1 ? color1 : ARGB.b(ARGB.b(color1) * ARGB.b(color2) / 255, ARGB.c(color1) * ARGB.c(color2) / 255, ARGB.d(color1) * ARGB.d(color2) / 255, ARGB.e(color1) * ARGB.e(color2) / 255);
    }

    public static int b(int color1, int color2) {
        return ARGB.b(ARGB.b(color1), Math.min(ARGB.c(color1) + ARGB.c(color2), 255), Math.min(ARGB.d(color1) + ARGB.d(color2), 255), Math.min(ARGB.e(color1) + ARGB.e(color2), 255));
    }

    public static int c(int color1, int color2) {
        return ARGB.b(ARGB.b(color1), Math.max(ARGB.c(color1) - ARGB.c(color2), 0), Math.max(ARGB.d(color1) - ARGB.d(color2), 0), Math.max(ARGB.e(color1) - ARGB.e(color2), 0));
    }

    public static int a(int color, float alphaMultiplier) {
        if (color == 0 || alphaMultiplier <= 0.0f) {
            return 0;
        }
        return alphaMultiplier >= 1.0f ? color : ARGB.a(ARGB.m(color) * alphaMultiplier, color);
    }

    public static int b(int color, float scale) {
        return ARGB.a(color, scale, scale, scale);
    }

    public static int a(int color, float redScale, float greenScale, float blueScale) {
        return ARGB.b(ARGB.b(color), Math.clamp((long)((int)((float)ARGB.c(color) * redScale)), 0, 255), Math.clamp((long)((int)((float)ARGB.d(color) * greenScale)), 0, 255), Math.clamp((long)((int)((float)ARGB.e(color) * blueScale)), 0, 255));
    }

    public static int d(int color, int scale) {
        return ARGB.b(ARGB.b(color), Math.clamp((long)ARGB.c(color) * (long)scale / 255L, 0, 255), Math.clamp((long)ARGB.d(color) * (long)scale / 255L, 0, 255), Math.clamp((long)ARGB.e(color) * (long)scale / 255L, 0, 255));
    }

    public static int f(int color) {
        int i2 = (int)((float)ARGB.c(color) * 0.3f + (float)ARGB.d(color) * 0.59f + (float)ARGB.e(color) * 0.11f);
        return ARGB.b(ARGB.b(color), i2, i2, i2);
    }

    public static int e(int destination, int source) {
        int i2 = ARGB.b(destination);
        int i1 = ARGB.b(source);
        if (i1 == 255) {
            return source;
        }
        if (i1 == 0) {
            return destination;
        }
        int i22 = i1 + i2 * (255 - i1) / 255;
        return ARGB.b(i22, ARGB.d(i22, i1, ARGB.c(destination), ARGB.c(source)), ARGB.d(i22, i1, ARGB.d(destination), ARGB.d(source)), ARGB.d(i22, i1, ARGB.e(destination), ARGB.e(source)));
    }

    private static int d(int resultAlpha, int sourceAlpha, int destination, int source) {
        return (source * sourceAlpha + destination * (resultAlpha - sourceAlpha)) / resultAlpha;
    }

    public static int a(float delta, int color1, int color2) {
        int i2 = MathHelper.a(delta, ARGB.b(color1), ARGB.b(color2));
        int i1 = MathHelper.a(delta, ARGB.c(color1), ARGB.c(color2));
        int i22 = MathHelper.a(delta, ARGB.d(color1), ARGB.d(color2));
        int i3 = MathHelper.a(delta, ARGB.e(color1), ARGB.e(color2));
        return ARGB.b(i2, i1, i22, i3);
    }

    public static int b(float delta, int color1, int color2) {
        return ARGB.b(MathHelper.a(delta, ARGB.b(color1), ARGB.b(color2)), c[MathHelper.a(delta, (int)b[ARGB.c(color1)], (int)b[ARGB.c(color2)])] & 0xFF, c[MathHelper.a(delta, (int)b[ARGB.d(color1)], (int)b[ARGB.d(color2)])] & 0xFF, c[MathHelper.a(delta, (int)b[ARGB.e(color1)], (int)b[ARGB.e(color2)])] & 0xFF);
    }

    public static int g(int color) {
        return color | 0xFF000000;
    }

    public static int h(int color) {
        return color & 0xFFFFFF;
    }

    public static int f(int alpha, int color) {
        return alpha << 24 | color & 0xFFFFFF;
    }

    public static int a(float alpha, int color) {
        return ARGB.d(alpha) << 24 | color & 0xFFFFFF;
    }

    public static int b(float alpha) {
        return ARGB.d(alpha) << 24 | 0xFFFFFF;
    }

    public static int i(int alpha) {
        return alpha << 24 | 0xFFFFFF;
    }

    public static int c(float alpha) {
        return ARGB.d(alpha) << 24;
    }

    public static int j(int alpha) {
        return alpha << 24;
    }

    public static int a(float alpha, float red, float green, float blue) {
        return ARGB.b(ARGB.d(alpha), ARGB.d(red), ARGB.d(green), ARGB.d(blue));
    }

    public static Vector3f k(int color) {
        return new Vector3f(ARGB.n(color), ARGB.o(color), ARGB.p(color));
    }

    public static Vector4f l(int color) {
        return new Vector4f(ARGB.n(color), ARGB.o(color), ARGB.p(color), ARGB.m(color));
    }

    public static int g(int color1, int color2) {
        return ARGB.b((ARGB.b(color1) + ARGB.b(color2)) / 2, (ARGB.c(color1) + ARGB.c(color2)) / 2, (ARGB.d(color1) + ARGB.d(color2)) / 2, (ARGB.e(color1) + ARGB.e(color2)) / 2);
    }

    public static int d(float value) {
        return MathHelper.b(value * 255.0f);
    }

    public static float m(int color) {
        return ARGB.s(ARGB.b(color));
    }

    public static float n(int color) {
        return ARGB.s(ARGB.c(color));
    }

    public static float o(int color) {
        return ARGB.s(ARGB.d(color));
    }

    public static float p(int color) {
        return ARGB.s(ARGB.e(color));
    }

    private static float s(int value) {
        return (float)value / 255.0f;
    }

    public static int q(int color) {
        return color & 0xFF00FF00 | (color & 0xFF0000) >> 16 | (color & 0xFF) << 16;
    }

    public static int r(int color) {
        return ARGB.q(color);
    }

    public static int c(int color, float brightness) {
        float f2;
        int i2 = ARGB.c(color);
        int i1 = ARGB.d(color);
        int i22 = ARGB.e(color);
        int i3 = ARGB.b(color);
        int max = Math.max(Math.max(i2, i1), i22);
        int min = Math.min(Math.min(i2, i1), i22);
        float f3 = max - min;
        float f1 = max != 0 ? f3 / (float)max : 0.0f;
        if (f1 == 0.0f) {
            f2 = 0.0f;
        } else {
            float f32 = (float)(max - i2) / f3;
            float f4 = (float)(max - i1) / f3;
            float f5 = (float)(max - i22) / f3;
            f2 = i2 == max ? f5 - f4 : (i1 == max ? 2.0f + f32 - f5 : 4.0f + f4 - f32);
            if ((f2 /= 6.0f) < 0.0f) {
                f2 += 1.0f;
            }
        }
        if (f1 == 0.0f) {
            i1 = i22 = Math.round(brightness * 255.0f);
            i2 = i22;
            return ARGB.b(i3, i2, i1, i22);
        }
        float f3x = (f2 - (float)Math.floor(f2)) * 6.0f;
        float f4x = f3x - (float)Math.floor(f3x);
        float f5x = brightness * (1.0f - f1);
        float f6 = brightness * (1.0f - f1 * f4x);
        float f7 = brightness * (1.0f - f1 * (1.0f - f4x));
        switch ((int)f3x) {
            case 0: {
                i2 = Math.round(brightness * 255.0f);
                i1 = Math.round(f7 * 255.0f);
                i22 = Math.round(f5x * 255.0f);
                break;
            }
            case 1: {
                i2 = Math.round(f6 * 255.0f);
                i1 = Math.round(brightness * 255.0f);
                i22 = Math.round(f5x * 255.0f);
                break;
            }
            case 2: {
                i2 = Math.round(f5x * 255.0f);
                i1 = Math.round(brightness * 255.0f);
                i22 = Math.round(f7 * 255.0f);
                break;
            }
            case 3: {
                i2 = Math.round(f5x * 255.0f);
                i1 = Math.round(f6 * 255.0f);
                i22 = Math.round(brightness * 255.0f);
                break;
            }
            case 4: {
                i2 = Math.round(f7 * 255.0f);
                i1 = Math.round(f5x * 255.0f);
                i22 = Math.round(brightness * 255.0f);
                break;
            }
            case 5: {
                i2 = Math.round(brightness * 255.0f);
                i1 = Math.round(f5x * 255.0f);
                i22 = Math.round(f6 * 255.0f);
            }
        }
        return ARGB.b(i3, i2, i1, i22);
    }
}

