/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import net.minecraft.util.MathHelper;

public class ByIdMap {
    private static <T> IntFunction<T> a(ToIntFunction<T> keyExtractor, T[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Empty value list");
        }
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        for (T object : values) {
            int i2 = keyExtractor.applyAsInt(object);
            Object object1 = map.put(i2, object);
            if (object1 == null) continue;
            throw new IllegalArgumentException("Duplicate entry on id " + i2 + ": current=" + String.valueOf(object) + ", previous=" + String.valueOf(object1));
        }
        return map;
    }

    public static <T> IntFunction<T> a(ToIntFunction<T> keyExtractor, T[] values, T fallback) {
        IntFunction intFunction = ByIdMap.a(keyExtractor, values);
        return key -> Objects.requireNonNullElse(intFunction.apply(key), fallback);
    }

    private static <T> T[] b(ToIntFunction<T> keyExtractor, T[] values) {
        int i2 = values.length;
        if (i2 == 0) {
            throw new IllegalArgumentException("Empty value list");
        }
        Object[] objects = (Object[])values.clone();
        Arrays.fill(objects, null);
        for (T object : values) {
            int i1 = keyExtractor.applyAsInt(object);
            if (i1 < 0 || i1 >= i2) {
                throw new IllegalArgumentException("Values are not continous, found index " + i1 + " for value " + String.valueOf(object));
            }
            Object object1 = objects[i1];
            if (object1 != null) {
                throw new IllegalArgumentException("Duplicate entry on id " + i1 + ": current=" + String.valueOf(object) + ", previous=" + String.valueOf(object1));
            }
            objects[i1] = object;
        }
        for (int i22 = 0; i22 < i2; ++i22) {
            if (objects[i22] != null) continue;
            throw new IllegalArgumentException("Missing value at index: " + i22);
        }
        return objects;
    }

    public static <T> IntFunction<T> a(ToIntFunction<T> keyExtractor, T[] values, a outOfBoundsStrategy) {
        Object[] objects = ByIdMap.b(keyExtractor, values);
        int i2 = objects.length;
        return switch (outOfBoundsStrategy.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Object object = objects[0];
                yield key -> key >= 0 && key < i2 ? objects[key] : object;
            }
            case 1 -> key -> objects[MathHelper.c(key, i2)];
            case 2 -> key -> objects[MathHelper.a(key, 0, i2 - 1)];
        };
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a();
        public static final /* enum */ a b = new a();
        public static final /* enum */ a c = new a();
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b, c};
        }

        static {
            d = net.minecraft.util.ByIdMap$a.a();
        }
    }
}

