/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import net.minecraft.util.Ease;
import net.minecraft.util.ExtraCodecs;

public interface EasingType {
    public static final ExtraCodecs.b<String, EasingType> a = new ExtraCodecs.b();
    public static final Codec<EasingType> b = Codec.either(a.a((Codec<String>)Codec.STRING), net.minecraft.util.EasingType$a.I).xmap(Either::unwrap, easingType -> {
        Either<EasingType, Object> either;
        if (easingType instanceof a) {
            a cubicBezier = (a)easingType;
            either = Either.right(cubicBezier);
        } else {
            either = Either.left(easingType);
        }
        return either;
    });
    public static final EasingType c = EasingType.a("constant", x2 -> 0.0f);
    public static final EasingType d = EasingType.a("linear", x2 -> x2);
    public static final EasingType e = EasingType.a("in_back", Ease::a);
    public static final EasingType f = EasingType.a("in_bounce", Ease::b);
    public static final EasingType g = EasingType.a("in_circ", Ease::C);
    public static final EasingType h = EasingType.a("in_cubic", Ease::c);
    public static final EasingType i = EasingType.a("in_elastic", Ease::d);
    public static final EasingType j = EasingType.a("in_expo", Ease::e);
    public static final EasingType k = EasingType.a("in_quad", Ease::z);
    public static final EasingType l = EasingType.a("in_quart", Ease::f);
    public static final EasingType m = EasingType.a("in_quint", Ease::g);
    public static final EasingType n = EasingType.a("in_sine", Ease::h);
    public static final EasingType o = EasingType.a("in_out_back", Ease::D);
    public static final EasingType p = EasingType.a("in_out_bounce", Ease::i);
    public static final EasingType q = EasingType.a("in_out_circ", Ease::j);
    public static final EasingType r = EasingType.a("in_out_cubic", Ease::k);
    public static final EasingType s = EasingType.a("in_out_elastic", Ease::B);
    public static final EasingType t = EasingType.a("in_out_expo", Ease::y);
    public static final EasingType u = EasingType.a("in_out_quad", Ease::l);
    public static final EasingType v = EasingType.a("in_out_quart", Ease::m);
    public static final EasingType w = EasingType.a("in_out_quint", Ease::n);
    public static final EasingType x = EasingType.a("in_out_sine", Ease::u);
    public static final EasingType y = EasingType.a("out_back", Ease::v);
    public static final EasingType z = EasingType.a("out_bounce", Ease::o);
    public static final EasingType A = EasingType.a("out_circ", Ease::A);
    public static final EasingType B = EasingType.a("out_cubic", Ease::x);
    public static final EasingType C = EasingType.a("out_elastic", Ease::p);
    public static final EasingType D = EasingType.a("out_expo", Ease::q);
    public static final EasingType E = EasingType.a("out_quad", Ease::r);
    public static final EasingType F = EasingType.a("out_quart", Ease::w);
    public static final EasingType G = EasingType.a("out_quint", Ease::s);
    public static final EasingType H = EasingType.a("out_sine", Ease::t);

    public static EasingType a(String id, EasingType easing) {
        a.a(id, easing);
        return easing;
    }

    public static EasingType a(float x1, float y1, float x2, float y2) {
        return new a(new b(x1, y1, x2, y2));
    }

    public static EasingType a(float x1, float y1) {
        return EasingType.a(x1, y1, 1.0f - x1, 1.0f - y1);
    }

    public float apply(float var1);

    public static final class net.minecraft.util.EasingType$a
    implements EasingType {
        public static final Codec<net.minecraft.util.EasingType$a> I = RecordCodecBuilder.create(instance -> instance.group((App)net.minecraft.util.EasingType$b.a.fieldOf("cubic_bezier").forGetter(cubicBezier -> cubicBezier.K)).apply((Applicative)instance, net.minecraft.util.EasingType$a::new));
        private static final int J = 4;
        private final b K;
        private final a L;
        private final a M;

        public net.minecraft.util.EasingType$a(b controls) {
            this.K = controls;
            this.L = net.minecraft.util.EasingType$a.b(controls.b, controls.d);
            this.M = net.minecraft.util.EasingType$a.b(controls.c, controls.e);
        }

        private static a b(float v1, float v2) {
            return new a(3.0f * v1 - 3.0f * v2 + 1.0f, -6.0f * v1 + 3.0f * v2, 3.0f * v1);
        }

        @Override
        public float apply(float x2) {
            float f1;
            float f2 = x2;
            for (int i2 = 0; i2 < 4 && !((f1 = this.L.b(f2)) < 1.0E-5f); ++i2) {
                float f22 = this.L.a(f2) - x2;
                f2 -= f22 / f1;
            }
            return this.M.a(f2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (!(other instanceof net.minecraft.util.EasingType$a)) return false;
            net.minecraft.util.EasingType$a cubicBezier = (net.minecraft.util.EasingType$a)other;
            if (!this.K.equals(cubicBezier.K)) return false;
            return true;
        }

        public int hashCode() {
            return this.K.hashCode();
        }

        public String toString() {
            return "CubicBezier(" + this.K.b + ", " + this.K.c + ", " + this.K.d + ", " + this.K.e + ")";
        }

        record a(float a, float b, float c) {
            public float a(float t2) {
                return ((this.a * t2 + this.b) * t2 + this.c) * t2;
            }

            public float b(float t2) {
                return (3.0f * this.a * t2 + 2.0f * this.b) * t2 + this.c;
            }
        }
    }

    public static final class b
    extends Record {
        private final float b;
        private final float c;
        private final float d;
        private final float e;
        public static final Codec<b> a = Codec.FLOAT.listOf(4, 4).xmap(list -> new b(((Float)list.get(0)).floatValue(), ((Float)list.get(1)).floatValue(), ((Float)list.get(2)).floatValue(), ((Float)list.get(3)).floatValue()), cubicBezierControls -> List.of(Float.valueOf(cubicBezierControls.b), Float.valueOf(cubicBezierControls.c), Float.valueOf(cubicBezierControls.d), Float.valueOf(cubicBezierControls.e))).validate(b::e);

        public b(float x1, float y1, float x2, float y2) {
            this.b = x1;
            this.c = y1;
            this.d = x2;
            this.e = y2;
        }

        private DataResult<b> e() {
            if (this.b < 0.0f || this.b > 1.0f) {
                return DataResult.error(() -> "x1 must be in range [0; 1]");
            }
            return !(this.d < 0.0f) && !(this.d > 1.0f) ? DataResult.success((Object)this) : DataResult.error(() -> "x2 must be in range [0; 1]");
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "x1;y1;x2;y2", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "x1;y1;x2;y2", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "x1;y1;x2;y2", "b", "c", "d", "e"}, this, o2);
        }

        public float a() {
            return this.b;
        }

        public float b() {
            return this.c;
        }

        public float c() {
            return this.d;
        }

        public float d() {
            return this.e;
        }
    }
}

