/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.util.AbstractListBuilder;

public class HashOps
implements DynamicOps<HashCode> {
    private static final byte d = 1;
    private static final byte e = 2;
    private static final byte f = 3;
    private static final byte g = 4;
    private static final byte h = 5;
    private static final byte i = 6;
    private static final byte j = 7;
    private static final byte k = 8;
    private static final byte l = 9;
    private static final byte m = 10;
    private static final byte n = 11;
    private static final byte o = 12;
    private static final byte p = 13;
    private static final byte q = 14;
    private static final byte r = 15;
    private static final byte s = 16;
    private static final byte t = 17;
    private static final byte u = 18;
    private static final byte v = 19;
    private static final byte[] w = new byte[]{1};
    private static final byte[] x = new byte[]{13, 0};
    private static final byte[] y = new byte[]{13, 1};
    public static final byte[] a = new byte[]{2, 3};
    public static final byte[] b = new byte[]{4, 5};
    private static final DataResult<Object> z = DataResult.error(() -> "Unsupported operation");
    private static final Comparator<HashCode> A = Comparator.comparingLong(HashCode::padToLong);
    private static final Comparator<Map.Entry<HashCode, HashCode>> B = Map.Entry.comparingByKey(A).thenComparing(Map.Entry.comparingByValue(A));
    private static final Comparator<Pair<HashCode, HashCode>> C = Comparator.comparing(Pair::getFirst, A).thenComparing(Pair::getSecond, A);
    public static final HashOps c = new HashOps(Hashing.crc32c());
    final HashFunction D;
    final HashCode E;
    private final HashCode F;
    private final HashCode G;
    private final HashCode H;
    private final HashCode I;

    public HashOps(HashFunction hashFunction) {
        this.D = hashFunction;
        this.E = hashFunction.hashBytes(w);
        this.F = hashFunction.hashBytes(a);
        this.G = hashFunction.hashBytes(b);
        this.I = hashFunction.hashBytes(x);
        this.H = hashFunction.hashBytes(y);
    }

    public HashCode a() {
        return this.E;
    }

    public HashCode b() {
        return this.F;
    }

    public HashCode c() {
        return this.G;
    }

    public HashCode a(Number i2) {
        Number number = i2;
        Objects.requireNonNull(number);
        Number number2 = number;
        int n2 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Integer.class, Long.class, Double.class, Float.class}, (Object)number2, n2)) {
            case 0 -> {
                Byte _byte = (Byte)number2;
                yield this.a(_byte);
            }
            case 1 -> {
                Short _short = (Short)number2;
                yield this.a(_short);
            }
            case 2 -> {
                Integer integer = (Integer)number2;
                yield this.a(integer);
            }
            case 3 -> {
                Long _long = (Long)number2;
                yield this.a(_long);
            }
            case 4 -> {
                Double _double = (Double)number2;
                yield this.a(_double);
            }
            case 5 -> {
                Float _float = (Float)number2;
                yield this.a(_float.floatValue());
            }
            default -> this.a(i2.doubleValue());
        };
    }

    public HashCode a(byte value) {
        return this.D.newHasher(2).putByte((byte)6).putByte(value).hash();
    }

    public HashCode a(short value) {
        return this.D.newHasher(3).putByte((byte)7).putShort(value).hash();
    }

    public HashCode a(int value) {
        return this.D.newHasher(5).putByte((byte)8).putInt(value).hash();
    }

    public HashCode a(long value) {
        return this.D.newHasher(9).putByte((byte)9).putLong(value).hash();
    }

    public HashCode a(float value) {
        return this.D.newHasher(5).putByte((byte)10).putFloat(value).hash();
    }

    public HashCode a(double value) {
        return this.D.newHasher(9).putByte((byte)11).putDouble(value).hash();
    }

    public HashCode a(String value) {
        return this.D.newHasher().putByte((byte)12).putInt(value.length()).putUnencodedChars((CharSequence)value).hash();
    }

    public HashCode a(boolean value) {
        return value ? this.H : this.I;
    }

    private static Hasher a(Hasher hasher, Map<HashCode, HashCode> map) {
        hasher.putByte((byte)2);
        map.entrySet().stream().sorted(B).forEach(entry -> hasher.putBytes(((HashCode)entry.getKey()).asBytes()).putBytes(((HashCode)entry.getValue()).asBytes()));
        hasher.putByte((byte)3);
        return hasher;
    }

    static Hasher a(Hasher hasher, Stream<Pair<HashCode, HashCode>> map) {
        hasher.putByte((byte)2);
        map.sorted(C).forEach(pair -> hasher.putBytes(((HashCode)pair.getFirst()).asBytes()).putBytes(((HashCode)pair.getSecond()).asBytes()));
        hasher.putByte((byte)3);
        return hasher;
    }

    public HashCode a(Stream<Pair<HashCode, HashCode>> map) {
        return HashOps.a(this.D.newHasher(), map).hash();
    }

    public HashCode a(Map<HashCode, HashCode> map) {
        return HashOps.a(this.D.newHasher(), map).hash();
    }

    public HashCode b(Stream<HashCode> input) {
        Hasher hasher = this.D.newHasher();
        hasher.putByte((byte)4);
        input.forEach(hashCode -> hasher.putBytes(hashCode.asBytes()));
        hasher.putByte((byte)5);
        return hasher.hash();
    }

    public HashCode a(ByteBuffer input) {
        Hasher hasher = this.D.newHasher();
        hasher.putByte((byte)14);
        hasher.putBytes(input);
        hasher.putByte((byte)15);
        return hasher.hash();
    }

    public HashCode a(IntStream input) {
        Hasher hasher = this.D.newHasher();
        hasher.putByte((byte)16);
        input.forEach(arg_0 -> ((Hasher)hasher).putInt(arg_0));
        hasher.putByte((byte)17);
        return hasher.hash();
    }

    public HashCode a(LongStream input) {
        Hasher hasher = this.D.newHasher();
        hasher.putByte((byte)18);
        input.forEach(arg_0 -> ((Hasher)hasher).putLong(arg_0));
        hasher.putByte((byte)19);
        return hasher.hash();
    }

    public HashCode a(HashCode input, String key) {
        return input;
    }

    public RecordBuilder<HashCode> mapBuilder() {
        return new b();
    }

    public ListBuilder<HashCode> listBuilder() {
        return new a();
    }

    public String toString() {
        return "Hash " + String.valueOf(this.D);
    }

    public <U> U a(DynamicOps<U> outOps, HashCode input) {
        throw new UnsupportedOperationException("Can't convert from this type");
    }

    public Number a(HashCode input, Number defaultValue) {
        return defaultValue;
    }

    public HashCode a(HashCode input, String key, HashCode value) {
        return input;
    }

    public HashCode a(HashCode input, String key, Function<HashCode, HashCode> function) {
        return input;
    }

    public HashCode a(HashCode input, HashCode key, Function<HashCode, HashCode> function) {
        return input;
    }

    private static <T> DataResult<T> d() {
        return z;
    }

    public DataResult<HashCode> b(HashCode input, String key) {
        return HashOps.d();
    }

    public DataResult<HashCode> a(HashCode input, HashCode key) {
        return HashOps.d();
    }

    public DataResult<Number> a(HashCode input) {
        return HashOps.d();
    }

    public DataResult<Boolean> b(HashCode input) {
        return HashOps.d();
    }

    public DataResult<String> c(HashCode input) {
        return HashOps.d();
    }

    boolean l(HashCode value) {
        return value.equals((Object)this.E);
    }

    public DataResult<HashCode> b(HashCode list, HashCode value) {
        return this.l(list) ? DataResult.success((Object)this.b(Stream.of(value))) : HashOps.d();
    }

    public DataResult<HashCode> a(HashCode list, List<HashCode> values) {
        return this.l(list) ? DataResult.success((Object)this.b(values.stream())) : HashOps.d();
    }

    public DataResult<HashCode> a(HashCode map, HashCode key, HashCode value) {
        return this.l(map) ? DataResult.success((Object)this.a(Map.of(key, value))) : HashOps.d();
    }

    public DataResult<HashCode> a(HashCode map, Map<HashCode, HashCode> values) {
        return this.l(map) ? DataResult.success((Object)this.a(values)) : HashOps.d();
    }

    public DataResult<HashCode> a(HashCode map, MapLike<HashCode> values) {
        return this.l(map) ? DataResult.success((Object)this.a(values.entries())) : HashOps.d();
    }

    public DataResult<Stream<Pair<HashCode, HashCode>>> d(HashCode input) {
        return HashOps.d();
    }

    public DataResult<Consumer<BiConsumer<HashCode, HashCode>>> e(HashCode input) {
        return HashOps.d();
    }

    public DataResult<Stream<HashCode>> f(HashCode input) {
        return HashOps.d();
    }

    public DataResult<Consumer<Consumer<HashCode>>> g(HashCode input) {
        return HashOps.d();
    }

    public DataResult<MapLike<HashCode>> h(HashCode input) {
        return HashOps.d();
    }

    public DataResult<ByteBuffer> i(HashCode input) {
        return HashOps.d();
    }

    public DataResult<IntStream> j(HashCode input) {
        return HashOps.d();
    }

    public DataResult<LongStream> k(HashCode input) {
        return HashOps.d();
    }

    final class b
    extends RecordBuilder.AbstractUniversalBuilder<HashCode, List<Pair<HashCode, HashCode>>> {
        public b() {
            super((DynamicOps)HashOps.this);
        }

        protected List<Pair<HashCode, HashCode>> a() {
            return new ArrayList<Pair<HashCode, HashCode>>();
        }

        protected List<Pair<HashCode, HashCode>> a(HashCode key, HashCode value, List<Pair<HashCode, HashCode>> builder) {
            builder.add((Pair<HashCode, HashCode>)Pair.of((Object)key, (Object)value));
            return builder;
        }

        protected DataResult<HashCode> a(List<Pair<HashCode, HashCode>> builder, HashCode prefix) {
            assert (HashOps.this.l(prefix));
            return DataResult.success((Object)HashOps.a(HashOps.this.D.newHasher(), builder.stream()).hash());
        }
    }

    class a
    extends AbstractListBuilder<HashCode, Hasher> {
        public a() {
            super(HashOps.this);
        }

        protected Hasher b() {
            return HashOps.this.D.newHasher().putByte((byte)4);
        }

        @Override
        protected Hasher a(Hasher builder, HashCode value) {
            return builder.putBytes(value.asBytes());
        }

        @Override
        protected DataResult<HashCode> b(Hasher builder, HashCode prefix) {
            assert (prefix.equals((Object)HashOps.this.E));
            builder.putByte((byte)5);
            return DataResult.success((Object)builder.hash());
        }
    }
}

