/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.EasingType;
import net.minecraft.util.Keyframe;
import net.minecraft.util.KeyframeTrackSampler;
import net.minecraft.world.attribute.LerpFunction;

public record KeyframeTrack<T>(List<Keyframe<T>> a, EasingType b) {
    public KeyframeTrack {
        if (keyframes.isEmpty()) {
            throw new IllegalArgumentException("Track has no keyframes");
        }
    }

    public static <T> MapCodec<KeyframeTrack<T>> a(Codec<T> valueCodec) {
        Codec codec = Keyframe.a(valueCodec).listOf().validate(KeyframeTrack::a);
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)codec.fieldOf("keyframes").forGetter(KeyframeTrack::a), (App)EasingType.b.optionalFieldOf("ease", (Object)EasingType.d).forGetter(KeyframeTrack::b)).apply((Applicative)instance, KeyframeTrack::new));
    }

    static <T> DataResult<List<Keyframe<T>>> a(List<Keyframe<T>> keyframes) {
        if (keyframes.isEmpty()) {
            return DataResult.error(() -> "Keyframes must not be empty");
        }
        if (!Comparators.isInOrder(keyframes, Comparator.comparingInt(Keyframe::a))) {
            return DataResult.error(() -> "Keyframes must be ordered by ticks field");
        }
        if (keyframes.size() > 1) {
            int i2 = 0;
            int ticks = keyframes.getLast().a();
            for (Keyframe keyframe : keyframes) {
                if (keyframe.a() == ticks) {
                    if (++i2 > 2) {
                        return DataResult.error(() -> "More than 2 keyframes on same tick: " + keyframe.a());
                    }
                } else {
                    i2 = 0;
                }
                ticks = keyframe.a();
            }
        }
        return DataResult.success(keyframes);
    }

    public static DataResult<KeyframeTrack<?>> a(KeyframeTrack<?> track, int periodTicks) {
        for (Keyframe<?> keyframe : track.a()) {
            int ticks = keyframe.a();
            if (ticks >= 0 && ticks <= periodTicks) continue;
            return DataResult.error(() -> "Keyframe at tick " + keyframe.a() + " must be in range [0; " + periodTicks + "]");
        }
        return DataResult.success(track);
    }

    public KeyframeTrackSampler<T> a(Optional<Integer> periodTicks, LerpFunction<T> lerp) {
        return new KeyframeTrackSampler<T>(this, periodTicks, lerp);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{KeyframeTrack.class, "keyframes;easingType", "a", "b"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{KeyframeTrack.class, "keyframes;easingType", "a", "b"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{KeyframeTrack.class, "keyframes;easingType", "a", "b"}, this, o2);
    }

    public static class a<T> {
        private final ImmutableList.Builder<Keyframe<T>> a = ImmutableList.builder();
        private EasingType b = EasingType.d;

        public a<T> a(int ticks, T value) {
            this.a.add(new Keyframe<T>(ticks, value));
            return this;
        }

        public a<T> a(EasingType easing) {
            this.b = easing;
            return this;
        }

        public KeyframeTrack<T> a() {
            List list = (List)KeyframeTrack.a(this.a.build()).getOrThrow();
            return new KeyframeTrack(list, this.b);
        }
    }
}

