/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.EasingType;
import net.minecraft.util.Keyframe;
import net.minecraft.util.KeyframeTrack;
import net.minecraft.world.attribute.LerpFunction;

public class KeyframeTrackSampler<T> {
    private final Optional<Integer> a;
    private final LerpFunction<T> b;
    private final List<a<T>> c;

    KeyframeTrackSampler(KeyframeTrack<T> track, Optional<Integer> periodTicks, LerpFunction<T> lerp) {
        this.a = periodTicks;
        this.b = lerp;
        this.c = KeyframeTrackSampler.a(track, periodTicks);
    }

    private static <T> List<a<T>> a(KeyframeTrack<T> track, Optional<Integer> periodTicks) {
        List<Keyframe<T>> list = track.a();
        if (list.size() == 1) {
            T object = list.getFirst().b();
            return List.of(new a<T>(EasingType.c, object, 0, object, 0));
        }
        ArrayList<a<T>> list1 = new ArrayList<a<T>>();
        if (periodTicks.isPresent()) {
            Keyframe<T> keyframe = list.getFirst();
            Keyframe<T> keyframe1 = list.getLast();
            list1.add(new a<T>(track, keyframe1, keyframe1.a() - periodTicks.get(), keyframe, keyframe.a()));
            KeyframeTrackSampler.a(track, list, list1);
            list1.add(new a<T>(track, keyframe1, keyframe1.a(), keyframe, keyframe.a() + periodTicks.get()));
        } else {
            KeyframeTrackSampler.a(track, list, list1);
        }
        return List.copyOf(list1);
    }

    private static <T> void a(KeyframeTrack<T> track, List<Keyframe<T>> keyframes, List<a<T>> output) {
        for (int i2 = 0; i2 < keyframes.size() - 1; ++i2) {
            Keyframe<T> keyframe = keyframes.get(i2);
            Keyframe<T> keyframe1 = keyframes.get(i2 + 1);
            output.add(new a<T>(track, keyframe, keyframe.a(), keyframe1, keyframe1.a()));
        }
    }

    public T a(long ticks) {
        long l2 = this.c(ticks);
        a<T> segmentAt = this.b(l2);
        if (l2 <= (long)segmentAt.c) {
            return segmentAt.b;
        }
        if (l2 >= (long)segmentAt.e) {
            return segmentAt.d;
        }
        float f2 = (float)(l2 - (long)segmentAt.c) / (float)(segmentAt.e - segmentAt.c);
        float f1 = segmentAt.a.apply(f2);
        return this.b.apply(f1, segmentAt.b, segmentAt.d);
    }

    private a<T> b(long currentTicks) {
        for (a<T> segment : this.c) {
            if (currentTicks >= (long)segment.e) continue;
            return segment;
        }
        return this.c.getLast();
    }

    private long c(long ticks) {
        return this.a.isPresent() ? (long)Math.floorMod(ticks, (int)this.a.get()) : ticks;
    }

    record a<T>(EasingType a, T b, int c, T d, int e) {
        public a(KeyframeTrack<T> track, Keyframe<T> from, int fromTicks, Keyframe<T> to, int toTicks) {
            this(track.b(), from.b(), fromTicks, to.b(), toTicks);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "easing;fromValue;fromTicks;toValue;toTicks", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "easing;fromValue;fromTicks;toValue;toTicks", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "easing;fromValue;fromTicks;toValue;toTicks", "a", "b", "c", "d", "e"}, this, o2);
        }
    }
}

