/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.Locale;
import java.util.UUID;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.util.ARGB;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.math.Fraction;
import org.apache.commons.lang3.math.NumberUtils;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class MathHelper {
    private static final long k = 61440L;
    private static final long l = 16384L;
    private static final long m = -4611686018427387904L;
    private static final long n = Long.MIN_VALUE;
    public static final float a = (float)java.lang.Math.PI;
    public static final float b = 1.5707964f;
    public static final float c = (float)java.lang.Math.PI * 2;
    public static final float d = (float)java.lang.Math.PI / 180;
    public static final float e = 57.295776f;
    public static final float f = 1.0E-5f;
    public static final float g = MathHelper.a(2.0f);
    public static final Vector3f h = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3f i = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3f j = new Vector3f(0.0f, 0.0f, 1.0f);
    private static final int o = 65536;
    private static final int p = 65535;
    private static final int q = 16384;
    private static final double r = 10430.378350470453;
    private static final float[] s = SystemUtils.a(new float[65536], floats -> {
        for (int i1 = 0; i1 < ((float[])floats).length; ++i1) {
            floats[i1] = (float)java.lang.Math.sin((double)i1 / 10430.378350470453);
        }
    });
    private static final RandomSource t = RandomSource.b();
    private static final int[] u = new int[]{0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9};
    private static final double v = 0.16666666666666666;
    private static final int w = 8;
    private static final int x = 257;
    private static final double y = Double.longBitsToDouble(4805340802404319232L);
    private static final double[] z = new double[257];
    private static final double[] A = new double[257];

    public static float a(double value) {
        return s[(int)((long)(value * 10430.378350470453) & 0xFFFFL)];
    }

    public static float b(double value) {
        return s[(int)((long)(value * 10430.378350470453 + 16384.0) & 0xFFFFL)];
    }

    public static float a(float value) {
        return (float)java.lang.Math.sqrt(value);
    }

    public static int b(float value) {
        int i2 = (int)value;
        return value < (float)i2 ? i2 - 1 : i2;
    }

    public static int c(double value) {
        int i2 = (int)value;
        return value < (double)i2 ? i2 - 1 : i2;
    }

    public static long d(double value) {
        long l2 = (long)value;
        return value < (double)l2 ? l2 - 1L : l2;
    }

    public static float c(float value) {
        return java.lang.Math.abs(value);
    }

    public static int a(int value) {
        return java.lang.Math.abs(value);
    }

    public static int d(float value) {
        int i2 = (int)value;
        return value > (float)i2 ? i2 + 1 : i2;
    }

    public static int e(double value) {
        int i2 = (int)value;
        return value > (double)i2 ? i2 + 1 : i2;
    }

    public static long f(double value) {
        long l2 = (long)value;
        return value > (double)l2 ? l2 + 1L : l2;
    }

    public static int a(int value, int min, int max) {
        return java.lang.Math.min(java.lang.Math.max(value, min), max);
    }

    public static long a(long value, long min, long max) {
        return java.lang.Math.min(java.lang.Math.max(value, min), max);
    }

    public static float a(float value, float min, float max) {
        return value < min ? min : java.lang.Math.min(value, max);
    }

    public static double a(double value, double min, double max) {
        return value < min ? min : java.lang.Math.min(value, max);
    }

    public static double b(double start, double end, double delta) {
        if (start < 0.0) {
            return end;
        }
        return start > 1.0 ? delta : MathHelper.d(start, end, delta);
    }

    public static float b(float start, float end, float delta) {
        if (start < 0.0f) {
            return end;
        }
        return start > 1.0f ? delta : MathHelper.h(start, end, delta);
    }

    public static int a(int i2, int i1) {
        return java.lang.Math.max(java.lang.Math.abs(i2), java.lang.Math.abs(i1));
    }

    public static float a(float f2, float f1) {
        return java.lang.Math.max(java.lang.Math.abs(f2), java.lang.Math.abs(f1));
    }

    public static double a(double x2, double y2) {
        return java.lang.Math.max(java.lang.Math.abs(x2), java.lang.Math.abs(y2));
    }

    public static int a(int i2, int i1, int i22, int i3) {
        return MathHelper.a(i22 - i2, i3 - i1);
    }

    public static int b(int dividend, int divisor) {
        return java.lang.Math.floorDiv(dividend, divisor);
    }

    public static int a(RandomSource random, int minimum, int maximum) {
        return minimum >= maximum ? minimum : random.a(maximum - minimum + 1) + minimum;
    }

    public static float a(RandomSource random, float minimum, float maximum) {
        return minimum >= maximum ? minimum : random.i() * (maximum - minimum) + minimum;
    }

    public static double a(RandomSource random, double minimum, double maximum) {
        return minimum >= maximum ? minimum : random.j() * (maximum - minimum) + minimum;
    }

    public static boolean b(float x2, float y2) {
        return java.lang.Math.abs(y2 - x2) < 1.0E-5f;
    }

    public static boolean b(double x2, double y2) {
        return java.lang.Math.abs(y2 - x2) < (double)1.0E-5f;
    }

    public static int c(int x2, int y2) {
        return java.lang.Math.floorMod(x2, y2);
    }

    public static float c(float numerator, float denominator) {
        return (numerator % denominator + denominator) % denominator;
    }

    public static double c(double numerator, double denominator) {
        return (numerator % denominator + denominator) % denominator;
    }

    public static boolean d(int number, int multiple) {
        return number % multiple == 0;
    }

    public static byte e(float degrees) {
        return (byte)MathHelper.b(degrees * 256.0f / 360.0f);
    }

    public static float a(byte degrees) {
        return (float)(degrees * 360) / 256.0f;
    }

    public static int b(int angle) {
        int i2 = angle % 360;
        if (i2 >= 180) {
            i2 -= 360;
        }
        if (i2 < -180) {
            i2 += 360;
        }
        return i2;
    }

    public static float a(long angle) {
        float f2 = angle % 360L;
        if (f2 >= 180.0f) {
            f2 -= 360.0f;
        }
        if (f2 < -180.0f) {
            f2 += 360.0f;
        }
        return f2;
    }

    public static float f(float value) {
        float f2 = value % 360.0f;
        if (f2 >= 180.0f) {
            f2 -= 360.0f;
        }
        if (f2 < -180.0f) {
            f2 += 360.0f;
        }
        return f2;
    }

    public static double g(double value) {
        double d2 = value % 360.0;
        if (d2 >= 180.0) {
            d2 -= 360.0;
        }
        if (d2 < -180.0) {
            d2 += 360.0;
        }
        return d2;
    }

    public static float d(float start, float end) {
        return MathHelper.f(end - start);
    }

    public static float e(float start, float end) {
        return MathHelper.c(MathHelper.d(start, end));
    }

    public static float c(float rotationToAdjust, float actualRotation, float maxDifference) {
        float f2 = MathHelper.d(rotationToAdjust, actualRotation);
        float f1 = MathHelper.a(f2, -maxDifference, maxDifference);
        return actualRotation - f1;
    }

    public static float d(float value, float limit, float stepSize) {
        stepSize = MathHelper.c(stepSize);
        return value < limit ? MathHelper.a(value + stepSize, value, limit) : MathHelper.a(value - stepSize, limit, value);
    }

    public static float e(float angle, float limit, float stepSize) {
        float f2 = MathHelper.d(angle, limit);
        return MathHelper.d(angle, angle + f2, stepSize);
    }

    public static int a(String value, int defaultValue) {
        return NumberUtils.toInt((String)value, (int)defaultValue);
    }

    public static int c(int value) {
        int i2 = value - 1;
        i2 |= i2 >> 1;
        i2 |= i2 >> 2;
        i2 |= i2 >> 4;
        i2 |= i2 >> 8;
        i2 |= i2 >> 16;
        return i2 + 1;
    }

    public static int d(int itemCount) {
        if (itemCount < 0) {
            throw new IllegalArgumentException("itemCount must be greater than or equal to zero");
        }
        return MathHelper.e(java.lang.Math.sqrt(itemCount));
    }

    public static boolean e(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public static int f(int value) {
        value = MathHelper.e(value) ? value : MathHelper.c(value);
        return u[(int)((long)value * 125613361L >> 27) & 0x1F];
    }

    public static int g(int value) {
        return MathHelper.f(value) - (MathHelper.e(value) ? 0 : 1);
    }

    public static float g(float number) {
        return number - (float)MathHelper.b(number);
    }

    public static double h(double number) {
        return number - (double)MathHelper.d(number);
    }

    @Deprecated
    public static long a(BaseBlockPosition pos) {
        return MathHelper.b(pos.u(), pos.v(), pos.w());
    }

    @Deprecated
    public static long b(int x2, int y2, int z2) {
        long l2 = (long)(x2 * 3129871) ^ (long)z2 * 116129781L ^ (long)y2;
        l2 = l2 * l2 * 42317861L + l2 * 11L;
        return l2 >> 16;
    }

    public static UUID a(RandomSource random) {
        long l2 = random.g() & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        long l1 = random.g() & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new UUID(l2, l1);
    }

    public static UUID a() {
        return MathHelper.a(t);
    }

    public static double c(double delta, double start, double end) {
        return (delta - start) / (end - start);
    }

    public static float f(float delta, float start, float end) {
        return (delta - start) / (end - start);
    }

    public static boolean a(Vec3D start, Vec3D end, AxisAlignedBB boundingBox) {
        double d2 = (boundingBox.a + boundingBox.d) * 0.5;
        double d1 = (boundingBox.d - boundingBox.a) * 0.5;
        double d22 = start.g - d2;
        if (java.lang.Math.abs(d22) > d1 && d22 * end.g >= 0.0) {
            return false;
        }
        double d3 = (boundingBox.b + boundingBox.e) * 0.5;
        double d4 = (boundingBox.e - boundingBox.b) * 0.5;
        double d5 = start.h - d3;
        if (java.lang.Math.abs(d5) > d4 && d5 * end.h >= 0.0) {
            return false;
        }
        double d6 = (boundingBox.c + boundingBox.f) * 0.5;
        double d7 = (boundingBox.f - boundingBox.c) * 0.5;
        double d8 = start.i - d6;
        if (java.lang.Math.abs(d8) > d7 && d8 * end.i >= 0.0) {
            return false;
        }
        double abs = java.lang.Math.abs(end.g);
        double abs1 = java.lang.Math.abs(end.h);
        double abs2 = java.lang.Math.abs(end.i);
        double d9 = end.h * d8 - end.i * d5;
        if (java.lang.Math.abs(d9) > d4 * abs2 + d7 * abs1) {
            return false;
        }
        d9 = end.i * d22 - end.g * d8;
        if (java.lang.Math.abs(d9) > d1 * abs2 + d7 * abs) {
            return false;
        }
        d9 = end.g * d5 - end.h * d22;
        return java.lang.Math.abs(d9) < d1 * abs1 + d4 * abs;
    }

    public static double d(double y2, double x2) {
        double d1;
        boolean flag2;
        boolean flag1;
        boolean flag;
        double d2 = x2 * x2 + y2 * y2;
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        boolean bl = flag = y2 < 0.0;
        if (flag) {
            y2 = -y2;
        }
        boolean bl2 = flag1 = x2 < 0.0;
        if (flag1) {
            x2 = -x2;
        }
        boolean bl3 = flag2 = y2 > x2;
        if (flag2) {
            d1 = x2;
            x2 = y2;
            y2 = d1;
        }
        d1 = MathHelper.j(d2);
        x2 *= d1;
        double d22 = y + (y2 *= d1);
        int i2 = (int)Double.doubleToRawLongBits(d22);
        double d3 = z[i2];
        double d4 = A[i2];
        double d5 = d22 - y;
        double d6 = y2 * d4 - x2 * d5;
        double d7 = (6.0 + d6 * d6) * d6 * 0.16666666666666666;
        double d8 = d3 + d7;
        if (flag2) {
            d8 = 1.5707963267948966 - d8;
        }
        if (flag1) {
            d8 = java.lang.Math.PI - d8;
        }
        if (flag) {
            d8 = -d8;
        }
        return d8;
    }

    public static float h(float number) {
        return Math.invsqrt((float)number);
    }

    public static double i(double number) {
        return Math.invsqrt((double)number);
    }

    @Deprecated
    public static double j(double number) {
        double d2 = 0.5 * number;
        long l2 = Double.doubleToRawLongBits(number);
        l2 = 6910469410427058090L - (l2 >> 1);
        number = Double.longBitsToDouble(l2);
        return number * (1.5 - d2 * number * number);
    }

    public static float i(float number) {
        int i2 = Float.floatToIntBits(number);
        i2 = 1419967116 - i2 / 3;
        float f2 = Float.intBitsToFloat(i2);
        f2 = 0.6666667f * f2 + 1.0f / (3.0f * f2 * f2 * number);
        return 0.6666667f * f2 + 1.0f / (3.0f * f2 * f2 * number);
    }

    public static int g(float hue, float saturation, float value) {
        return MathHelper.a(hue, saturation, value, 0);
    }

    public static int a(float hue, float saturation, float value, int alpha) {
        float f5;
        float f4;
        int i2 = (int)(hue * 6.0f) % 6;
        float f2 = hue * 6.0f - (float)i2;
        float f1 = value * (1.0f - saturation);
        float f22 = value * (1.0f - f2 * saturation);
        float f3 = value * (1.0f - (1.0f - f2) * saturation);
        return ARGB.b(alpha, MathHelper.a((int)(f4 * 255.0f), 0, 255), MathHelper.a((int)(f5 * 255.0f), 0, 255), MathHelper.a((int)((switch (i2) {
            case 0 -> {
                f4 = value;
                f5 = f3;
                yield f1;
            }
            case 1 -> {
                f4 = f22;
                f5 = value;
                yield f1;
            }
            case 2 -> {
                f4 = f1;
                f5 = value;
                yield f3;
            }
            case 3 -> {
                f4 = f1;
                f5 = f22;
                yield value;
            }
            case 4 -> {
                f4 = f3;
                f5 = f1;
                yield value;
            }
            case 5 -> {
                f4 = value;
                f5 = f1;
                yield f22;
            }
            default -> throw new RuntimeException("Something went wrong when converting from HSV to RGB. Input was " + hue + ", " + saturation + ", " + value);
        }) * 255.0f), 0, 255));
    }

    public static int h(int input) {
        input ^= input >>> 16;
        input *= -2048144789;
        input ^= input >>> 13;
        return (input *= -1028477387) ^ input >>> 16;
    }

    public static int a(int min, int max, IntPredicate isTargetBeforeOrAt) {
        int i2 = max - min;
        while (i2 > 0) {
            int i1 = i2 / 2;
            int i22 = min + i1;
            if (isTargetBeforeOrAt.test(i22)) {
                i2 = i1;
                continue;
            }
            min = i22 + 1;
            i2 -= i1 + 1;
        }
        return min;
    }

    public static int a(float delta, int start, int end) {
        return start + MathHelper.b(delta * (float)(end - start));
    }

    public static int b(float delta, int start, int end) {
        int i2 = end - start;
        return start + MathHelper.b(delta * (float)(i2 - 1)) + (delta > 0.0f ? 1 : 0);
    }

    public static float h(float delta, float start, float end) {
        return start + delta * (end - start);
    }

    public static Vec3D a(double delta, Vec3D start, Vec3D end) {
        return new Vec3D(MathHelper.d(delta, start.g, end.g), MathHelper.d(delta, start.h, end.h), MathHelper.d(delta, start.i, end.i));
    }

    public static double d(double delta, double start, double end) {
        return start + delta * (end - start);
    }

    public static double a(double delta1, double delta2, double start1, double end1, double start2, double end2) {
        return MathHelper.d(delta2, MathHelper.d(delta1, start1, end1), MathHelper.d(delta1, start2, end2));
    }

    public static double a(double delta1, double delta2, double delta3, double start1, double end1, double start2, double end2, double start3, double end3, double start4, double end4) {
        return MathHelper.d(delta3, MathHelper.a(delta1, delta2, start1, end1, start2, end2), MathHelper.a(delta1, delta2, start3, end3, start4, end4));
    }

    public static float a(float delta, float controlPoint1, float controlPoint2, float controlPoint3, float controlPoint4) {
        return 0.5f * (2.0f * controlPoint2 + (controlPoint3 - controlPoint1) * delta + (2.0f * controlPoint1 - 5.0f * controlPoint2 + 4.0f * controlPoint3 - controlPoint4) * delta * delta + (3.0f * controlPoint2 - controlPoint1 - 3.0f * controlPoint3 + controlPoint4) * delta * delta * delta);
    }

    public static double k(double input) {
        return input * input * input * (input * (input * 6.0 - 15.0) + 10.0);
    }

    public static double l(double input) {
        return 30.0 * input * input * (input - 1.0) * (input - 1.0);
    }

    public static int m(double x2) {
        if (x2 == 0.0) {
            return 0;
        }
        return x2 > 0.0 ? 1 : -1;
    }

    public static float i(float delta, float start, float end) {
        return start + delta * MathHelper.f(end - start);
    }

    public static double e(double delta, double start, double end) {
        return start + delta * MathHelper.g(end - start);
    }

    public static float j(float delta, float start, float end) {
        float f2;
        for (f2 = end - start; f2 < (float)(-java.lang.Math.PI); f2 += (float)java.lang.Math.PI * 2) {
        }
        while (f2 >= (float)java.lang.Math.PI) {
            f2 -= (float)java.lang.Math.PI * 2;
        }
        return start + delta * f2;
    }

    public static float f(float input, float period) {
        return (java.lang.Math.abs(input % period - period * 0.5f) - period * 0.25f) / (period * 0.25f);
    }

    public static float j(float value) {
        return value * value;
    }

    public static float k(float value) {
        return value * value * value;
    }

    public static double n(double value) {
        return value * value;
    }

    public static int i(int value) {
        return value * value;
    }

    public static long b(long value) {
        return value * value;
    }

    public static double a(double input, double inputMin, double inputMax, double outputMin, double outputMax) {
        return MathHelper.b(MathHelper.c(input, inputMin, inputMax), outputMin, outputMax);
    }

    public static float b(float input, float inputMin, float inputMax, float outputMin, float outputMax) {
        return MathHelper.b(MathHelper.f(input, inputMin, inputMax), outputMin, outputMax);
    }

    public static double b(double input, double inputMin, double inputMax, double outputMin, double outputMax) {
        return MathHelper.d(MathHelper.c(input, inputMin, inputMax), outputMin, outputMax);
    }

    public static float c(float input, float inputMin, float inputMax, float outputMin, float outputMax) {
        return MathHelper.h(MathHelper.f(input, inputMin, inputMax), outputMin, outputMax);
    }

    public static double o(double input) {
        return input + (2.0 * RandomSource.a(MathHelper.c(input * 3000.0)).j() - 1.0) * 1.0E-7 / 2.0;
    }

    public static int e(int value, int factor) {
        return MathHelper.f(value, factor) * factor;
    }

    public static int f(int x2, int y2) {
        return -java.lang.Math.floorDiv(-x2, y2);
    }

    public static int b(RandomSource random, int minInclusive, int maxInclusive) {
        return random.a(maxInclusive - minInclusive + 1) + minInclusive;
    }

    public static float b(RandomSource random, float minInclusive, float maxExclusive) {
        return random.i() * (maxExclusive - minInclusive) + minInclusive;
    }

    public static float c(RandomSource random, float mean, float deviation) {
        return mean + (float)random.k() * deviation;
    }

    public static double e(double xDistance, double yDistance) {
        return xDistance * xDistance + yDistance * yDistance;
    }

    public static double f(double xDistance, double yDistance) {
        return java.lang.Math.sqrt(MathHelper.e(xDistance, yDistance));
    }

    public static float g(float xDistance, float yDistance) {
        return (float)java.lang.Math.sqrt(MathHelper.e((double)xDistance, (double)yDistance));
    }

    public static double f(double xDistance, double yDistance, double zDistance) {
        return xDistance * xDistance + yDistance * yDistance + zDistance * zDistance;
    }

    public static double g(double xDistance, double yDistance, double zDistance) {
        return java.lang.Math.sqrt(MathHelper.f(xDistance, yDistance, zDistance));
    }

    public static float k(float xDistance, float yDistance, float zDistance) {
        return xDistance * xDistance + yDistance * yDistance + zDistance * zDistance;
    }

    public static int a(double value, int factor) {
        return MathHelper.c(value / (double)factor) * factor;
    }

    public static IntStream c(int input, int lowerBound, int upperBound) {
        return MathHelper.b(input, lowerBound, upperBound, 1);
    }

    public static IntStream b(int input, int lowerBound, int upperBound, int steps) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "upperBound %d expected to be > lowerBound %d", upperBound, lowerBound));
        }
        if (steps < 1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "step size expected to be >= 1, was %d", steps));
        }
        int i2 = MathHelper.a(input, lowerBound, upperBound);
        return IntStream.iterate(i2, i1 -> {
            int abs = java.lang.Math.abs(i2 - i1);
            return i2 - abs >= lowerBound || i2 + abs <= upperBound;
        }, i1 -> {
            int i22;
            boolean flag1;
            boolean flag = i1 <= i2;
            int abs = java.lang.Math.abs(i2 - i1);
            boolean bl = flag1 = i2 + abs + steps <= upperBound;
            if (!(flag && flag1 || (i22 = i2 - abs - (flag ? steps : 0)) < lowerBound)) {
                return i22;
            }
            return i2 + abs + steps;
        });
    }

    public static Quaternionf a(Vector3f axis, Quaternionf cameraOrientation, Quaternionf output) {
        float f2 = axis.dot(cameraOrientation.x, cameraOrientation.y, cameraOrientation.z);
        return output.set(axis.x * f2, axis.y * f2, axis.z * f2, cameraOrientation.w).normalize();
    }

    public static int a(Fraction fraction, int factor) {
        return fraction.getNumerator() * factor / fraction.getDenominator();
    }

    static {
        for (int i2 = 0; i2 < 257; ++i2) {
            double d2 = (double)i2 / 256.0;
            double asin = java.lang.Math.asin(d2);
            MathHelper.A[i2] = java.lang.Math.cos(asin);
            MathHelper.z[i2] = asin;
        }
    }
}

