/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.authlib.yggdrasil.ServicesKeyType;
import com.mojang.logging.LogUtils;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Collection;
import net.minecraft.util.SignatureUpdater;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public interface SignatureValidator {
    public static final SignatureValidator a = (updater, signature) -> true;
    public static final Logger b = LogUtils.getLogger();

    public boolean validate(SignatureUpdater var1, byte[] var2);

    default public boolean a(byte[] digest, byte[] signature) {
        return this.validate(output -> output.update(digest), signature);
    }

    private static boolean a(SignatureUpdater updater, byte[] signatureBytes, Signature signature) throws SignatureException {
        updater.update(signature::update);
        return signature.verify(signatureBytes);
    }

    public static SignatureValidator a(PublicKey publicKey, String algorithm) {
        return (updater, signatureBytes) -> {
            try {
                Signature instance = Signature.getInstance(algorithm);
                instance.initVerify(publicKey);
                return SignatureValidator.a(updater, signatureBytes, instance);
            }
            catch (Exception var5) {
                b.error("Failed to verify signature", (Throwable)var5);
                return false;
            }
        };
    }

    public static @Nullable SignatureValidator a(ServicesKeySet serviceKeySet, ServicesKeyType serviceKeyType) {
        Collection collection = serviceKeySet.keys(serviceKeyType);
        return collection.isEmpty() ? null : (updater, signatureBytes) -> collection.stream().anyMatch(servicesKeyInfo -> {
            Signature signature = servicesKeyInfo.signature();
            try {
                return SignatureValidator.a(updater, signatureBytes, signature);
            }
            catch (SignatureException var5) {
                b.error("Failed to verify Services signature", (Throwable)var5);
                return false;
            }
        });
    }
}

