/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import ca.spottedleaf.concurrentutil.util.IntegerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.util.function.IntConsumer;
import net.minecraft.util.DataBits;
import org.apache.commons.lang3.Validate;
import org.jspecify.annotations.Nullable;

public class SimpleBitStorage
implements DataBits {
    private static final int[] a = new int[]{-1, -1, 0, Integer.MIN_VALUE, 0, 0, 0x55555555, 0x55555555, 0, Integer.MIN_VALUE, 0, 1, 0x33333333, 0x33333333, 0, 0x2AAAAAAA, 0x2AAAAAAA, 0, 0x24924924, 0x24924924, 0, Integer.MIN_VALUE, 0, 2, 0x1C71C71C, 0x1C71C71C, 0, 0x19999999, 0x19999999, 0, 390451572, 390451572, 0, 0x15555555, 0x15555555, 0, 0x13B13B13, 0x13B13B13, 0, 306783378, 306783378, 0, 0x11111111, 0x11111111, 0, Integer.MIN_VALUE, 0, 3, 0xF0F0F0F, 0xF0F0F0F, 0, 0xE38E38E, 0xE38E38E, 0, 226050910, 226050910, 0, 0xCCCCCCC, 0xCCCCCCC, 0, 0xC30C30C, 0xC30C30C, 0, 195225786, 195225786, 0, 186737708, 186737708, 0, 0xAAAAAAA, 0xAAAAAAA, 0, 171798691, 171798691, 0, 0x9D89D89, 0x9D89D89, 0, 159072862, 159072862, 0, 0x9249249, 0x9249249, 0, 148102320, 148102320, 0, 0x8888888, 0x8888888, 0, 138547332, 138547332, 0, Integer.MIN_VALUE, 0, 4, 130150524, 130150524, 0, 0x7878787, 0x7878787, 0, 0x7507507, 0x7507507, 0, 0x71C71C7, 0x71C71C7, 0, 116080197, 116080197, 0, 113025455, 113025455, 0, 0x6906906, 0x6906906, 0, 0x6666666, 0x6666666, 0, 104755299, 104755299, 0, 0x6186186, 0x6186186, 0, 99882960, 99882960, 0, 97612893, 97612893, 0, 0x5B05B05, 0x5B05B05, 0, 93368854, 93368854, 0, 91382282, 91382282, 0, 0x5555555, 0x5555555, 0, 87652393, 87652393, 0, 85899345, 85899345, 0, 0x5050505, 0x5050505, 0, 0x4EC4EC4, 0x4EC4EC4, 0, 81037118, 81037118, 0, 79536431, 79536431, 0, 78090314, 78090314, 0, 0x4924924, 0x4924924, 0, 75350303, 75350303, 0, 74051160, 74051160, 0, 72796055, 72796055, 0, 0x4444444, 0x4444444, 0, 70409299, 70409299, 0, 69273666, 69273666, 0, 0x4104104, 0x4104104, 0, Integer.MIN_VALUE, 0, 5};
    private final long[] b;
    private final int c;
    private final long d;
    private final int e;
    private final int f;
    private final int g;
    private final long divideMulUnsigned;
    private final int h;
    private final long divideAddUnsigned;
    private final int i;
    private static final int[] BETTER_MAGIC = new int[33];
    private final int magic;
    private final int mulBits;

    public SimpleBitStorage(int bits, int size, int[] data) {
        this(bits, size);
        int i1;
        int i2 = 0;
        for (i1 = 0; i1 <= size - this.f; i1 += this.f) {
            long l2 = 0L;
            for (int i22 = this.f - 1; i22 >= 0; --i22) {
                l2 <<= bits;
                l2 |= (long)data[i1 + i22] & this.d;
            }
            this.b[i2++] = l2;
        }
        int i3 = size - i1;
        if (i3 > 0) {
            long l1 = 0L;
            for (int i4 = i3 - 1; i4 >= 0; --i4) {
                l1 <<= bits;
                l1 |= (long)data[i1 + i4] & this.d;
            }
            this.b[i2] = l1;
        }
    }

    public SimpleBitStorage(int bits, int size) {
        this(bits, size, (long[])null);
    }

    public SimpleBitStorage(int bits, int size, long @Nullable [] data) {
        Validate.inclusiveBetween((long)1L, (long)32L, (long)bits);
        this.e = size;
        this.c = bits;
        this.d = (1L << bits) - 1L;
        this.f = (char)(64 / bits);
        int i2 = 3 * (this.f - 1);
        this.g = a[i2 + 0];
        this.divideMulUnsigned = Integer.toUnsignedLong(this.g);
        this.h = a[i2 + 1];
        this.divideAddUnsigned = Integer.toUnsignedLong(this.h);
        this.i = a[i2 + 2];
        int i1 = (size + this.f - 1) / this.f;
        if (data != null) {
            if (data.length != i1) {
                throw new a("Invalid length given for storage, got: " + data.length + " but expected: " + i1);
            }
            this.b = data;
        } else {
            this.b = new long[i1];
        }
        this.magic = BETTER_MAGIC[this.c];
        this.mulBits = 64 / this.c * this.c;
        if (this.e > 4096) {
            throw new IllegalStateException("Size > 4096 not supported");
        }
    }

    private int b(int index) {
        return (int)((long)index * this.divideMulUnsigned + this.divideAddUnsigned >> 32 >> this.i);
    }

    @Override
    public final int a(int index, int value) {
        long write;
        int full = this.magic * index;
        int divQ = full >>> 20;
        int divR = (full & 0xFFFFF) * this.mulBits >>> 20;
        long[] dataArray = this.b;
        long data = dataArray[divQ];
        long mask = this.d;
        dataArray[divQ] = write = data & (mask << divR ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & mask) << divR;
        return (int)(data >>> divR & mask);
    }

    @Override
    public final void b(int index, int value) {
        long write;
        int full = this.magic * index;
        int divQ = full >>> 20;
        int divR = (full & 0xFFFFF) * this.mulBits >>> 20;
        long[] dataArray = this.b;
        long data = dataArray[divQ];
        long mask = this.d;
        dataArray[divQ] = write = data & (mask << divR ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & mask) << divR;
    }

    @Override
    public final int a(int index) {
        int full = this.magic * index;
        int divQ = full >>> 20;
        int divR = (full & 0xFFFFF) * this.mulBits >>> 20;
        return (int)(this.b[divQ] >>> divR & this.d);
    }

    @Override
    public long[] a() {
        return this.b;
    }

    @Override
    public int b() {
        return this.e;
    }

    @Override
    public int c() {
        return this.c;
    }

    @Override
    public void a(IntConsumer consumer) {
        int i2 = 0;
        for (long l2 : this.b) {
            for (int i1 = 0; i1 < this.f; ++i1) {
                consumer.accept((int)(l2 & this.d));
                l2 >>= this.c;
                if (++i2 < this.e) continue;
                return;
            }
        }
    }

    @Override
    public void a(int[] array) {
        int i3;
        long l2;
        int i2;
        int i4 = this.b.length;
        int i1 = 0;
        for (i2 = 0; i2 < i4 - 1; ++i2) {
            l2 = this.b[i2];
            for (i3 = 0; i3 < this.f; ++i3) {
                array[i1 + i3] = (int)(l2 & this.d);
                l2 >>= this.c;
            }
            i1 += this.f;
        }
        i2 = this.e - i1;
        if (i2 > 0) {
            l2 = this.b[i4 - 1];
            for (i3 = 0; i3 < i2; ++i3) {
                array[i1 + i3] = (int)(l2 & this.d);
                l2 >>= this.c;
            }
        }
    }

    @Override
    public DataBits d() {
        return new SimpleBitStorage(this.c, this.e, (long[])this.b.clone());
    }

    @Override
    public final Int2ObjectOpenHashMap<ShortArrayList> moonrise$countEntries() {
        int valuesPerLong = this.f;
        int bits = this.c;
        long mask = (1L << bits) - 1L;
        int size = this.e;
        if (bits <= 6) {
            ShortArrayList[] byId = new ShortArrayList[1 << bits];
            Int2ObjectOpenHashMap ret = new Int2ObjectOpenHashMap(1 << bits);
            int index = 0;
            for (long value : this.b) {
                int li = 0;
                do {
                    ShortArrayList newCoords;
                    int paletteIdx = (int)(value & mask);
                    value >>= bits;
                    ++li;
                    ShortArrayList coords = byId[paletteIdx];
                    if (coords != null) {
                        coords.add((short)index++);
                        continue;
                    }
                    byId[paletteIdx] = newCoords = new ShortArrayList(64);
                    newCoords.add((short)index++);
                    ret.put(paletteIdx, (Object)newCoords);
                } while (li < valuesPerLong && index < size);
            }
            return ret;
        }
        Int2ObjectOpenHashMap ret = new Int2ObjectOpenHashMap(64);
        int index = 0;
        for (long value : this.b) {
            int li = 0;
            do {
                int paletteIdx = (int)(value & mask);
                value >>= bits;
                ((ShortArrayList)ret.computeIfAbsent(paletteIdx, key -> new ShortArrayList(64))).add((short)index++);
            } while (++li < valuesPerLong && index < size);
        }
        return ret;
    }

    static {
        for (int bits = 1; bits < BETTER_MAGIC.length; ++bits) {
            SimpleBitStorage.BETTER_MAGIC[bits] = (int)IntegerUtil.getUnsignedDivisorMagic((long)(64L / (long)bits), (int)20);
        }
    }

    public static class a
    extends RuntimeException {
        a(String message) {
            super(message);
        }
    }
}

