/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.MathHelper;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;

public class UtilColor {
    private static final Pattern a = Pattern.compile("(?i)\\u00A7[0-9A-FK-OR]");
    private static final Pattern b = Pattern.compile("\\r\\n|\\v");
    private static final Pattern c = Pattern.compile("(?:\\r\\n|\\v)$");

    public static String a(int ticks, float ticksPerSecond) {
        int floor = MathHelper.b((float)ticks / ticksPerSecond);
        int i2 = floor / 60;
        int i1 = i2 / 60;
        return i1 > 0 ? String.format(Locale.ROOT, "%02d:%02d:%02d", i1, i2, floor) : String.format(Locale.ROOT, "%02d:%02d", i2 %= 60, floor %= 60);
    }

    public static String a(String text) {
        return a.matcher(text).replaceAll("");
    }

    public static boolean b(@Nullable String string) {
        return StringUtils.isEmpty((CharSequence)string);
    }

    public static String a(String string, int maxSize, boolean addEllipsis) {
        if (string.length() <= maxSize) {
            return string;
        }
        return addEllipsis && maxSize > 3 ? string.substring(0, maxSize - 3) + "..." : string.substring(0, maxSize);
    }

    public static int c(String string) {
        if (string.isEmpty()) {
            return 0;
        }
        Matcher matcher = b.matcher(string);
        int i2 = 1;
        while (matcher.find()) {
            ++i2;
        }
        return i2;
    }

    public static boolean d(String string) {
        return c.matcher(string).find();
    }

    public static String e(String string) {
        return UtilColor.a(string, 256, false);
    }

    public static boolean a(int codePoint) {
        return codePoint != 167 && codePoint >= 32 && codePoint != 127;
    }

    public static boolean f(String playerName) {
        return playerName.length() <= 16 && playerName.chars().filter(i2 -> i2 <= 32 || i2 >= 127).findAny().isEmpty();
    }

    public static String g(String text) {
        return UtilColor.a(text, false);
    }

    public static String a(String text, boolean allowLineBreaks) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c2 : text.toCharArray()) {
            if (UtilColor.a(c2)) {
                stringBuilder.append(c2);
                continue;
            }
            if (!allowLineBreaks || c2 != '\n') continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static boolean isReasonablePlayerName(String name) {
        if (name.isEmpty() || name.length() > 16) {
            return false;
        }
        int len = name.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = name.charAt(i2);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '_' || c2 == '.') continue;
            return false;
        }
        return true;
    }

    public static boolean b(int character) {
        return Character.isWhitespace(character) || Character.isSpaceChar(character);
    }

    public static boolean h(@Nullable String string) {
        return string == null || string.isEmpty() || string.chars().allMatch(UtilColor::b);
    }
}

