/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.context;

import com.google.common.collect.Sets;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.util.context.ContextKey;
import net.minecraft.util.context.ContextKeySet;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public class ContextMap {
    private final Map<ContextKey<?>, Object> a;

    ContextMap(Map<ContextKey<?>, Object> params) {
        this.a = params;
    }

    public boolean a(ContextKey<?> key) {
        return this.a.containsKey(key);
    }

    public <T> T b(ContextKey<T> key) {
        Object object = this.a.get(key);
        if (object == null) {
            throw new NoSuchElementException(key.a().toString());
        }
        return (T)object;
    }

    public <T> @Nullable T c(ContextKey<T> key) {
        return (T)this.a.get(key);
    }

    @Contract(value="_,!null->!null; _,_->_")
    public <T> @Nullable T a(ContextKey<T> key, @Nullable T defaultValue) {
        return (T)this.a.getOrDefault(key, defaultValue);
    }

    public static class a {
        private final Map<ContextKey<?>, Object> a = new IdentityHashMap();

        public <T> a a(ContextKey<T> key, T value) {
            this.a.put(key, value);
            return this;
        }

        public <T> a b(ContextKey<T> key, @Nullable T value) {
            if (value == null) {
                this.a.remove(key);
            } else {
                this.a.put(key, value);
            }
            return this;
        }

        public <T> T a(ContextKey<T> key) {
            Object object = this.a.get(key);
            if (object == null) {
                throw new NoSuchElementException(key.a().toString());
            }
            return (T)object;
        }

        public <T> @Nullable T b(ContextKey<T> key) {
            return (T)this.a.get(key);
        }

        public ContextMap a(ContextKeySet contextKeySet) {
            Sets.SetView set = Sets.difference(this.a.keySet(), contextKeySet.b());
            if (!set.isEmpty()) {
                throw new IllegalArgumentException("Parameters not allowed in this parameter set: " + String.valueOf(set));
            }
            Sets.SetView set1 = Sets.difference(contextKeySet.a(), this.a.keySet());
            if (!set1.isEmpty()) {
                throw new IllegalArgumentException("Missing required parameters: " + String.valueOf(set1));
            }
            return new ContextMap(this.a);
        }
    }
}

