/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.RewriteResult;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.View;
import com.mojang.datafixers.functions.PointFreeRule;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.BitSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SystemUtils;

public class ExtraDataFixUtils {
    public static Dynamic<?> a(Dynamic<?> data) {
        Optional optional = data.get("X").asNumber().result();
        Optional optional1 = data.get("Y").asNumber().result();
        Optional optional2 = data.get("Z").asNumber().result();
        return !optional.isEmpty() && !optional1.isEmpty() && !optional2.isEmpty() ? ExtraDataFixUtils.a(data, ((Number)optional.get()).intValue(), ((Number)optional1.get()).intValue(), ((Number)optional2.get()).intValue()) : data;
    }

    public static Dynamic<?> a(Dynamic<?> data, String xField, String yField, String zField, String newPosField) {
        Optional optional = data.get(xField).asNumber().result();
        Optional optional1 = data.get(yField).asNumber().result();
        Optional optional2 = data.get(zField).asNumber().result();
        return !optional.isEmpty() && !optional1.isEmpty() && !optional2.isEmpty() ? data.remove(xField).remove(yField).remove(zField).set(newPosField, ExtraDataFixUtils.a(data, ((Number)optional.get()).intValue(), ((Number)optional1.get()).intValue(), ((Number)optional2.get()).intValue())) : data;
    }

    public static Dynamic<?> a(Dynamic<?> data, int x2, int y2, int z2) {
        return data.createIntList(IntStream.of(x2, y2, z2));
    }

    public static <T, R> Typed<R> a(Type<R> type, Typed<T> data) {
        return new Typed(type, data.getOps(), data.getValue());
    }

    public static <T> Typed<T> a(Type<T> type, Object data, DynamicOps<?> ops) {
        return new Typed(type, ops, data);
    }

    public static Type<?> a(Type<?> type, Type<?> oldSubType, Type<?> newSubType) {
        return type.all(ExtraDataFixUtils.a(oldSubType, newSubType), true, false).view().newType();
    }

    private static <A, B> TypeRewriteRule a(Type<A> oldType, Type<B> newType) {
        RewriteResult rewriteResult = RewriteResult.create((View)View.create((String)"Patcher", oldType, newType, dynamicOps -> object -> {
            throw new UnsupportedOperationException();
        }), (BitSet)new BitSet());
        return TypeRewriteRule.everywhere((TypeRewriteRule)TypeRewriteRule.ifSame(oldType, (RewriteResult)rewriteResult), (PointFreeRule)PointFreeRule.nop(), (boolean)true, (boolean)true);
    }

    @SafeVarargs
    public static <T> Function<Typed<?>, Typed<?>> a(Function<Typed<?>, Typed<?>> ... filters) {
        return typed -> {
            for (Function function : filters) {
                typed = (Typed)function.apply(typed);
            }
            return typed;
        };
    }

    public static Dynamic<?> a(String blockId, Map<String, String> properties) {
        Dynamic<NBTTagCompound> dynamic = new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, new NBTTagCompound());
        Dynamic<NBTTagCompound> dynamic1 = dynamic.set("Name", dynamic.createString(blockId));
        if (!properties.isEmpty()) {
            dynamic1 = dynamic1.set("Properties", dynamic.createMap(properties.entrySet().stream().collect(Collectors.toMap(entry -> dynamic.createString((String)entry.getKey()), entry -> dynamic.createString((String)entry.getValue())))));
        }
        return dynamic1;
    }

    public static Dynamic<?> a(String blockId) {
        return ExtraDataFixUtils.a(blockId, Map.of());
    }

    public static Dynamic<?> a(Dynamic<?> data, String fieldName, UnaryOperator<String> fixer) {
        return data.update(fieldName, dynamic -> (Dynamic)((Object)((Object)DataFixUtils.orElse((Optional)dynamic.asString().map((Function)fixer).map(arg_0 -> ((Dynamic)data).createString(arg_0)).result(), (Object)dynamic))));
    }

    public static String a(int colorId) {
        return switch (colorId) {
            case 1 -> "orange";
            case 2 -> "magenta";
            case 3 -> "light_blue";
            case 4 -> "yellow";
            case 5 -> "lime";
            case 6 -> "pink";
            case 7 -> "gray";
            case 8 -> "light_gray";
            case 9 -> "cyan";
            case 10 -> "purple";
            case 11 -> "blue";
            case 12 -> "brown";
            case 13 -> "green";
            case 14 -> "red";
            case 15 -> "black";
            default -> "white";
        };
    }

    public static <T> Typed<?> a(Typed<?> typed, OpticFinder<T> optic, Dynamic<?> data) {
        return typed.set(optic, SystemUtils.a(optic.type(), data, true));
    }
}

