/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import java.util.stream.IntStream;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class ChunkTicketUnpackPosFix
extends DataFix {
    private static final long a = 32L;
    private static final long b = 0xFFFFFFFFL;

    public ChunkTicketUnpackPosFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("ChunkTicketUnpackPosFix", this.getInputSchema().getType(DataConverterTypes.j), typed -> typed.update(DSL.remainderFinder(), dynamic -> dynamic.update("data", dynamic1 -> dynamic1.update("tickets", dynamic2 -> dynamic2.createList(dynamic2.asStream().map(dynamic3 -> dynamic3.update("chunk_pos", dynamic4 -> {
            long _long = dynamic4.asLong(0L);
            int i2 = (int)(_long & 0xFFFFFFFFL);
            int i1 = (int)(_long >>> 32 & 0xFFFFFFFFL);
            return dynamic4.createIntList(IntStream.of(i2, i1));
        })))))));
    }
}

