/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class DataConverterCustomNameEntity
extends DataFix {
    public DataConverterCustomNameEntity(Schema outputSchema) {
        super(outputSchema, true);
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.H);
        Type type1 = this.getOutputSchema().getType(DataConverterTypes.H);
        OpticFinder opticFinder = DSL.fieldFinder((String)"id", DataConverterSchemaNamed.a());
        OpticFinder opticFinder1 = type.findField("CustomName");
        Type type2 = type1.findFieldType("CustomName");
        return this.fixTypeEverywhereTyped("EntityCustomNameToComponentFix", type, type1, typed -> DataConverterCustomNameEntity.a(typed, type1, (OpticFinder<String>)opticFinder, (OpticFinder<String>)opticFinder1, type2));
    }

    private static <T> Typed<?> a(Typed<?> data, Type<?> entityType, OpticFinder<String> customNameOptic, OpticFinder<String> idOptic, Type<T> newType) {
        Optional optional = data.getOptional(idOptic);
        if (optional.isEmpty()) {
            return ExtraDataFixUtils.a(entityType, data);
        }
        if (((String)optional.get()).isEmpty()) {
            return SystemUtils.a(data, entityType, dynamic1 -> dynamic1.remove("CustomName"));
        }
        String string = data.getOptional(customNameOptic).orElse("");
        Dynamic<T> dynamic = DataConverterCustomNameEntity.a(data.getOps(), (String)optional.get(), string);
        return data.set(idOptic, SystemUtils.a(newType, dynamic));
    }

    private static <T> Dynamic<T> a(DynamicOps<T> ops, String customName, String id) {
        return "minecraft:commandblock_minecart".equals(id) ? new Dynamic<T>(ops, (Object)ops.createString(customName)) : LegacyComponentDataFixUtils.a(ops, customName);
    }
}

