/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterHeightmapRenaming
extends DataFix {
    public DataConverterHeightmapRenaming(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.d);
        OpticFinder opticFinder = type.findField("Level");
        return this.fixTypeEverywhereTyped("HeightmapRenamingFix", type, typed -> typed.updateTyped(opticFinder, typed1 -> typed1.update(DSL.remainderFinder(), this::a)));
    }

    private Dynamic<?> a(Dynamic<?> dynamic) {
        Optional optional4;
        Optional optional3;
        Optional optional2;
        Optional optional = dynamic.get("Heightmaps").result();
        if (optional.isEmpty()) {
            return dynamic;
        }
        Dynamic dynamic1 = (Dynamic)((Object)optional.get());
        Optional optional1 = dynamic1.get("LIQUID").result();
        if (optional1.isPresent()) {
            dynamic1 = dynamic1.remove("LIQUID");
            dynamic1 = dynamic1.set("WORLD_SURFACE_WG", (Dynamic)((Object)optional1.get()));
        }
        if ((optional2 = dynamic1.get("SOLID").result()).isPresent()) {
            dynamic1 = dynamic1.remove("SOLID");
            dynamic1 = dynamic1.set("OCEAN_FLOOR_WG", (Dynamic)((Object)optional2.get()));
            dynamic1 = dynamic1.set("OCEAN_FLOOR", (Dynamic)((Object)optional2.get()));
        }
        if ((optional3 = dynamic1.get("LIGHT").result()).isPresent()) {
            dynamic1 = dynamic1.remove("LIGHT");
            dynamic1 = dynamic1.set("LIGHT_BLOCKING", (Dynamic)((Object)optional3.get()));
        }
        if ((optional4 = dynamic1.get("RAIN").result()).isPresent()) {
            dynamic1 = dynamic1.remove("RAIN");
            dynamic1 = dynamic1.set("MOTION_BLOCKING", (Dynamic)((Object)optional4.get()));
            dynamic1 = dynamic1.set("MOTION_BLOCKING_NO_LEAVES", (Dynamic)((Object)optional4.get()));
        }
        return dynamic.set("Heightmaps", dynamic1);
    }
}

