/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterItemStackEnchantment
extends DataFix {
    private static final Int2ObjectMap<String> a = (Int2ObjectMap)DataFixUtils.make((Object)new Int2ObjectOpenHashMap(), map -> {
        map.put(0, (Object)"minecraft:protection");
        map.put(1, (Object)"minecraft:fire_protection");
        map.put(2, (Object)"minecraft:feather_falling");
        map.put(3, (Object)"minecraft:blast_protection");
        map.put(4, (Object)"minecraft:projectile_protection");
        map.put(5, (Object)"minecraft:respiration");
        map.put(6, (Object)"minecraft:aqua_affinity");
        map.put(7, (Object)"minecraft:thorns");
        map.put(8, (Object)"minecraft:depth_strider");
        map.put(9, (Object)"minecraft:frost_walker");
        map.put(10, (Object)"minecraft:binding_curse");
        map.put(16, (Object)"minecraft:sharpness");
        map.put(17, (Object)"minecraft:smite");
        map.put(18, (Object)"minecraft:bane_of_arthropods");
        map.put(19, (Object)"minecraft:knockback");
        map.put(20, (Object)"minecraft:fire_aspect");
        map.put(21, (Object)"minecraft:looting");
        map.put(22, (Object)"minecraft:sweeping");
        map.put(32, (Object)"minecraft:efficiency");
        map.put(33, (Object)"minecraft:silk_touch");
        map.put(34, (Object)"minecraft:unbreaking");
        map.put(35, (Object)"minecraft:fortune");
        map.put(48, (Object)"minecraft:power");
        map.put(49, (Object)"minecraft:punch");
        map.put(50, (Object)"minecraft:flame");
        map.put(51, (Object)"minecraft:infinity");
        map.put(61, (Object)"minecraft:luck_of_the_sea");
        map.put(62, (Object)"minecraft:lure");
        map.put(65, (Object)"minecraft:loyalty");
        map.put(66, (Object)"minecraft:impaling");
        map.put(67, (Object)"minecraft:riptide");
        map.put(68, (Object)"minecraft:channeling");
        map.put(70, (Object)"minecraft:mending");
        map.put(71, (Object)"minecraft:vanishing_curse");
    });

    public DataConverterItemStackEnchantment(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.x);
        OpticFinder opticFinder = type.findField("tag");
        return this.fixTypeEverywhereTyped("ItemStackEnchantmentFix", type, typed -> typed.updateTyped(opticFinder, typed1 -> typed1.update(DSL.remainderFinder(), this::a)));
    }

    private Dynamic<?> a(Dynamic<?> tag) {
        Optional optional = tag.get("ench").asStreamOpt().map(stream -> stream.map(dynamic -> dynamic.set("id", dynamic.createString((String)a.getOrDefault(dynamic.get("id").asInt(0), (Object)"null"))))).map(arg_0 -> tag.createList(arg_0)).result();
        if (optional.isPresent()) {
            tag = tag.remove("ench").set("Enchantments", (Dynamic)((Object)optional.get()));
        }
        return tag.update("StoredEnchantments", dynamic -> (Dynamic)((Object)((Object)DataFixUtils.orElse((Optional)dynamic.asStreamOpt().map(stream -> stream.map(dynamic1 -> dynamic1.set("id", dynamic1.createString((String)a.getOrDefault(dynamic1.get("id").asInt(0), (Object)"null"))))).map(arg_0 -> ((Dynamic)((Object)dynamic)).createList(arg_0)).result(), (Object)dynamic))));
    }
}

