/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterRiding
extends DataFix {
    public DataConverterRiding(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    public TypeRewriteRule makeRule() {
        Schema inputSchema = this.getInputSchema();
        Schema outputSchema = this.getOutputSchema();
        Type typeRaw = inputSchema.getTypeRaw(DataConverterTypes.G);
        Type typeRaw1 = outputSchema.getTypeRaw(DataConverterTypes.G);
        Type typeRaw2 = inputSchema.getTypeRaw(DataConverterTypes.H);
        return this.a(inputSchema, outputSchema, typeRaw, typeRaw1, typeRaw2);
    }

    private <OldEntityTree, NewEntityTree, Entity> TypeRewriteRule a(Schema inputSchema, Schema outputSchema, Type<OldEntityTree> oldEntityTreeType, Type<NewEntityTree> newEntityTreeType, Type<Entity> entityType) {
        Type type = DSL.named((String)DataConverterTypes.G.typeName(), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"Riding", oldEntityTreeType)), entityType));
        Type type1 = DSL.named((String)DataConverterTypes.G.typeName(), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"Passengers", (Type)DSL.list(newEntityTreeType))), entityType));
        Type type2 = inputSchema.getType(DataConverterTypes.G);
        Type type3 = outputSchema.getType(DataConverterTypes.G);
        if (!Objects.equals(type2, type)) {
            throw new IllegalStateException("Old entity type is not what was expected.");
        }
        if (!type3.equals((Object)type1, true, true)) {
            throw new IllegalStateException("New entity type is not what was expected.");
        }
        OpticFinder opticFinder = DSL.typeFinder((Type)type);
        OpticFinder opticFinder1 = DSL.typeFinder((Type)type1);
        OpticFinder opticFinder2 = DSL.typeFinder(newEntityTreeType);
        Type type4 = inputSchema.getType(DataConverterTypes.c);
        Type type5 = outputSchema.getType(DataConverterTypes.c);
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhere("EntityRidingToPassengerFix", type, type1, dynamicOps -> pair -> {
            Optional<Object> optional = Optional.empty();
            Pair pair1 = pair;
            while (true) {
                Either either = (Either)DataFixUtils.orElse(optional.map(pair2 -> {
                    Typed typed = (Typed)newEntityTreeType.pointTyped(dynamicOps).orElseThrow(() -> new IllegalStateException("Could not create new entity tree"));
                    Object object = typed.set(opticFinder1, pair2).getOptional(opticFinder2).orElseThrow(() -> new IllegalStateException("Should always have an entity tree here"));
                    return Either.left(ImmutableList.of(object));
                }), Either.right(DSL.unit()));
                optional = Optional.of(Pair.of((Object)DataConverterTypes.G.typeName(), (Object)Pair.of((Object)either, (Object)((Pair)pair1.getSecond()).getSecond())));
                Optional optional1 = ((Either)((Pair)pair1.getSecond()).getFirst()).left();
                if (optional1.isEmpty()) {
                    return (Pair)optional.orElseThrow(() -> new IllegalStateException("Should always have an entity tree here"));
                }
                pair1 = (Pair)new Typed(oldEntityTreeType, dynamicOps, optional1.get()).getOptional(opticFinder).orElseThrow(() -> new IllegalStateException("Should always have an entity here"));
            }
        }), (TypeRewriteRule)this.writeAndRead("player RootVehicle injecter", type4, type5));
    }
}

