/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;

public abstract class DataConverterUUIDBase
extends DataFix {
    protected DSL.TypeReference a;

    public DataConverterUUIDBase(Schema outputSchema, DSL.TypeReference typeReference) {
        super(outputSchema, false);
        this.a = typeReference;
    }

    protected Typed<?> a(Typed<?> typed, String choiceName, Function<Dynamic<?>, Dynamic<?>> updater) {
        Type choiceType = this.getInputSchema().getChoiceType(this.a, choiceName);
        Type choiceType1 = this.getOutputSchema().getChoiceType(this.a, choiceName);
        return typed.updateTyped(DSL.namedChoice((String)choiceName, (Type)choiceType), choiceType1, typed1 -> typed1.update(DSL.remainderFinder(), updater));
    }

    protected static Optional<Dynamic<?>> a(Dynamic<?> dynamic, String oldKey, String newKey) {
        return DataConverterUUIDBase.a(dynamic, oldKey).map(dynamic1 -> dynamic.remove(oldKey).set(newKey, (Dynamic<?>)((Object)dynamic1)));
    }

    protected static Optional<Dynamic<?>> b(Dynamic<?> dynamic, String oldKey, String newKey) {
        return dynamic.get(oldKey).result().flatMap(DataConverterUUIDBase::a).map(dynamic1 -> dynamic.remove(oldKey).set(newKey, (Dynamic<?>)((Object)dynamic1)));
    }

    protected static Optional<Dynamic<?>> c(Dynamic<?> dynamic, String oldKey, String newKey) {
        String string = oldKey + "Most";
        String string1 = oldKey + "Least";
        return DataConverterUUIDBase.d(dynamic, string, string1).map(dynamic1 -> dynamic.remove(string).remove(string1).set(newKey, (Dynamic<?>)((Object)dynamic1)));
    }

    protected static Optional<Dynamic<?>> a(Dynamic<?> dynamic, String uuidKey) {
        return dynamic.get(uuidKey).result().flatMap(dynamic1 -> {
            String string = dynamic1.asString(null);
            if (string != null) {
                try {
                    UUID uuid = UUID.fromString(string);
                    return DataConverterUUIDBase.a(dynamic, uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return Optional.empty();
        });
    }

    protected static Optional<Dynamic<?>> a(Dynamic<?> dynamic) {
        return DataConverterUUIDBase.d(dynamic, "M", "L");
    }

    protected static Optional<Dynamic<?>> d(Dynamic<?> dynamic, String mostKey, String leastKey) {
        long _long = dynamic.get(mostKey).asLong(0L);
        long _long1 = dynamic.get(leastKey).asLong(0L);
        return _long != 0L && _long1 != 0L ? DataConverterUUIDBase.a(dynamic, _long, _long1) : Optional.empty();
    }

    protected static Optional<Dynamic<?>> a(Dynamic<?> dynamic, long most, long least) {
        return Optional.of(dynamic.createIntList(Arrays.stream(new int[]{(int)(most >> 32), (int)most, (int)(least >> 32), (int)least})));
    }
}

