/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import java.util.List;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DropChancesFormatFix
extends DataFix {
    private static final List<String> a = List.of("feet", "legs", "chest", "head");
    private static final List<String> b = List.of("mainhand", "offhand");
    private static final float c = 0.085f;

    public DropChancesFormatFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("DropChancesFormatFix", this.getInputSchema().getType(DataConverterTypes.H), typed -> typed.update(DSL.remainderFinder(), dynamic -> {
            List<Float> list = DropChancesFormatFix.a(dynamic.get("ArmorDropChances"));
            List<Float> list1 = DropChancesFormatFix.a(dynamic.get("HandDropChances"));
            float f2 = dynamic.get("body_armor_drop_chance").asNumber().result().map(Number::floatValue).orElse(Float.valueOf(0.085f)).floatValue();
            dynamic = dynamic.remove("ArmorDropChances").remove("HandDropChances").remove("body_armor_drop_chance");
            Dynamic<?> dynamic1 = dynamic.emptyMap();
            dynamic1 = DropChancesFormatFix.a(dynamic1, list, a);
            dynamic1 = DropChancesFormatFix.a(dynamic1, list1, b);
            if (f2 != 0.085f) {
                dynamic1 = dynamic1.set("body", dynamic.createFloat(f2));
            }
            return !dynamic1.equals((Object)dynamic.emptyMap()) ? dynamic.set("drop_chances", dynamic1) : dynamic;
        }));
    }

    private static Dynamic<?> a(Dynamic<?> tag, List<Float> chances, List<String> names) {
        for (int i2 = 0; i2 < names.size() && i2 < chances.size(); ++i2) {
            String string = names.get(i2);
            float f2 = chances.get(i2).floatValue();
            if (f2 == 0.085f) continue;
            tag = tag.set(string, tag.createFloat(f2));
        }
        return tag;
    }

    private static List<Float> a(OptionalDynamic<?> data) {
        return data.asStream().map(dynamic -> Float.valueOf(dynamic.asFloat(0.085f))).toList();
    }
}

