/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Streams;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.BlockEntitySignDoubleSidedEditableTextFix;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DropInvalidSignDataFix
extends DataFix {
    private final String a;

    public DropInvalidSignDataFix(Schema outputSchema, String entityName) {
        super(outputSchema, false);
        this.a = entityName;
    }

    private <T> Dynamic<T> a(Dynamic<T> data) {
        data = data.update("front_text", DropInvalidSignDataFix::b);
        data = data.update("back_text", DropInvalidSignDataFix::b);
        for (String string : BlockEntitySignDoubleSidedEditableTextFix.a) {
            data = data.remove(string);
        }
        return data;
    }

    private static <T> Dynamic<T> b(Dynamic<T> textDynamic) {
        Optional optional = textDynamic.get("filtered_messages").asStreamOpt().result();
        if (optional.isEmpty()) {
            return textDynamic;
        }
        Dynamic dynamic = LegacyComponentDataFixUtils.a(textDynamic.getOps());
        List<Dynamic> list = textDynamic.get("messages").asStreamOpt().result().orElse(Stream.of(new Dynamic[0])).toList();
        List list1 = Streams.mapWithIndex((Stream)((Stream)optional.get()), (dynamic1, l2) -> {
            Dynamic dynamic2 = l2 < (long)list.size() ? (Dynamic)((Object)((Object)list.get((int)l2))) : dynamic;
            return dynamic1.equals((Object)dynamic) ? dynamic2 : dynamic1;
        }).toList();
        return list1.equals(list) ? textDynamic.remove("filtered_messages") : textDynamic.set("filtered_messages", textDynamic.createList(list1.stream()));
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.w);
        Type choiceType = this.getInputSchema().getChoiceType(DataConverterTypes.w, this.a);
        OpticFinder opticFinder = DSL.namedChoice((String)this.a, (Type)choiceType);
        return this.fixTypeEverywhereTyped("DropInvalidSignDataFix for " + this.a, type, typed -> typed.updateTyped(opticFinder, choiceType, typed1 -> {
            boolean _boolean = ((Dynamic)((Object)((Object)((Object)typed1.get(DSL.remainderFinder()))))).get("_filtered_correct").asBoolean(false);
            return _boolean ? typed1.update(DSL.remainderFinder(), dynamic -> dynamic.remove("_filtered_correct")) : SystemUtils.a(typed1, choiceType, this::a);
        }));
    }
}

