/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class GameRuleRegistryFix
extends DataFix {
    public GameRuleRegistryFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("GameRuleRegistryFix", this.getInputSchema().getType(DataConverterTypes.a), typed -> typed.update(DSL.remainderFinder(), dynamic -> dynamic.renameAndFixField("GameRules", "game_rules", dynamic1 -> {
            boolean flag = Boolean.parseBoolean(dynamic1.get("doFireTick").asString("true"));
            boolean flag1 = Boolean.parseBoolean(dynamic1.get("allowFireTicksAwayFromPlayer").asString("false"));
            int i2 = !flag ? 0 : (!flag1 ? 128 : -1);
            if (i2 != 128) {
                dynamic1 = dynamic1.set("minecraft:fire_spread_radius_around_player", dynamic1.createInt(i2));
            }
            return dynamic1.remove("spawnChunkRadius").remove("entitiesWithPassengersCanUsePortals").remove("doFireTick").remove("allowFireTicksAwayFromPlayer").renameAndFixField("allowEnteringNetherUsingPortals", "minecraft:allow_entering_nether_using_portals", GameRuleRegistryFix::b).renameAndFixField("announceAdvancements", "minecraft:show_advancement_messages", GameRuleRegistryFix::b).renameAndFixField("blockExplosionDropDecay", "minecraft:block_explosion_drop_decay", GameRuleRegistryFix::b).renameAndFixField("commandBlockOutput", "minecraft:command_block_output", GameRuleRegistryFix::b).renameAndFixField("enableCommandBlocks", "minecraft:command_blocks_work", GameRuleRegistryFix::b).renameAndFixField("commandBlocksEnabled", "minecraft:command_blocks_work", GameRuleRegistryFix::b).renameAndFixField("commandModificationBlockLimit", "minecraft:max_block_modifications", dynamic2 -> GameRuleRegistryFix.a(dynamic2, 1)).renameAndFixField("disableElytraMovementCheck", "minecraft:elytra_movement_check", GameRuleRegistryFix::c).renameAndFixField("disablePlayerMovementCheck", "minecraft:player_movement_check", GameRuleRegistryFix::c).renameAndFixField("disableRaids", "minecraft:raids", GameRuleRegistryFix::c).renameAndFixField("doDaylightCycle", "minecraft:advance_time", GameRuleRegistryFix::b).renameAndFixField("doEntityDrops", "minecraft:entity_drops", GameRuleRegistryFix::b).renameAndFixField("doImmediateRespawn", "minecraft:immediate_respawn", GameRuleRegistryFix::b).renameAndFixField("doInsomnia", "minecraft:spawn_phantoms", GameRuleRegistryFix::b).renameAndFixField("doLimitedCrafting", "minecraft:limited_crafting", GameRuleRegistryFix::b).renameAndFixField("doMobLoot", "minecraft:mob_drops", GameRuleRegistryFix::b).renameAndFixField("doMobSpawning", "minecraft:spawn_mobs", GameRuleRegistryFix::b).renameAndFixField("doPatrolSpawning", "minecraft:spawn_patrols", GameRuleRegistryFix::b).renameAndFixField("doTileDrops", "minecraft:block_drops", GameRuleRegistryFix::b).renameAndFixField("doTraderSpawning", "minecraft:spawn_wandering_traders", GameRuleRegistryFix::b).renameAndFixField("doVinesSpread", "minecraft:spread_vines", GameRuleRegistryFix::b).renameAndFixField("doWardenSpawning", "minecraft:spawn_wardens", GameRuleRegistryFix::b).renameAndFixField("doWeatherCycle", "minecraft:advance_weather", GameRuleRegistryFix::b).renameAndFixField("drowningDamage", "minecraft:drowning_damage", GameRuleRegistryFix::b).renameAndFixField("enderPearlsVanishOnDeath", "minecraft:ender_pearls_vanish_on_death", GameRuleRegistryFix::b).renameAndFixField("fallDamage", "minecraft:fall_damage", GameRuleRegistryFix::b).renameAndFixField("fireDamage", "minecraft:fire_damage", GameRuleRegistryFix::b).renameAndFixField("forgiveDeadPlayers", "minecraft:forgive_dead_players", GameRuleRegistryFix::b).renameAndFixField("freezeDamage", "minecraft:freeze_damage", GameRuleRegistryFix::b).renameAndFixField("globalSoundEvents", "minecraft:global_sound_events", GameRuleRegistryFix::b).renameAndFixField("keepInventory", "minecraft:keep_inventory", GameRuleRegistryFix::b).renameAndFixField("lavaSourceConversion", "minecraft:lava_source_conversion", GameRuleRegistryFix::b).renameAndFixField("locatorBar", "minecraft:locator_bar", GameRuleRegistryFix::b).renameAndFixField("logAdminCommands", "minecraft:log_admin_commands", GameRuleRegistryFix::b).renameAndFixField("maxCommandChainLength", "minecraft:max_command_sequence_length", dynamic2 -> GameRuleRegistryFix.a(dynamic2, 0)).renameAndFixField("maxCommandForkCount", "minecraft:max_command_forks", dynamic2 -> GameRuleRegistryFix.a(dynamic2, 0)).renameAndFixField("maxEntityCramming", "minecraft:max_entity_cramming", dynamic2 -> GameRuleRegistryFix.a(dynamic2, 0)).renameAndFixField("minecartMaxSpeed", "minecraft:max_minecart_speed", GameRuleRegistryFix::a).renameAndFixField("mobExplosionDropDecay", "minecraft:mob_explosion_drop_decay", GameRuleRegistryFix::b).renameAndFixField("mobGriefing", "minecraft:mob_griefing", GameRuleRegistryFix::b).renameAndFixField("naturalRegeneration", "minecraft:natural_health_regeneration", GameRuleRegistryFix::b).renameAndFixField("playersNetherPortalCreativeDelay", "minecraft:players_nether_portal_creative_delay", dynamic2 -> GameRuleRegistryFix.a(dynamic2, 0)).renameAndFixField("playersNetherPortalDefaultDelay", "minecraft:players_nether_portal_default_delay", dynamic2 -> GameRuleRegistryFix.a(dynamic2, 0)).renameAndFixField("playersSleepingPercentage", "minecraft:players_sleeping_percentage", dynamic2 -> GameRuleRegistryFix.a(dynamic2, 0)).renameAndFixField("projectilesCanBreakBlocks", "minecraft:projectiles_can_break_blocks", GameRuleRegistryFix::b).renameAndFixField("pvp", "minecraft:pvp", GameRuleRegistryFix::b).renameAndFixField("randomTickSpeed", "minecraft:random_tick_speed", dynamic2 -> GameRuleRegistryFix.a(dynamic2, 0)).renameAndFixField("reducedDebugInfo", "minecraft:reduced_debug_info", GameRuleRegistryFix::b).renameAndFixField("sendCommandFeedback", "minecraft:send_command_feedback", GameRuleRegistryFix::b).renameAndFixField("showDeathMessages", "minecraft:show_death_messages", GameRuleRegistryFix::b).renameAndFixField("snowAccumulationHeight", "minecraft:max_snow_accumulation_height", dynamic2 -> GameRuleRegistryFix.a(dynamic2, 0, 8)).renameAndFixField("spawnMonsters", "minecraft:spawn_monsters", GameRuleRegistryFix::b).renameAndFixField("spawnRadius", "minecraft:respawn_radius", GameRuleRegistryFix::a).renameAndFixField("spawnerBlocksEnabled", "minecraft:spawner_blocks_work", GameRuleRegistryFix::b).renameAndFixField("spectatorsGenerateChunks", "minecraft:spectators_generate_chunks", GameRuleRegistryFix::b).renameAndFixField("tntExplodes", "minecraft:tnt_explodes", GameRuleRegistryFix::b).renameAndFixField("tntExplosionDropDecay", "minecraft:tnt_explosion_drop_decay", GameRuleRegistryFix::b).renameAndFixField("universalAnger", "minecraft:universal_anger", GameRuleRegistryFix::b).renameAndFixField("waterSourceConversion", "minecraft:water_source_conversion", GameRuleRegistryFix::b);
        })));
    }

    private static Dynamic<?> a(Dynamic<?> dynamic) {
        return GameRuleRegistryFix.a(dynamic, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private static Dynamic<?> a(Dynamic<?> dynamic, int min) {
        return GameRuleRegistryFix.a(dynamic, min, Integer.MAX_VALUE);
    }

    private static Dynamic<?> a(Dynamic<?> dynamic, int min, int max) {
        String string = dynamic.asString("");
        try {
            int i2 = Integer.parseInt(string);
            return dynamic.createInt(MathHelper.a(i2, min, max));
        }
        catch (NumberFormatException var5) {
            return dynamic;
        }
    }

    private static Dynamic<?> b(Dynamic<?> dynamic) {
        return dynamic.createBoolean(Boolean.parseBoolean(dynamic.asString("")));
    }

    private static Dynamic<?> c(Dynamic<?> dynamic) {
        return dynamic.createBoolean(!Boolean.parseBoolean(dynamic.asString("")));
    }
}

