/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class LegacyDimensionIdFix
extends DataFix {
    public LegacyDimensionIdFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    public TypeRewriteRule makeRule() {
        TypeRewriteRule typeRewriteRule = this.fixTypeEverywhereTyped("PlayerLegacyDimensionFix", this.getInputSchema().getType(DataConverterTypes.c), typed -> typed.update(DSL.remainderFinder(), this::b));
        Type type = this.getInputSchema().getType(DataConverterTypes.k);
        OpticFinder opticFinder = type.findField("data");
        TypeRewriteRule typeRewriteRule1 = this.fixTypeEverywhereTyped("MapLegacyDimensionFix", type, typed -> typed.updateTyped(opticFinder, typed1 -> typed1.update(DSL.remainderFinder(), this::a)));
        return TypeRewriteRule.seq((TypeRewriteRule)typeRewriteRule, (TypeRewriteRule)typeRewriteRule1);
    }

    private <T> Dynamic<T> a(Dynamic<T> data) {
        return data.update("dimension", this::c);
    }

    private <T> Dynamic<T> b(Dynamic<T> data) {
        return data.update("Dimension", this::c);
    }

    private <T> Dynamic<T> c(Dynamic<T> data) {
        return (Dynamic)((Object)DataFixUtils.orElse(data.asNumber().result().map(number -> switch (number.intValue()) {
            case -1 -> data.createString("minecraft:the_nether");
            case 1 -> data.createString("minecraft:the_end");
            default -> data.createString("minecraft:overworld");
        }), data));
    }
}

