/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class MobEffectIdFix
extends DataFix {
    private static final Int2ObjectMap<String> a = (Int2ObjectMap)SystemUtils.a(new Int2ObjectOpenHashMap(), (? super T map) -> {
        map.put(1, (Object)"minecraft:speed");
        map.put(2, (Object)"minecraft:slowness");
        map.put(3, (Object)"minecraft:haste");
        map.put(4, (Object)"minecraft:mining_fatigue");
        map.put(5, (Object)"minecraft:strength");
        map.put(6, (Object)"minecraft:instant_health");
        map.put(7, (Object)"minecraft:instant_damage");
        map.put(8, (Object)"minecraft:jump_boost");
        map.put(9, (Object)"minecraft:nausea");
        map.put(10, (Object)"minecraft:regeneration");
        map.put(11, (Object)"minecraft:resistance");
        map.put(12, (Object)"minecraft:fire_resistance");
        map.put(13, (Object)"minecraft:water_breathing");
        map.put(14, (Object)"minecraft:invisibility");
        map.put(15, (Object)"minecraft:blindness");
        map.put(16, (Object)"minecraft:night_vision");
        map.put(17, (Object)"minecraft:hunger");
        map.put(18, (Object)"minecraft:weakness");
        map.put(19, (Object)"minecraft:poison");
        map.put(20, (Object)"minecraft:wither");
        map.put(21, (Object)"minecraft:health_boost");
        map.put(22, (Object)"minecraft:absorption");
        map.put(23, (Object)"minecraft:saturation");
        map.put(24, (Object)"minecraft:glowing");
        map.put(25, (Object)"minecraft:levitation");
        map.put(26, (Object)"minecraft:luck");
        map.put(27, (Object)"minecraft:unluck");
        map.put(28, (Object)"minecraft:slow_falling");
        map.put(29, (Object)"minecraft:conduit_power");
        map.put(30, (Object)"minecraft:dolphins_grace");
        map.put(31, (Object)"minecraft:bad_omen");
        map.put(32, (Object)"minecraft:hero_of_the_village");
        map.put(33, (Object)"minecraft:darkness");
    });
    private static final Set<String> b = Set.of("minecraft:potion", "minecraft:splash_potion", "minecraft:lingering_potion", "minecraft:tipped_arrow");

    public MobEffectIdFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    private static <T> Optional<Dynamic<T>> a(Dynamic<T> dynamic, String key) {
        return dynamic.get(key).asNumber().result().map(number -> (String)a.get(number.intValue())).map(arg_0 -> dynamic.createString(arg_0));
    }

    private static <T> Dynamic<T> a(Dynamic<T> oldDynamic, String oldName, Dynamic<T> newDynamic, String newName) {
        Optional<Dynamic<T>> andConvertMobEffectId = MobEffectIdFix.a(oldDynamic, oldName);
        return newDynamic.replaceField(oldName, newName, andConvertMobEffectId);
    }

    private static <T> Dynamic<T> a(Dynamic<T> dynamic, String oldName, String newName) {
        return MobEffectIdFix.a(dynamic, oldName, dynamic, newName);
    }

    private static <T> Dynamic<T> a(Dynamic<T> dynamic) {
        dynamic = MobEffectIdFix.a(dynamic, "Id", "id");
        dynamic = dynamic.renameField("Ambient", "ambient");
        dynamic = dynamic.renameField("Amplifier", "amplifier");
        dynamic = dynamic.renameField("Duration", "duration");
        dynamic = dynamic.renameField("ShowParticles", "show_particles");
        dynamic = dynamic.renameField("ShowIcon", "show_icon");
        Optional<Dynamic> optional = dynamic.get("HiddenEffect").result().map(MobEffectIdFix::a);
        return dynamic.replaceField("HiddenEffect", "hidden_effect", optional);
    }

    private static <T> Dynamic<T> b(Dynamic<T> tag, String oldName, String newName) {
        Optional<Dynamic> optional = tag.get(oldName).asStreamOpt().result().map(stream -> tag.createList(stream.map(MobEffectIdFix::a)));
        return tag.replaceField(oldName, newName, optional);
    }

    private static <T> Dynamic<T> a(Dynamic<T> oldDynamic, Dynamic<T> newDynamic) {
        newDynamic = MobEffectIdFix.a(oldDynamic, "EffectId", newDynamic, "id");
        Optional optional = oldDynamic.get("EffectDuration").result();
        return newDynamic.replaceField("EffectDuration", "duration", optional);
    }

    private static <T> Dynamic<T> b(Dynamic<T> suspiciousStewEntry) {
        return MobEffectIdFix.a(suspiciousStewEntry, suspiciousStewEntry);
    }

    private Typed<?> a(Typed<?> typed, DSL.TypeReference reference, String id, Function<Dynamic<?>, Dynamic<?>> fixer) {
        Type choiceType = this.getInputSchema().getChoiceType(reference, id);
        Type choiceType1 = this.getOutputSchema().getChoiceType(reference, id);
        return typed.updateTyped(DSL.namedChoice((String)id, (Type)choiceType), choiceType1, typed1 -> typed1.update(DSL.remainderFinder(), fixer));
    }

    private TypeRewriteRule a() {
        Type type = this.getInputSchema().getType(DataConverterTypes.w);
        return this.fixTypeEverywhereTyped("BlockEntityMobEffectIdFix", type, typed -> this.a((Typed<?>)typed, DataConverterTypes.w, "minecraft:beacon", dynamic -> {
            dynamic = MobEffectIdFix.a(dynamic, "Primary", "primary_effect");
            return MobEffectIdFix.a(dynamic, "Secondary", "secondary_effect");
        }));
    }

    private static <T> Dynamic<T> c(Dynamic<T> mooshroomTag) {
        Dynamic dynamic = mooshroomTag.emptyMap();
        Dynamic<T> dynamic1 = MobEffectIdFix.a(mooshroomTag, dynamic);
        if (!dynamic1.equals((Object)dynamic)) {
            mooshroomTag = mooshroomTag.set("stew_effects", mooshroomTag.createList(Stream.of(dynamic1)));
        }
        return mooshroomTag.remove("EffectId").remove("EffectDuration");
    }

    private static <T> Dynamic<T> d(Dynamic<T> arrowTag) {
        return MobEffectIdFix.b(arrowTag, "CustomPotionEffects", "custom_potion_effects");
    }

    private static <T> Dynamic<T> e(Dynamic<T> areaEffectCloudTag) {
        return MobEffectIdFix.b(areaEffectCloudTag, "Effects", "effects");
    }

    private static Dynamic<?> f(Dynamic<?> livingEntityTag) {
        return MobEffectIdFix.b(livingEntityTag, "ActiveEffects", "active_effects");
    }

    private TypeRewriteRule b() {
        Type type = this.getInputSchema().getType(DataConverterTypes.H);
        return this.fixTypeEverywhereTyped("EntityMobEffectIdFix", type, typed -> {
            typed = this.a((Typed<?>)typed, DataConverterTypes.H, "minecraft:mooshroom", MobEffectIdFix::c);
            typed = this.a((Typed<?>)typed, DataConverterTypes.H, "minecraft:arrow", MobEffectIdFix::d);
            typed = this.a((Typed<?>)typed, DataConverterTypes.H, "minecraft:area_effect_cloud", MobEffectIdFix::e);
            return typed.update(DSL.remainderFinder(), MobEffectIdFix::f);
        });
    }

    private TypeRewriteRule c() {
        Type type = this.getInputSchema().getType(DataConverterTypes.c);
        return this.fixTypeEverywhereTyped("PlayerMobEffectIdFix", type, typed -> typed.update(DSL.remainderFinder(), MobEffectIdFix::f));
    }

    private static <T> Dynamic<T> g(Dynamic<T> suspiciousStewTag) {
        Optional<Dynamic> optional = suspiciousStewTag.get("Effects").asStreamOpt().result().map(stream -> suspiciousStewTag.createList(stream.map(MobEffectIdFix::b)));
        return suspiciousStewTag.replaceField("Effects", "effects", optional);
    }

    private TypeRewriteRule d() {
        OpticFinder opticFinder = DSL.fieldFinder((String)"id", (Type)DSL.named((String)DataConverterTypes.J.typeName(), DataConverterSchemaNamed.a()));
        Type type = this.getInputSchema().getType(DataConverterTypes.x);
        OpticFinder opticFinder1 = type.findField("tag");
        return this.fixTypeEverywhereTyped("ItemStackMobEffectIdFix", type, typed -> {
            Optional optional = typed.getOptional(opticFinder);
            if (optional.isPresent()) {
                String string = (String)((Pair)optional.get()).getSecond();
                if (string.equals("minecraft:suspicious_stew")) {
                    return typed.updateTyped(opticFinder1, typed1 -> typed1.update(DSL.remainderFinder(), MobEffectIdFix::g));
                }
                if (b.contains(string)) {
                    return typed.updateTyped(opticFinder1, typed1 -> typed1.update(DSL.remainderFinder(), dynamic -> MobEffectIdFix.b(dynamic, "CustomPotionEffects", "custom_potion_effects")));
                }
            }
            return typed;
        });
    }

    protected TypeRewriteRule makeRule() {
        return TypeRewriteRule.seq((TypeRewriteRule)this.a(), (TypeRewriteRule[])new TypeRewriteRule[]{this.b(), this.c(), this.d()});
    }
}

