/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class ProjectileStoredWeaponFix
extends DataFix {
    public ProjectileStoredWeaponFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.H);
        Type type1 = this.getOutputSchema().getType(DataConverterTypes.H);
        return this.fixTypeEverywhereTyped("Fix Arrow stored weapon", type, type1, ExtraDataFixUtils.a(this.a("minecraft:arrow"), this.a("minecraft:spectral_arrow")));
    }

    private Function<Typed<?>, Typed<?>> a(String entityId) {
        Type choiceType = this.getInputSchema().getChoiceType(DataConverterTypes.H, entityId);
        Type choiceType1 = this.getOutputSchema().getChoiceType(DataConverterTypes.H, entityId);
        return ProjectileStoredWeaponFix.a(entityId, choiceType, choiceType1);
    }

    private static <T> Function<Typed<?>, Typed<?>> a(String entityId, Type<?> inputType, Type<T> outputType) {
        OpticFinder opticFinder = DSL.namedChoice((String)entityId, inputType);
        return typed -> typed.updateTyped(opticFinder, outputType, typed1 -> SystemUtils.a(typed1, outputType, UnaryOperator.identity()));
    }
}

