/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.Set;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class SaddleEquipmentSlotFix
extends DataFix {
    private static final Set<String> a = Set.of("minecraft:horse", "minecraft:skeleton_horse", "minecraft:zombie_horse", "minecraft:donkey", "minecraft:mule", "minecraft:camel", "minecraft:llama", "minecraft:trader_llama");
    private static final Set<String> b = Set.of("minecraft:pig", "minecraft:strider");
    private static final String c = "Saddle";
    private static final String d = "saddle";

    public SaddleEquipmentSlotFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        TaggedChoice.TaggedChoiceType taggedChoiceType = this.getInputSchema().findChoiceType(DataConverterTypes.H);
        OpticFinder opticFinder = DSL.typeFinder((Type)taggedChoiceType);
        Type type = this.getInputSchema().getType(DataConverterTypes.H);
        Type type1 = this.getOutputSchema().getType(DataConverterTypes.H);
        Type<?> type2 = ExtraDataFixUtils.a(type, type, type1);
        return this.fixTypeEverywhereTyped("SaddleEquipmentSlotFix", type, type1, typed -> {
            String string = typed.getOptional(opticFinder).map(Pair::getFirst).map(DataConverterSchemaNamed::a).orElse("");
            Typed typed1 = ExtraDataFixUtils.a(type2, typed);
            if (a.contains(string)) {
                return SystemUtils.a(typed1, type1, SaddleEquipmentSlotFix::a);
            }
            return b.contains(string) ? SystemUtils.a(typed1, type1, SaddleEquipmentSlotFix::b) : ExtraDataFixUtils.a(type1, typed);
        });
    }

    private static Dynamic<?> a(Dynamic<?> data) {
        return data.get("SaddleItem").result().isEmpty() ? data : SaddleEquipmentSlotFix.c(data.renameField("SaddleItem", d));
    }

    private static Dynamic<?> b(Dynamic<?> data) {
        boolean _boolean = data.get(c).asBoolean(false);
        data = data.remove(c);
        if (!_boolean) {
            return data;
        }
        Dynamic dynamic = data.emptyMap().set("id", data.createString("minecraft:saddle")).set("count", data.createInt(1));
        return SaddleEquipmentSlotFix.c(data.set(d, dynamic));
    }

    private static Dynamic<?> c(Dynamic<?> data) {
        Dynamic dynamic = data.get("drop_chances").orElseEmptyMap().set(d, data.createFloat(2.0f));
        return data.set("drop_chances", dynamic);
    }
}

