/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import java.util.Map;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class StatsRenameFix
extends DataFix {
    private final String a;
    private final Map<String, String> b;

    public StatsRenameFix(Schema outputSchema, String name, Map<String, String> renames) {
        super(outputSchema, false);
        this.a = name;
        this.b = renames;
    }

    protected TypeRewriteRule makeRule() {
        return TypeRewriteRule.seq((TypeRewriteRule)this.b(), (TypeRewriteRule)this.a());
    }

    private TypeRewriteRule a() {
        Type type = this.getOutputSchema().getType(DataConverterTypes.N);
        Type type1 = this.getInputSchema().getType(DataConverterTypes.N);
        OpticFinder opticFinder = type1.findField("CriteriaType");
        TaggedChoice.TaggedChoiceType taggedChoiceType = (TaggedChoice.TaggedChoiceType)opticFinder.type().findChoiceType("type", -1).orElseThrow(() -> new IllegalStateException("Can't find choice type for criteria"));
        Type type2 = (Type)taggedChoiceType.types().get("minecraft:custom");
        if (type2 == null) {
            throw new IllegalStateException("Failed to find custom criterion type variant");
        }
        OpticFinder opticFinder1 = DSL.namedChoice((String)"minecraft:custom", (Type)type2);
        OpticFinder opticFinder2 = DSL.fieldFinder((String)"id", DataConverterSchemaNamed.a());
        return this.fixTypeEverywhereTyped(this.a, type1, type, typed -> typed.updateTyped(opticFinder, typed1 -> typed1.updateTyped(opticFinder1, typed2 -> typed2.update(opticFinder2, string -> this.b.getOrDefault(string, (String)string)))));
    }

    private TypeRewriteRule b() {
        Type type = this.getOutputSchema().getType(DataConverterTypes.h);
        Type type1 = this.getInputSchema().getType(DataConverterTypes.h);
        OpticFinder opticFinder = type1.findField("stats");
        OpticFinder opticFinder1 = opticFinder.type().findField("minecraft:custom");
        OpticFinder opticFinder2 = DataConverterSchemaNamed.a().finder();
        return this.fixTypeEverywhereTyped(this.a, type1, type, typed -> typed.updateTyped(opticFinder, typed1 -> typed1.updateTyped(opticFinder1, typed2 -> typed2.update(opticFinder2, string -> this.b.getOrDefault(string, (String)string)))));
    }
}

