/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.LongStream;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class StructuresBecomeConfiguredFix
extends DataFix {
    private static final Logger a = LogUtils.getLogger();
    private static final Map<String, a> b = ImmutableMap.builder().put((Object)"mineshaft", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a(Map.of(List.of("minecraft:badlands", "minecraft:eroded_badlands", "minecraft:wooded_badlands"), "minecraft:mineshaft_mesa"), "minecraft:mineshaft")).put((Object)"shipwreck", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a(Map.of(List.of("minecraft:beach", "minecraft:snowy_beach"), "minecraft:shipwreck_beached"), "minecraft:shipwreck")).put((Object)"ocean_ruin", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a(Map.of(List.of("minecraft:warm_ocean", "minecraft:lukewarm_ocean", "minecraft:deep_lukewarm_ocean"), "minecraft:ocean_ruin_warm"), "minecraft:ocean_ruin_cold")).put((Object)"village", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a(Map.of(List.of("minecraft:desert"), "minecraft:village_desert", List.of("minecraft:savanna"), "minecraft:village_savanna", List.of("minecraft:snowy_plains"), "minecraft:village_snowy", List.of("minecraft:taiga"), "minecraft:village_taiga"), "minecraft:village_plains")).put((Object)"ruined_portal", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a(Map.of(List.of("minecraft:desert"), "minecraft:ruined_portal_desert", List.of("minecraft:badlands", "minecraft:eroded_badlands", "minecraft:wooded_badlands", "minecraft:windswept_hills", "minecraft:windswept_forest", "minecraft:windswept_gravelly_hills", "minecraft:savanna_plateau", "minecraft:windswept_savanna", "minecraft:stony_shore", "minecraft:meadow", "minecraft:frozen_peaks", "minecraft:jagged_peaks", "minecraft:stony_peaks", "minecraft:snowy_slopes"), "minecraft:ruined_portal_mountain", List.of("minecraft:bamboo_jungle", "minecraft:jungle", "minecraft:sparse_jungle"), "minecraft:ruined_portal_jungle", List.of("minecraft:deep_frozen_ocean", "minecraft:deep_cold_ocean", "minecraft:deep_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:frozen_ocean", "minecraft:ocean", "minecraft:cold_ocean", "minecraft:lukewarm_ocean", "minecraft:warm_ocean"), "minecraft:ruined_portal_ocean"), "minecraft:ruined_portal")).put((Object)"pillager_outpost", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:pillager_outpost")).put((Object)"mansion", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:mansion")).put((Object)"jungle_pyramid", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:jungle_pyramid")).put((Object)"desert_pyramid", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:desert_pyramid")).put((Object)"igloo", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:igloo")).put((Object)"swamp_hut", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:swamp_hut")).put((Object)"stronghold", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:stronghold")).put((Object)"monument", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:monument")).put((Object)"fortress", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:fortress")).put((Object)"endcity", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:end_city")).put((Object)"buried_treasure", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:buried_treasure")).put((Object)"nether_fossil", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:nether_fossil")).put((Object)"bastion_remnant", (Object)net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a("minecraft:bastion_remnant")).build();

    public StructuresBecomeConfiguredFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.d);
        Type type1 = this.getInputSchema().getType(DataConverterTypes.d);
        return this.writeFixAndRead("StucturesToConfiguredStructures", type, type1, this::a);
    }

    private Dynamic<?> a(Dynamic<?> data) {
        return data.update("structures", structures -> structures.update("starts", starts -> this.a((Dynamic<?>)((Object)((Object)starts)), data)).update("References", references -> this.b((Dynamic<?>)((Object)((Object)references)), data)));
    }

    private Dynamic<?> a(Dynamic<?> starts, Dynamic<?> data) {
        Map<Dynamic, Dynamic> map = starts.getMapValues().result().orElse(Map.of());
        HashMap map1 = Maps.newHashMap();
        map.forEach((dynamic, dynamic1) -> {
            if (!dynamic1.get("id").asString("INVALID").equals("INVALID")) {
                Dynamic<?> dynamic2 = this.c((Dynamic<?>)((Object)dynamic), data);
                if (dynamic2 == null) {
                    a.warn("Encountered unknown structure in datafixer: {}", (Object)dynamic.asString("<missing key>"));
                } else {
                    map1.computeIfAbsent(dynamic2, dynamic3 -> dynamic1.set("id", dynamic2));
                }
            }
        });
        return data.createMap(map1);
    }

    private Dynamic<?> b(Dynamic<?> references, Dynamic<?> data) {
        Map<Dynamic, Dynamic> map = references.getMapValues().result().orElse(Map.of());
        HashMap map1 = Maps.newHashMap();
        map.forEach((dynamic, dynamic1) -> {
            if (dynamic1.asLongStream().count() != 0L) {
                Dynamic<?> dynamic2 = this.c((Dynamic<?>)((Object)dynamic), data);
                if (dynamic2 == null) {
                    a.warn("Encountered unknown structure in datafixer: {}", (Object)dynamic.asString("<missing key>"));
                } else {
                    map1.compute(dynamic2, (dynamic3, dynamic4) -> dynamic4 == null ? dynamic1 : dynamic1.createLongList(LongStream.concat(dynamic4.asLongStream(), dynamic1.asLongStream())));
                }
            }
        });
        return data.createMap(map1);
    }

    private @Nullable Dynamic<?> c(Dynamic<?> structureName, Dynamic<?> data) {
        Optional<String> optional;
        String string = structureName.asString("UNKNOWN").toLowerCase(Locale.ROOT);
        a conversion = b.get(string);
        if (conversion == null) {
            return null;
        }
        String string1 = conversion.b;
        if (!conversion.a().isEmpty() && (optional = this.a(data, conversion)).isPresent()) {
            string1 = optional.get();
        }
        return data.createString(string1);
    }

    private Optional<String> a(Dynamic<?> data, a conversion) {
        Object2IntArrayMap map = new Object2IntArrayMap();
        data.get("sections").asList(Function.identity()).forEach(dynamic -> dynamic.get("biomes").get("palette").asList(Function.identity()).forEach(dynamic1 -> {
            String string = conversion.a().get(dynamic1.asString(""));
            if (string != null) {
                map.mergeInt((Object)string, 1, Integer::sum);
            }
        }));
        return map.object2IntEntrySet().stream().max(Comparator.comparingInt(Object2IntMap.Entry::getIntValue)).map(Map.Entry::getKey);
    }

    record a(Map<String, String> a, String b) {
        public static a a(String fallback) {
            return new a(Map.of(), fallback);
        }

        public static a a(Map<List<String>, String> biomeMapping, String fallback) {
            return new a(net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix$a.a(biomeMapping), fallback);
        }

        private static Map<String, String> a(Map<List<String>, String> mapping) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<List<String>, String> entry : mapping.entrySet()) {
                entry.getKey().forEach(string -> builder.put(string, (Object)((String)entry.getValue())));
            }
            return builder.build();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "biomeMapping;fallback", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "biomeMapping;fallback", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "biomeMapping;fallback", "a", "b"}, this, o2);
        }
    }
}

