/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.debug;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.DebugEntityNameGenerator;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.UtilColor;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.memory.ExpirableMemory;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.villager.EntityVillager;
import net.minecraft.world.entity.schedule.Activity;
import org.jspecify.annotations.Nullable;

public final class DebugBrainDump
extends Record {
    private final String b;
    private final String c;
    private final int d;
    private final float e;
    private final float f;
    private final String g;
    private final boolean h;
    private final int i;
    private final List<String> j;
    private final List<String> k;
    private final List<String> l;
    private final List<String> m;
    private final Set<BlockPosition> n;
    private final Set<BlockPosition> o;
    public static final StreamCodec<PacketDataSerializer, DebugBrainDump> a = StreamCodec.a((B buffer, V value) -> value.a((PacketDataSerializer)((Object)buffer)), DebugBrainDump::new);

    public DebugBrainDump(PacketDataSerializer buffer) {
        this(buffer.p(), buffer.p(), buffer.readInt(), buffer.readFloat(), buffer.readFloat(), buffer.p(), buffer.readBoolean(), buffer.readInt(), buffer.a(PacketDataSerializer::p), buffer.a(PacketDataSerializer::p), buffer.a(PacketDataSerializer::p), buffer.a(PacketDataSerializer::p), (Set)((Object)buffer.a(HashSet::new, BlockPosition.b)), (Set)((Object)buffer.a(HashSet::new, BlockPosition.b)));
    }

    public DebugBrainDump(String name, String profession, int xp, float health, float maxHealth, String inventory, boolean wantsGolem, int angerLevel, List<String> activities, List<String> behaviors, List<String> memories, List<String> gossips, Set<BlockPosition> pois, Set<BlockPosition> potentialPois) {
        this.b = name;
        this.c = profession;
        this.d = xp;
        this.e = health;
        this.f = maxHealth;
        this.g = inventory;
        this.h = wantsGolem;
        this.i = angerLevel;
        this.j = activities;
        this.k = behaviors;
        this.l = memories;
        this.m = gossips;
        this.n = pois;
        this.o = potentialPois;
    }

    public void a(PacketDataSerializer buffer) {
        buffer.a(this.b);
        buffer.a(this.c);
        buffer.q(this.d);
        buffer.a(this.e);
        buffer.a(this.f);
        buffer.a(this.g);
        buffer.a(this.h);
        buffer.q(this.i);
        buffer.a(this.j, PacketDataSerializer::a);
        buffer.a(this.k, PacketDataSerializer::a);
        buffer.a(this.l, PacketDataSerializer::a);
        buffer.a(this.m, PacketDataSerializer::a);
        buffer.a(this.n, BlockPosition.b);
        buffer.a(this.o, BlockPosition.b);
    }

    public static DebugBrainDump a(WorldServer level, EntityLiving entity) {
        List<String> list;
        int n2;
        EntityVillager villager1;
        boolean flag;
        InventoryCarrier inventoryCarrier;
        InventorySubcontainer inventory;
        int villagerXp;
        String registeredName;
        String entityName = DebugEntityNameGenerator.a(entity);
        if (entity instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)entity;
            registeredName = villager.gZ().b().g();
            villagerXp = villager.d();
        } else {
            registeredName = "";
            villagerXp = 0;
        }
        float health = entity.eZ();
        float maxHealth = entity.fq();
        BehaviorController<?> brain = entity.ev();
        long gameTime = entity.ao().au();
        String string = entity instanceof InventoryCarrier ? ((inventory = (inventoryCarrier = (InventoryCarrier)((Object)entity)).gP()).c() ? "" : ((Object)inventory).toString()) : "";
        boolean bl = flag = entity instanceof EntityVillager && (villager1 = (EntityVillager)entity).a(gameTime);
        if (entity instanceof Warden) {
            Warden warden = (Warden)entity;
            n2 = warden.p();
        } else {
            n2 = -1;
        }
        int i2 = n2;
        List<String> list2 = brain.c().stream().map(Activity::a).toList();
        List<String> list1 = brain.d().stream().map(BehaviorControl::b).toList();
        List<String> list22 = DebugBrainDump.a(level, entity, gameTime).map(string1 -> UtilColor.a(string1, 255, true)).toList();
        Set<BlockPosition> knownBlockPositions = DebugBrainDump.a(brain, MemoryModuleType.c, MemoryModuleType.b, MemoryModuleType.e);
        Set<BlockPosition> knownBlockPositions1 = DebugBrainDump.a(brain, MemoryModuleType.d);
        if (entity instanceof EntityVillager) {
            EntityVillager villager2 = (EntityVillager)entity;
            list = DebugBrainDump.a(villager2);
        } else {
            list = List.of();
        }
        List<String> list3 = list;
        return new DebugBrainDump(entityName, registeredName, villagerXp, health, maxHealth, string, flag, i2, list2, list1, list22, list3, knownBlockPositions, knownBlockPositions1);
    }

    @SafeVarargs
    private static Set<BlockPosition> a(BehaviorController<?> brain, MemoryModuleType<GlobalPos> ... memoryTypes) {
        return Stream.of(memoryTypes).filter(brain::a).map(brain::c).flatMap(Optional::stream).map(GlobalPos::b).collect(Collectors.toSet());
    }

    private static List<String> a(EntityVillager villager) {
        ArrayList<String> list = new ArrayList<String>();
        villager.he().a().forEach((uuid, map) -> {
            String entityName = DebugEntityNameGenerator.a(uuid);
            map.forEach((gossipType, i2) -> list.add(entityName + ": " + String.valueOf(gossipType) + ": " + i2));
        });
        return list;
    }

    private static Stream<String> a(WorldServer level, EntityLiving entity, long gameTime) {
        return entity.ev().b().entrySet().stream().map(entry -> {
            MemoryModuleType memoryModuleType = (MemoryModuleType)entry.getKey();
            Optional optional = (Optional)entry.getValue();
            return DebugBrainDump.a(level, gameTime, memoryModuleType, optional);
        }).sorted();
    }

    private static String a(WorldServer level, long gameTime, MemoryModuleType<?> memoryType, Optional<? extends ExpirableMemory<?>> value) {
        Object string;
        if (value.isPresent()) {
            ExpirableMemory<?> expirableValue = value.get();
            Object value1 = expirableValue.c();
            if (memoryType == MemoryModuleType.E) {
                long l2 = gameTime - (Long)value1;
                string = l2 + " ticks ago";
            } else {
                string = expirableValue.e() ? DebugBrainDump.a(level, value1) + " (ttl: " + expirableValue.b() + ")" : DebugBrainDump.a(level, value1);
            }
        } else {
            string = "-";
        }
        return BuiltInRegistries.A.b(memoryType).a() + ": " + (String)string;
    }

    private static String a(WorldServer level, @Nullable Object object) {
        Object object2 = object;
        int n2 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UUID.class, Entity.class, MemoryTarget.class, BehaviorPositionEntity.class, GlobalPos.class, BehaviorTarget.class, DamageSource.class, Collection.class}, (Object)object2, n2)) {
            case -1 -> "-";
            case 0 -> {
                UUID uuid = (UUID)object2;
                yield DebugBrainDump.a(level, level.d(uuid));
            }
            case 1 -> {
                Entity entity = (Entity)object2;
                yield DebugEntityNameGenerator.a(entity);
            }
            case 2 -> {
                MemoryTarget walkTarget = (MemoryTarget)object2;
                yield DebugBrainDump.a(level, walkTarget.a());
            }
            case 3 -> {
                BehaviorPositionEntity entityTracker = (BehaviorPositionEntity)object2;
                yield DebugBrainDump.a(level, entityTracker.c());
            }
            case 4 -> {
                GlobalPos globalPos = (GlobalPos)object2;
                yield DebugBrainDump.a(level, globalPos.b());
            }
            case 5 -> {
                BehaviorTarget blockPosTracker = (BehaviorTarget)object2;
                yield DebugBrainDump.a(level, blockPosTracker.b());
            }
            case 6 -> {
                DamageSource damageSource = (DamageSource)object2;
                Entity entity1 = damageSource.d();
                if (entity1 == null) {
                    yield object.toString();
                }
                yield DebugBrainDump.a(level, entity1);
            }
            case 7 -> {
                Collection collection = (Collection)object2;
                yield "[" + collection.stream().map(object1 -> DebugBrainDump.a(level, object1)).collect(Collectors.joining(", ")) + "]";
            }
            default -> object.toString();
        };
    }

    public boolean a(BlockPosition pos) {
        return this.n.contains(pos);
    }

    public boolean b(BlockPosition pos) {
        return this.o.contains(pos);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{DebugBrainDump.class, "name;profession;xp;health;maxHealth;inventory;wantsGolem;angerLevel;activities;behaviors;memories;gossips;pois;potentialPois", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DebugBrainDump.class, "name;profession;xp;health;maxHealth;inventory;wantsGolem;angerLevel;activities;behaviors;memories;gossips;pois;potentialPois", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DebugBrainDump.class, "name;profession;xp;health;maxHealth;inventory;wantsGolem;angerLevel;activities;behaviors;memories;gossips;pois;potentialPois", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o"}, this, o2);
    }

    public String a() {
        return this.b;
    }

    public String b() {
        return this.c;
    }

    public int c() {
        return this.d;
    }

    public float d() {
        return this.e;
    }

    public float e() {
        return this.f;
    }

    public String f() {
        return this.g;
    }

    public boolean g() {
        return this.h;
    }

    public int h() {
        return this.i;
    }

    public List<String> i() {
        return this.j;
    }

    public List<String> j() {
        return this.k;
    }

    public List<String> k() {
        return this.l;
    }

    public List<String> l() {
        return this.m;
    }

    public Set<BlockPosition> m() {
        return this.n;
    }

    public Set<BlockPosition> n() {
        return this.o;
    }
}

