/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDebugBlockValuePacket;
import net.minecraft.network.protocol.game.ClientboundDebugEntityValuePacket;
import net.minecraft.network.protocol.game.ClientboundDebugEventPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.debug.DebugSubscription;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.util.debug.ServerDebugSubscribers;
import net.minecraft.util.debug.TrackingDebugSynchronizer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.chunk.Chunk;

public class LevelDebugSynchronizers {
    private final WorldServer a;
    private final List<TrackingDebugSynchronizer<?>> b = new ArrayList();
    private final Map<DebugSubscription<?>, TrackingDebugSynchronizer.b<?>> c = new HashMap();
    private final TrackingDebugSynchronizer.a d = new TrackingDebugSynchronizer.a();
    private final TrackingDebugSynchronizer.d e = new TrackingDebugSynchronizer.d();
    private boolean f = true;
    private Set<DebugSubscription<?>> g = Set.of();

    public LevelDebugSynchronizers(WorldServer level) {
        this.a = level;
        for (DebugSubscription debugSubscription : BuiltInRegistries.f) {
            if (debugSubscription.b() == null) continue;
            this.c.put(debugSubscription, new TrackingDebugSynchronizer.b(debugSubscription));
        }
        this.b.addAll(this.c.values());
        this.b.add(this.d);
        this.b.add(this.e);
    }

    public void a(ServerDebugSubscribers subscribers) {
        this.g = subscribers.b();
        boolean isEmpty = this.g.isEmpty();
        if (this.f != isEmpty) {
            this.f = isEmpty;
            if (isEmpty) {
                for (TrackingDebugSynchronizer<?> trackingDebugSynchronizer : this.b) {
                    trackingDebugSynchronizer.a();
                }
            } else {
                this.a();
            }
        }
        if (!this.f) {
            for (TrackingDebugSynchronizer<?> trackingDebugSynchronizer : this.b) {
                trackingDebugSynchronizer.a(this.a);
            }
        }
    }

    private void a() {
        PlayerChunkMap chunkMap = this.a.p().a;
        chunkMap.b(this::a);
        for (Entity entity : this.a.H()) {
            if (!chunkMap.c(entity)) continue;
            this.a(entity);
        }
    }

    <T> TrackingDebugSynchronizer.b<T> b(DebugSubscription<T> subscription) {
        return this.c.get(subscription);
    }

    public void a(final Chunk chunk) {
        if (!this.f) {
            chunk.a(this.a, new DebugValueSource.a(){

                @Override
                public <T> void a(DebugSubscription<T> subscription, DebugValueSource.b<T> getter) {
                    LevelDebugSynchronizers.this.b(subscription).a(chunk.f(), getter);
                }
            });
            chunk.J().values().forEach(this::a);
        }
    }

    public void a(ChunkCoordIntPair chunkPos) {
        if (!this.f) {
            for (TrackingDebugSynchronizer.b<?> sourceSynchronizer : this.c.values()) {
                sourceSynchronizer.a(chunkPos);
            }
        }
    }

    public void a(final TileEntity blockEntity) {
        if (!this.f) {
            blockEntity.a(this.a, new DebugValueSource.a(){

                @Override
                public <T> void a(DebugSubscription<T> subscription, DebugValueSource.b<T> getter) {
                    LevelDebugSynchronizers.this.b(subscription).a(blockEntity.aD_(), getter);
                }
            });
        }
    }

    public void a(BlockPosition pos) {
        if (!this.f) {
            for (TrackingDebugSynchronizer.b<?> sourceSynchronizer : this.c.values()) {
                sourceSynchronizer.a(this.a, pos);
            }
        }
    }

    public void a(final Entity entity) {
        if (!this.f) {
            entity.a(this.a, new DebugValueSource.a(){

                @Override
                public <T> void a(DebugSubscription<T> subscription, DebugValueSource.b<T> getter) {
                    LevelDebugSynchronizers.this.b(subscription).a(entity.cY(), getter);
                }
            });
        }
    }

    public void b(Entity entity) {
        if (!this.f) {
            for (TrackingDebugSynchronizer.b<?> sourceSynchronizer : this.c.values()) {
                sourceSynchronizer.a(entity);
            }
        }
    }

    public void a(EntityPlayer player, ChunkCoordIntPair chunkPos) {
        if (!this.f) {
            for (TrackingDebugSynchronizer<?> trackingDebugSynchronizer : this.b) {
                trackingDebugSynchronizer.a(player, chunkPos);
            }
        }
    }

    public void a(EntityPlayer player, Entity entity) {
        if (!this.f) {
            for (TrackingDebugSynchronizer<?> trackingDebugSynchronizer : this.b) {
                trackingDebugSynchronizer.a(player, entity);
            }
        }
    }

    public void a(VillagePlaceRecord _record) {
        if (!this.f) {
            this.d.a(this.a, _record);
            this.e.a(this.a, _record);
        }
    }

    public void b(BlockPosition pos) {
        if (!this.f) {
            this.d.b(this.a, pos);
        }
    }

    public void c(BlockPosition pos) {
        if (!this.f) {
            this.d.a(this.a, pos);
            this.e.a(this.a, pos);
        }
    }

    public boolean a(DebugSubscription<?> subscription) {
        return this.g.contains(subscription);
    }

    public <T> void a(BlockPosition pos, DebugSubscription<T> subscription, T value) {
        if (this.a(subscription)) {
            this.a(new ChunkCoordIntPair(pos), subscription, (Packet<? super PacketListenerPlayOut>)new ClientboundDebugBlockValuePacket(pos, subscription.a(value)));
        }
    }

    public <T> void a(BlockPosition pos, DebugSubscription<T> subscription) {
        if (this.a(subscription)) {
            this.a(new ChunkCoordIntPair(pos), subscription, (Packet<? super PacketListenerPlayOut>)new ClientboundDebugBlockValuePacket(pos, subscription.a()));
        }
    }

    public <T> void a(Entity entity, DebugSubscription<T> subscription, T value) {
        if (this.a(subscription)) {
            this.a(entity, subscription, (Packet<? super PacketListenerPlayOut>)new ClientboundDebugEntityValuePacket(entity.aA(), subscription.a(value)));
        }
    }

    public <T> void a(Entity entity, DebugSubscription<T> subscription) {
        if (this.a(subscription)) {
            this.a(entity, subscription, (Packet<? super PacketListenerPlayOut>)new ClientboundDebugEntityValuePacket(entity.aA(), subscription.a()));
        }
    }

    public <T> void b(BlockPosition pos, DebugSubscription<T> subscription, T value) {
        if (this.a(subscription)) {
            this.a(new ChunkCoordIntPair(pos), subscription, (Packet<? super PacketListenerPlayOut>)new ClientboundDebugEventPacket(subscription.b(value)));
        }
    }

    private void a(ChunkCoordIntPair chunkPos, DebugSubscription<?> subscription, Packet<? super PacketListenerPlayOut> packet) {
        PlayerChunkMap chunkMap = this.a.p().a;
        for (EntityPlayer serverPlayer : chunkMap.a(chunkPos, false)) {
            if (!serverPlayer.an().contains(subscription)) continue;
            serverPlayer.g.b(packet);
        }
    }

    private void a(Entity entity, DebugSubscription<?> subscription, Packet<? super PacketListenerPlayOut> packet) {
        PlayerChunkMap chunkMap = this.a.p().a;
        chunkMap.a(entity, packet, (EntityPlayer serverPlayer) -> serverPlayer.an().contains(subscription));
    }
}

