/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.debug;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDebugBlockValuePacket;
import net.minecraft.network.protocol.game.ClientboundDebugChunkValuePacket;
import net.minecraft.network.protocol.game.ClientboundDebugEntityValuePacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.Unit;
import net.minecraft.util.debug.DebugPoiInfo;
import net.minecraft.util.debug.DebugSubscription;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.jspecify.annotations.Nullable;

public abstract class TrackingDebugSynchronizer<T> {
    protected final DebugSubscription<T> a;
    private final Set<UUID> b = new ObjectOpenHashSet();

    public TrackingDebugSynchronizer(DebugSubscription<T> subscription) {
        this.a = subscription;
    }

    public final void a(WorldServer level) {
        for (EntityPlayer serverPlayer : level.E()) {
            boolean flag = this.b.contains(serverPlayer.cY());
            boolean flag1 = serverPlayer.an().contains(this.a);
            if (flag1 == flag) continue;
            if (flag1) {
                this.a(serverPlayer);
                continue;
            }
            this.b.remove(serverPlayer.cY());
        }
        this.b.removeIf(uuid -> level.c((UUID)uuid) == null);
        if (!this.b.isEmpty()) {
            this.b(level);
        }
    }

    private void a(EntityPlayer player) {
        this.b.add(player.cY());
        player.X().a((ChunkCoordIntPair chunkPos) -> {
            if (!player.g.h.a(chunkPos.b())) {
                this.a(player, (ChunkCoordIntPair)chunkPos);
            }
        });
        player.A().p().a.a(player, (Entity entity) -> this.a(player, (Entity)entity));
    }

    protected final void a(WorldServer level, ChunkCoordIntPair chunkPos, Packet<? super PacketListenerPlayOut> packet) {
        PlayerChunkMap chunkMap = level.p().a;
        for (UUID uuid : this.b) {
            EntityPlayer serverPlayer;
            EntityHuman entityHuman = level.c(uuid);
            if (!(entityHuman instanceof EntityPlayer) || !chunkMap.a(serverPlayer = (EntityPlayer)entityHuman, chunkPos.h, chunkPos.i)) continue;
            serverPlayer.g.b(packet);
        }
    }

    protected final void a(WorldServer level, Entity entity, Packet<? super PacketListenerPlayOut> packet) {
        PlayerChunkMap chunkMap = level.p().a;
        chunkMap.a(entity, packet, (EntityPlayer serverPlayer) -> this.b.contains(serverPlayer.cY()));
    }

    public final void a(EntityPlayer player, ChunkCoordIntPair chunkPos) {
        if (this.b.contains(player.cY())) {
            this.b(player, chunkPos);
        }
    }

    public final void a(EntityPlayer player, Entity entity) {
        if (this.b.contains(player.cY())) {
            this.b(player, entity);
        }
    }

    protected void a() {
    }

    protected void b(WorldServer level) {
    }

    protected void b(EntityPlayer player, ChunkCoordIntPair chunkPos) {
    }

    protected void b(EntityPlayer player, Entity entity) {
    }

    public static class d
    extends TrackingDebugSynchronizer<Unit> {
        public d() {
            super(DebugSubscriptions.k);
        }

        @Override
        protected void b(EntityPlayer player, ChunkCoordIntPair chunkPos) {
            WorldServer serverLevel = player.A();
            VillagePlace poiManager = serverLevel.F();
            poiManager.a((Holder<VillagePlaceType> holder) -> true, chunkPos, VillagePlace.Occupancy.c).forEach(poiRecord -> {
                SectionPosition sectionPos = SectionPosition.a(poiRecord.g());
                d.a(serverLevel, sectionPos, (sectionPos1, _boolean) -> {
                    BlockPosition blockPos = sectionPos1.k();
                    player.g.b(new ClientboundDebugBlockValuePacket(blockPos, this.a.a(_boolean != false ? Unit.a : null)));
                });
            });
        }

        public void a(WorldServer level, VillagePlaceRecord _record) {
            this.b(level, _record.g());
        }

        public void a(WorldServer level, BlockPosition pos) {
            this.b(level, pos);
        }

        private void b(WorldServer level, BlockPosition pos) {
            d.a(level, SectionPosition.a(pos), (sectionPos, _boolean) -> {
                BlockPosition blockPos = sectionPos.k();
                if (_boolean.booleanValue()) {
                    this.a(level, new ChunkCoordIntPair(blockPos), (Packet<PacketListenerPlayOut>)new ClientboundDebugBlockValuePacket(blockPos, this.a.a(Unit.a)));
                } else {
                    this.a(level, new ChunkCoordIntPair(blockPos), (Packet<PacketListenerPlayOut>)new ClientboundDebugBlockValuePacket(blockPos, this.a.a()));
                }
            });
        }

        private static void a(WorldServer level, SectionPosition pos, BiConsumer<SectionPosition, Boolean> action) {
            for (int i2 = -1; i2 <= 1; ++i2) {
                for (int i1 = -1; i1 <= 1; ++i1) {
                    for (int i22 = -1; i22 <= 1; ++i22) {
                        SectionPosition sectionPos = pos.d(i1, i22, i2);
                        if (level.e(sectionPos.k())) {
                            action.accept(sectionPos, true);
                            continue;
                        }
                        action.accept(sectionPos, false);
                    }
                }
            }
        }
    }

    static class c<T> {
        private final DebugValueSource.b<T> a;
        @Nullable T b;

        c(DebugValueSource.b<T> getter) {
            this.a = getter;
        }

        public @Nullable DebugSubscription.b<T> a(DebugSubscription<T> subscription) {
            T object = this.a.get();
            if (!Objects.equals(object, this.b)) {
                this.b = object;
                return subscription.a(object);
            }
            return null;
        }
    }

    public static class b<T>
    extends TrackingDebugSynchronizer<T> {
        private final Map<ChunkCoordIntPair, c<T>> b = new HashMap<ChunkCoordIntPair, c<T>>();
        private final Map<BlockPosition, c<T>> c = new HashMap<BlockPosition, c<T>>();
        private final Map<UUID, c<T>> d = new HashMap<UUID, c<T>>();

        public b(DebugSubscription<T> subscription) {
            super(subscription);
        }

        @Override
        protected void a() {
            this.b.clear();
            this.c.clear();
            this.d.clear();
        }

        @Override
        protected void b(WorldServer level) {
            DebugSubscription.b<T> update;
            for (Map.Entry<ChunkCoordIntPair, c<T>> entry : this.b.entrySet()) {
                update = entry.getValue().a(this.a);
                if (update == null) continue;
                ChunkCoordIntPair chunkPos = entry.getKey();
                this.a(level, chunkPos, (Packet<PacketListenerPlayOut>)new ClientboundDebugChunkValuePacket(chunkPos, update));
            }
            for (Map.Entry<Object, c<T>> entry : this.c.entrySet()) {
                update = entry.getValue().a(this.a);
                if (update == null) continue;
                BlockPosition blockPos = (BlockPosition)entry.getKey();
                ChunkCoordIntPair chunkPos1 = new ChunkCoordIntPair(blockPos);
                this.a(level, chunkPos1, (Packet<PacketListenerPlayOut>)new ClientboundDebugBlockValuePacket(blockPos, update));
            }
            for (Map.Entry<Object, c<T>> entry : this.d.entrySet()) {
                update = entry.getValue().a(this.a);
                if (update == null) continue;
                Entity entity = Objects.requireNonNull(level.d((UUID)entry.getKey()));
                this.a(level, entity, (Packet<PacketListenerPlayOut>)new ClientboundDebugEntityValuePacket(entity.aA(), update));
            }
        }

        public void a(ChunkCoordIntPair chunkPos, DebugValueSource.b<T> getter) {
            this.b.put(chunkPos, new c<T>(getter));
        }

        public void a(BlockPosition pos, DebugValueSource.b<T> getter) {
            this.c.put(pos, new c<T>(getter));
        }

        public void a(UUID id, DebugValueSource.b<T> getter) {
            this.d.put(id, new c<T>(getter));
        }

        public void a(ChunkCoordIntPair chunkPos) {
            this.b.remove(chunkPos);
            this.c.keySet().removeIf(chunkPos::b);
        }

        public void a(WorldServer level, BlockPosition pos) {
            c<T> valueSource = this.c.remove(pos);
            if (valueSource != null) {
                ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(pos);
                this.a(level, chunkPos, (Packet<PacketListenerPlayOut>)new ClientboundDebugBlockValuePacket(pos, this.a.a()));
            }
        }

        public void a(Entity entity) {
            this.d.remove(entity.cY());
        }

        @Override
        protected void b(EntityPlayer player, ChunkCoordIntPair chunkPos) {
            c<T> valueSource = this.b.get(chunkPos);
            if (valueSource != null && valueSource.b != null) {
                player.g.b(new ClientboundDebugChunkValuePacket(chunkPos, this.a.a(valueSource.b)));
            }
            for (Map.Entry<BlockPosition, c<T>> entry : this.c.entrySet()) {
                BlockPosition blockPos;
                Object object = entry.getValue().b;
                if (object == null || !chunkPos.b(blockPos = entry.getKey())) continue;
                player.g.b(new ClientboundDebugBlockValuePacket(blockPos, this.a.a(object)));
            }
        }

        @Override
        protected void b(EntityPlayer player, Entity entity) {
            c<T> valueSource = this.d.get(entity.cY());
            if (valueSource != null && valueSource.b != null) {
                player.g.b(new ClientboundDebugEntityValuePacket(entity.aA(), this.a.a(valueSource.b)));
            }
        }
    }

    public static class a
    extends TrackingDebugSynchronizer<DebugPoiInfo> {
        public a() {
            super(DebugSubscriptions.i);
        }

        @Override
        protected void b(EntityPlayer player, ChunkCoordIntPair chunkPos) {
            WorldServer serverLevel = player.A();
            VillagePlace poiManager = serverLevel.F();
            poiManager.a((Holder<VillagePlaceType> holder) -> true, chunkPos, VillagePlace.Occupancy.c).forEach(poiRecord -> player.g.b(new ClientboundDebugBlockValuePacket(poiRecord.g(), this.a.a(new DebugPoiInfo((VillagePlaceRecord)poiRecord)))));
        }

        public void a(WorldServer level, VillagePlaceRecord _record) {
            this.a(level, new ChunkCoordIntPair(_record.g()), (Packet<PacketListenerPlayOut>)new ClientboundDebugBlockValuePacket(_record.g(), this.a.a(new DebugPoiInfo(_record))));
        }

        public void a(WorldServer level, BlockPosition pos) {
            this.a(level, new ChunkCoordIntPair(pos), (Packet<PacketListenerPlayOut>)new ClientboundDebugBlockValuePacket(pos, this.a.a()));
        }

        public void b(WorldServer level, BlockPosition pos) {
            this.a(level, new ChunkCoordIntPair(pos), (Packet<PacketListenerPlayOut>)new ClientboundDebugBlockValuePacket(pos, this.a.a(level.F().d(pos))));
        }
    }
}

