/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.eventlog;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class EventLogDirectory {
    static final Logger a = LogUtils.getLogger();
    private static final int b = 4096;
    private static final String c = ".gz";
    private final Path d;
    private final String e;

    private EventLogDirectory(Path root, String extension) {
        this.d = root;
        this.e = extension;
    }

    public static EventLogDirectory a(Path root, String extension) throws IOException {
        Files.createDirectories(root, new FileAttribute[0]);
        return new EventLogDirectory(root, extension);
    }

    public d a() throws IOException {
        d var2;
        try (Stream<Path> stream = Files.list(this.d);){
            var2 = new d(stream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).map(this::a).filter(Objects::nonNull).toList());
        }
        return var2;
    }

    private @Nullable b a(Path path) {
        String string = path.getFileName().toString();
        int index = string.indexOf(46);
        if (index == -1) {
            return null;
        }
        c fileId = net.minecraft.util.eventlog.EventLogDirectory$c.a(string.substring(0, index));
        if (fileId != null) {
            String sub = string.substring(index);
            if (sub.equals(this.e)) {
                return new e(path, fileId);
            }
            if (sub.equals(this.e + c)) {
                return new a(path, fileId);
            }
        }
        return null;
    }

    static void a(Path path, Path outputPath) throws IOException {
        if (Files.exists(outputPath, new LinkOption[0])) {
            throw new IOException("Compressed target file already exists: " + String.valueOf(outputPath));
        }
        try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.READ);){
            FileLock fileLock = fileChannel.tryLock();
            if (fileLock == null) {
                throw new IOException("Raw log file is already locked, cannot compress: " + String.valueOf(path));
            }
            EventLogDirectory.a(fileChannel, outputPath);
            fileChannel.truncate(0L);
        }
        Files.delete(path);
    }

    private static void a(ReadableByteChannel channel, Path outputPath) throws IOException {
        try (GZIPOutputStream outputStream = new GZIPOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));){
            byte[] bytes = new byte[4096];
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            while (channel.read(byteBuffer) >= 0) {
                byteBuffer.flip();
                ((OutputStream)outputStream).write(bytes, 0, byteBuffer.limit());
                byteBuffer.clear();
            }
        }
    }

    public e a(LocalDate date) throws IOException {
        c fileId;
        int i2 = 1;
        Set<c> set = this.a().c();
        while (set.contains(fileId = new c(date, i2++))) {
        }
        e rawFile = new e(this.d.resolve(fileId.b(this.e)), fileId);
        Files.createFile(rawFile.c(), new FileAttribute[0]);
        return rawFile;
    }

    public static class d
    implements Iterable<b> {
        private final List<b> a;

        d(List<b> files) {
            this.a = new ArrayList<b>(files);
        }

        public d a(LocalDate date, int daysToKeep) {
            this.a.removeIf(file -> {
                c fileId = file.d();
                LocalDate localDate = fileId.a().plusDays(daysToKeep);
                if (!date.isBefore(localDate)) {
                    try {
                        Files.delete(file.c());
                        return true;
                    }
                    catch (IOException var6) {
                        a.warn("Failed to delete expired event log file: {}", (Object)file.c(), (Object)var6);
                    }
                }
                return false;
            });
            return this;
        }

        public d a() {
            ListIterator<b> listIterator = this.a.listIterator();
            while (listIterator.hasNext()) {
                b file = listIterator.next();
                try {
                    listIterator.set(file.b());
                }
                catch (IOException var4) {
                    a.warn("Failed to compress event log file: {}", (Object)file.c(), (Object)var4);
                }
            }
            return this;
        }

        @Override
        public Iterator<b> iterator() {
            return this.a.iterator();
        }

        public Stream<b> b() {
            return this.a.stream();
        }

        public Set<c> c() {
            return this.a.stream().map(b::d).collect(Collectors.toSet());
        }
    }

    public record c(LocalDate a, int b) {
        private static final DateTimeFormatter c = DateTimeFormatter.BASIC_ISO_DATE;

        public static @Nullable c a(String fileName) {
            int index = fileName.indexOf("-");
            if (index == -1) {
                return null;
            }
            String sub = fileName.substring(0, index);
            String sub1 = fileName.substring(index + 1);
            try {
                return new c(LocalDate.parse(sub, c), Integer.parseInt(sub1));
            }
            catch (NumberFormatException | DateTimeParseException var5) {
                return null;
            }
        }

        @Override
        public String toString() {
            return c.format(this.a) + "-" + this.b;
        }

        public String b(String extension) {
            return String.valueOf(this) + extension;
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "date;index", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "date;index", "a", "b"}, this, o2);
        }
    }

    public record e(Path a, c b) implements b
    {
        private final Path a;
        private final c b;

        public FileChannel e() throws IOException {
            return FileChannel.open(this.a, StandardOpenOption.WRITE, StandardOpenOption.READ);
        }

        @Override
        public @Nullable Reader a() throws IOException {
            return Files.exists(this.a, new LinkOption[0]) ? Files.newBufferedReader(this.a) : null;
        }

        @Override
        public a b() throws IOException {
            Path path = this.a.resolveSibling(this.a.getFileName().toString() + EventLogDirectory.c);
            EventLogDirectory.a(this.a, path);
            return new a(path, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "path;id", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "path;id", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "path;id", "a", "b"}, this, o2);
        }

        @Override
        public Path c() {
            return this.a;
        }

        @Override
        public c d() {
            return this.b;
        }
    }

    public record a(Path a, c b) implements b
    {
        private final Path a;
        private final c b;

        @Override
        public @Nullable Reader a() throws IOException {
            return !Files.exists(this.a, new LinkOption[0]) ? null : new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(Files.newInputStream(this.a, new OpenOption[0])), StandardCharsets.UTF_8));
        }

        @Override
        public a b() {
            return this;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "path;id", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "path;id", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "path;id", "a", "b"}, this, o2);
        }

        @Override
        public Path c() {
            return this.a;
        }

        @Override
        public c d() {
            return this.b;
        }
    }

    public static interface b {
        public Path c();

        public c d();

        public @Nullable Reader a() throws IOException;

        public a b() throws IOException;
    }
}

