/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import java.io.BufferedWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.ReportType;
import net.minecraft.SharedConstants;
import net.minecraft.util.profiling.MethodProfilerResult;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.MethodProfilerResultsField;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;

public class MethodProfilerResultsFilled
implements MethodProfilerResults {
    private static final Logger a = LogUtils.getLogger();
    private static final MethodProfilerResult b = new MethodProfilerResult(){

        @Override
        public long a() {
            return 0L;
        }

        @Override
        public long b() {
            return 0L;
        }

        @Override
        public long c() {
            return 0L;
        }

        @Override
        public Object2LongMap<String> d() {
            return Object2LongMaps.emptyMap();
        }
    };
    private static final Splitter c = Splitter.on((char)'\u001e');
    private static final Comparator<Map.Entry<String, a>> e = Map.Entry.comparingByValue(Comparator.comparingLong(counterCollector -> counterCollector.b)).reversed();
    private final Map<String, ? extends MethodProfilerResult> f;
    private final long g;
    private final int h;
    private final long i;
    private final int j;
    private final int k;

    public MethodProfilerResultsFilled(Map<String, ? extends MethodProfilerResult> entries, long startTimeNano, int startTimeTicks, long endTimeNano, int endTimeTicks) {
        this.f = entries;
        this.g = startTimeNano;
        this.h = startTimeTicks;
        this.i = endTimeNano;
        this.j = endTimeTicks;
        this.k = endTimeTicks - startTimeTicks;
    }

    private MethodProfilerResult c(String key) {
        MethodProfilerResult profilerPathEntry = this.f.get(key);
        return profilerPathEntry != null ? profilerPathEntry : b;
    }

    @Override
    public List<MethodProfilerResultsField> a(String sectionPath) {
        String string = sectionPath;
        MethodProfilerResult entry = this.c("root");
        long duration = entry.a();
        MethodProfilerResult entry1 = this.c((String)sectionPath);
        long duration1 = entry1.a();
        long count = entry1.c();
        ArrayList list = Lists.newArrayList();
        if (!((String)sectionPath).isEmpty()) {
            sectionPath = (String)sectionPath + "\u001e";
        }
        long l2 = 0L;
        for (String string1 : this.f.keySet()) {
            if (!MethodProfilerResultsFilled.a((String)sectionPath, string1)) continue;
            l2 += this.c(string1).a();
        }
        float f2 = l2;
        if (l2 < duration1) {
            l2 = duration1;
        }
        if (duration < l2) {
            duration = l2;
        }
        for (String string2 : this.f.keySet()) {
            if (!MethodProfilerResultsFilled.a((String)sectionPath, string2)) continue;
            MethodProfilerResult entry2 = this.c(string2);
            long duration2 = entry2.a();
            double d2 = (double)duration2 * 100.0 / (double)l2;
            double d1 = (double)duration2 * 100.0 / (double)duration;
            String sub = string2.substring(((String)sectionPath).length());
            list.add(new MethodProfilerResultsField(sub, d2, d1, entry2.c()));
        }
        if ((float)l2 > f2) {
            list.add(new MethodProfilerResultsField("unspecified", (double)((float)l2 - f2) * 100.0 / (double)l2, (double)((float)l2 - f2) * 100.0 / (double)duration, count));
        }
        Collections.sort(list);
        list.add(0, new MethodProfilerResultsField(string, 100.0, (double)l2 * 100.0 / (double)duration, count));
        return list;
    }

    private static boolean a(String sectionPath, String entry) {
        return entry.length() > sectionPath.length() && entry.startsWith(sectionPath) && entry.indexOf(30, sectionPath.length() + 1) < 0;
    }

    private Map<String, a> h() {
        TreeMap map = Maps.newTreeMap();
        this.f.forEach((string, profilerPathEntry) -> {
            Object2LongMap<String> counters = profilerPathEntry.d();
            if (!counters.isEmpty()) {
                List parts = c.splitToList((CharSequence)string);
                counters.forEach((string1, l2) -> map.computeIfAbsent(string1, string2 -> new a()).a(parts.iterator(), l2));
            }
        });
        return map;
    }

    @Override
    public long a() {
        return this.g;
    }

    @Override
    public int b() {
        return this.h;
    }

    @Override
    public long c() {
        return this.i;
    }

    @Override
    public int d() {
        return this.j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean a(Path path) {
        boolean bl;
        BufferedWriter writer = null;
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);
            writer.write(this.a(this.g(), this.f()));
            bl = true;
        }
        catch (Throwable var8) {
            boolean var4;
            try {
                a.error("Could not save profiler results to {}", (Object)path, (Object)var8);
                var4 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
            return var4;
        }
        IOUtils.closeQuietly((Writer)writer);
        return bl;
    }

    protected String a(long timeSpan, int tickSpan) {
        StringBuilder stringBuilder = new StringBuilder();
        ReportType.b.a(stringBuilder, List.of());
        stringBuilder.append("Version: ").append(SharedConstants.b().b()).append('\n');
        stringBuilder.append("Time span: ").append(timeSpan / 1000000L).append(" ms\n");
        stringBuilder.append("Tick span: ").append(tickSpan).append(" ticks\n");
        stringBuilder.append("// This is approximately ").append(String.format(Locale.ROOT, "%.2f", Float.valueOf((float)tickSpan / ((float)timeSpan / 1.0E9f)))).append(" ticks per second. It should be ").append(20).append(" ticks per second\n\n");
        stringBuilder.append("--- BEGIN PROFILE DUMP ---\n\n");
        this.a(0, "root", stringBuilder);
        stringBuilder.append("--- END PROFILE DUMP ---\n\n");
        Map<String, a> counterValues = this.h();
        if (!counterValues.isEmpty()) {
            stringBuilder.append("--- BEGIN COUNTER DUMP ---\n\n");
            this.a(counterValues, stringBuilder, tickSpan);
            stringBuilder.append("--- END COUNTER DUMP ---\n\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public String e() {
        StringBuilder stringBuilder = new StringBuilder();
        this.a(0, "root", stringBuilder);
        return stringBuilder.toString();
    }

    private static StringBuilder a(StringBuilder builder, int indents) {
        builder.append(String.format(Locale.ROOT, "[%02d] ", indents));
        for (int i2 = 0; i2 < indents; ++i2) {
            builder.append("|   ");
        }
        return builder;
    }

    private void a(int depth, String sectionPath, StringBuilder builder) {
        List<MethodProfilerResultsField> times = this.a(sectionPath);
        Object2LongMap<String> counters = ((MethodProfilerResult)ObjectUtils.firstNonNull((Object[])new MethodProfilerResult[]{this.f.get(sectionPath), b})).d();
        counters.forEach((string, l2) -> MethodProfilerResultsFilled.a(builder, depth).append('#').append((String)string).append(' ').append(l2).append('/').append(l2 / (long)this.k).append('\n'));
        if (times.size() >= 3) {
            for (int i2 = 1; i2 < times.size(); ++i2) {
                MethodProfilerResultsField resultField = times.get(i2);
                MethodProfilerResultsFilled.a(builder, depth).append(resultField.d).append('(').append(resultField.c).append('/').append(String.format(Locale.ROOT, "%.0f", Float.valueOf((float)resultField.c / (float)this.k))).append(')').append(" - ").append(String.format(Locale.ROOT, "%.2f", resultField.a)).append("%/").append(String.format(Locale.ROOT, "%.2f", resultField.b)).append("%\n");
                if ("unspecified".equals(resultField.d)) continue;
                try {
                    this.a(depth + 1, sectionPath + "\u001e" + resultField.d, builder);
                    continue;
                }
                catch (Exception var9) {
                    builder.append("[[ EXCEPTION ").append(var9).append(" ]]");
                }
            }
        }
    }

    private void a(int indents, String name, a collector, int tickSpan, StringBuilder builder) {
        MethodProfilerResultsFilled.a(builder, indents).append(name).append(" total:").append(collector.a).append('/').append(collector.b).append(" average: ").append(collector.a / (long)tickSpan).append('/').append(collector.b / (long)tickSpan).append('\n');
        collector.c.entrySet().stream().sorted(e).forEach(entry -> this.a(indents + 1, (String)entry.getKey(), (a)entry.getValue(), tickSpan, builder));
    }

    private void a(Map<String, a> counters, StringBuilder builder, int tickSpan) {
        counters.forEach((string, counterCollector) -> {
            builder.append("-- Counter: ").append((String)string).append(" --\n");
            this.a(0, "root", counterCollector.c.get("root"), tickSpan, builder);
            builder.append("\n\n");
        });
    }

    @Override
    public int f() {
        return this.k;
    }

    static class a {
        long a;
        long b;
        final Map<String, a> c = Maps.newHashMap();

        a() {
        }

        public void a(Iterator<String> counters, long value) {
            this.b += value;
            if (!counters.hasNext()) {
                this.a += value;
            } else {
                this.c.computeIfAbsent(counters.next(), string -> new a()).a(counters, value);
            }
        }
    }
}

