/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.stats;

import com.google.common.base.MoreObjects;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedThread;

public record ThreadAllocationStat(Instant a, String b, long c) {
    private static final String d = "unknown";

    public static ThreadAllocationStat a(RecordedEvent event) {
        RecordedThread thread = event.getThread("thread");
        String string = thread == null ? d : (String)MoreObjects.firstNonNull((Object)thread.getJavaName(), (Object)d);
        return new ThreadAllocationStat(event.getStartTime(), string, event.getLong("allocated"));
    }

    public static a a(List<ThreadAllocationStat> stats) {
        TreeMap<String, Double> map = new TreeMap<String, Double>();
        Map<String, List<ThreadAllocationStat>> map1 = stats.stream().collect(Collectors.groupingBy(threadAllocationStat -> threadAllocationStat.b));
        map1.forEach((string, list) -> {
            if (list.size() >= 2) {
                ThreadAllocationStat threadAllocationStat = (ThreadAllocationStat)list.get(0);
                ThreadAllocationStat threadAllocationStat1 = (ThreadAllocationStat)list.get(list.size() - 1);
                long seconds = Duration.between(threadAllocationStat.a, threadAllocationStat1.a).getSeconds();
                long l2 = threadAllocationStat1.c - threadAllocationStat.c;
                map.put((String)string, (double)l2 / (double)seconds);
            }
        });
        return new a(map);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ThreadAllocationStat.class, "timestamp;threadName;totalBytes", "a", "b", "c"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ThreadAllocationStat.class, "timestamp;threadName;totalBytes", "a", "b", "c"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ThreadAllocationStat.class, "timestamp;threadName;totalBytes", "a", "b", "c"}, this, o2);
    }

    public record a(Map<String, Double> a) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "allocationsPerSecondByThread", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "allocationsPerSecondByThread", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "allocationsPerSecondByThread", "a"}, this, o2);
        }
    }
}

