/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.stats;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.profiling.jfr.Percentiles;
import net.minecraft.util.profiling.jfr.stats.TimedStat;
import org.jspecify.annotations.Nullable;

public record TimedStatSummary<T extends TimedStat>(T a, T b, @Nullable T c, int d, Map<Integer, Double> e, Duration f) {
    public static <T extends TimedStat> Optional<TimedStatSummary<T>> a(List<T> stats) {
        if (stats.isEmpty()) {
            return Optional.empty();
        }
        List<TimedStat> list = stats.stream().sorted(Comparator.comparing(TimedStat::a)).toList();
        Duration duration = list.stream().map(TimedStat::a).reduce(Duration::plus).orElse(Duration.ZERO);
        TimedStat timedStat = list.getFirst();
        TimedStat timedStat1 = list.getLast();
        TimedStat timedStat2 = list.size() > 1 ? list.get(list.size() - 2) : null;
        int size = list.size();
        Map<Integer, Double> map = Percentiles.a(list.stream().mapToLong(timedStat3 -> timedStat3.a().toNanos()).toArray());
        return Optional.of(new TimedStatSummary<TimedStat>(timedStat, timedStat1, timedStat2, size, map, duration));
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{TimedStatSummary.class, "fastest;slowest;secondSlowest;count;percentilesNanos;totalDuration", "a", "b", "c", "d", "e", "f"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TimedStatSummary.class, "fastest;slowest;secondSlowest;count;percentilesNanos;totalDuration", "a", "b", "c", "d", "e", "f"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TimedStatSummary.class, "fastest;slowest;secondSlowest;count;percentilesNanos;totalDuration", "a", "b", "c", "d", "e", "f"}, this, o2);
    }
}

