/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.metrics;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.ToDoubleFunction;
import net.minecraft.util.profiling.metrics.MetricCategory;
import org.jspecify.annotations.Nullable;

public class MetricSampler {
    private final String b;
    private final MetricCategory c;
    private final DoubleSupplier d;
    private final ByteBuf e;
    private final ByteBuf f;
    private volatile boolean g;
    private final @Nullable Runnable h;
    final @Nullable c a;
    private double i;

    protected MetricSampler(String name, MetricCategory category, DoubleSupplier sampler, @Nullable Runnable beforeTick, @Nullable c thresholdTest) {
        this.b = name;
        this.c = category;
        this.h = beforeTick;
        this.d = sampler;
        this.a = thresholdTest;
        this.f = ByteBufAllocator.DEFAULT.buffer();
        this.e = ByteBufAllocator.DEFAULT.buffer();
        this.g = true;
    }

    public static MetricSampler a(String name, MetricCategory category, DoubleSupplier sampler) {
        return new MetricSampler(name, category, sampler, null, null);
    }

    public static <T> MetricSampler a(String name, MetricCategory category, T context, ToDoubleFunction<T> sampler) {
        return MetricSampler.a(name, category, sampler, context).a();
    }

    public static <T> a<T> a(String name, MetricCategory category, ToDoubleFunction<T> sampler, T context) {
        if (sampler == null) {
            throw new IllegalStateException();
        }
        return new a<T>(name, category, sampler, context);
    }

    public void a() {
        if (!this.g) {
            throw new IllegalStateException("Not running");
        }
        if (this.h != null) {
            this.h.run();
        }
    }

    public void a(int tickTime) {
        this.h();
        this.i = this.d.getAsDouble();
        this.f.writeDouble(this.i);
        this.e.writeInt(tickTime);
    }

    public void b() {
        this.h();
        this.f.release();
        this.e.release();
        this.g = false;
    }

    private void h() {
        if (!this.g) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Sampler for metric %s not started!", this.b));
        }
    }

    DoubleSupplier c() {
        return this.d;
    }

    public String d() {
        return this.b;
    }

    public MetricCategory e() {
        return this.c;
    }

    public b f() {
        Int2DoubleOpenHashMap map = new Int2DoubleOpenHashMap();
        int i2 = Integer.MIN_VALUE;
        int i1 = Integer.MIN_VALUE;
        while (this.f.isReadable(8)) {
            int _int = this.e.readInt();
            if (i2 == Integer.MIN_VALUE) {
                i2 = _int;
            }
            map.put(_int, this.f.readDouble());
            i1 = _int;
        }
        return new b(i2, i1, (Int2DoubleMap)map);
    }

    public boolean g() {
        return this.a != null && this.a.test(this.i);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            MetricSampler metricSampler = (MetricSampler)other;
            return this.b.equals(metricSampler.b) && this.c.equals((Object)metricSampler.c);
        }
        return false;
    }

    public int hashCode() {
        return this.b.hashCode();
    }

    public static interface c {
        public boolean test(double var1);
    }

    public static class a<T> {
        private final String a;
        private final MetricCategory b;
        private final DoubleSupplier c;
        private final T d;
        private @Nullable Runnable e;
        private @Nullable c f;

        public a(String name, MetricCategory category, ToDoubleFunction<T> sampler, T context) {
            this.a = name;
            this.b = category;
            this.c = () -> sampler.applyAsDouble(context);
            this.d = context;
        }

        public a<T> a(Consumer<T> beforeTick) {
            this.e = () -> beforeTick.accept(this.d);
            return this;
        }

        public a<T> a(c thresholdTest) {
            this.f = thresholdTest;
            return this;
        }

        public MetricSampler a() {
            return new MetricSampler(this.a, this.b, this.c, this.e, this.f);
        }
    }

    public static class b {
        private final Int2DoubleMap a;
        private final int b;
        private final int c;

        public b(int firstTick, int lastTick, Int2DoubleMap recording) {
            this.b = firstTick;
            this.c = lastTick;
            this.a = recording;
        }

        public double a(int tick) {
            return this.a.get(tick);
        }

        public int a() {
            return this.b;
        }

        public int b() {
            return this.c;
        }
    }

    public static class d
    implements c {
        private final float a;
        private double b = Double.MIN_VALUE;

        public d(float percentageIncreaseThreshold) {
            this.a = percentageIncreaseThreshold;
        }

        @Override
        public boolean test(double value) {
            boolean flag = this.b != Double.MIN_VALUE && !(value <= this.b) ? (value - this.b) / this.b >= (double)this.a : false;
            this.b = value;
            return flag;
        }
    }
}

